/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.AbstractEventPair;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.SodConfig;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.Version;
import edu.sc.seis.sod.hibernate.RecordSectionItem;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodDB
extends AbstractHibernateDB {
    private static final Logger logger = LoggerFactory.getLogger(SodDB.class);
    static String configFile = "edu/sc/seis/sod/hibernate/sod.hbm.xml";
    TimeInterval minRetryDelay = new TimeInterval(2.0, UnitImpl.HOUR);
    float maxRetryDelay = (float)Start.getRunProps().getMaxRetryDelay().getValue(UnitImpl.SECOND);
    float seismogramLatency = (float)Start.getRunProps().getSeismogramLatency().getValue(UnitImpl.SECOND);
    int maxRetries = 5;
    float retryBase = 2.0f;
    private static final String MATCH_CHANNEL_CODES = " channel.id.channel_code = :chanCode and channel.id.site_code = :siteCode and channel.id.station_code = :staCode and channel.site.station.networkAttr.id.network_code = :netCode";
    private Queue<AbstractEventChannelPair> retryToDo = new LinkedList<AbstractEventChannelPair>();
    private Queue<EventNetworkPair> enpToDo = new LinkedList<EventNetworkPair>();
    private Queue<EventStationPair> espToDo = new LinkedList<EventStationPair>();
    private Queue<AbstractEventChannelPair> ecpToDo = new LinkedList<AbstractEventChannelPair>();
    private String retry;
    private String failed;
    private String success;
    private String successPerEvent;
    private String failedPerEvent;
    private String retryPerEvent;
    private String successPerEventStation;
    private String failedPerEventStation;
    private String retryPerEventStation;
    private String totalSuccess;
    private String eventBase;
    private static final String COUNT = "SELECT COUNT(*) ";
    private String espFromNet;
    public static Class<? extends AbstractEventChannelPair> defaultEcpClass = null;
    public Class<? extends AbstractEventChannelPair> ecpClass = null;
    private static SodDB singleton;

    protected SodDB() {
    }

    public static void configHibernate(Configuration config) {
        logger.debug("adding to HibernateUtil   " + configFile);
        config.addResource(configFile, SodDB.class.getClassLoader());
        if (ConnMgr.getURL().startsWith("jdbc:hsql")) {
            config.addSqlFunction("datediff", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "datediff(?1, ?2, ?3)"));
            config.addSqlFunction("milliseconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "datediff('ms', ?1, ?2)"));
            config.addSqlFunction("seconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "datediff('ss', ?1, ?2)"));
        } else if (ConnMgr.getURL().startsWith("jdbc:postgresql")) {
            config.addSqlFunction("milliseconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "extract(epoch from (?2 - ?1)) * 1000"));
            config.addSqlFunction("seconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "extract(epoch from (?2 - ?1))"));
        }
    }

    public void reopenSuspendedEventChannelPairs(String processingRule, boolean vector) {
        Stage[] stages = new Stage[]{Stage.EVENT_CHANNEL_POPULATION, Stage.EVENT_STATION_SUBSETTER, Stage.EVENT_CHANNEL_SUBSETTER, Stage.REQUEST_SUBSETTER, Stage.AVAILABLE_DATA_SUBSETTER, Stage.DATA_RETRIEVAL, Stage.PROCESSOR};
        String stageList = " ( ";
        for (int i = 0; i < stages.length; ++i) {
            stageList = stageList + stages[i].getVal() + ", ";
        }
        stageList = stageList.substring(0, stageList.length() - 2);
        stageList = stageList + " ) ";
        Standing[] standings = new Standing[]{Standing.IN_PROG, Standing.INIT, Standing.SUCCESS};
        String standingList = " ( ";
        for (int i = 0; i < standings.length; ++i) {
            standingList = standingList + standings[i].getVal() + ", ";
        }
        standingList = standingList.substring(0, standingList.length() - 2);
        standingList = standingList + " ) ";
        String setStmt = processingRule.equals("atLeastOnce") ? " stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + ", standingInt = " + Standing.INIT.getVal() : " standingInt = " + Standing.SYSTEM_FAILURE.getVal();
        String queryEnd = " set " + setStmt + " WHERE status.stageInt in " + stageList + " AND status.standingInt in " + standingList + " AND NOT (status.stageInt = " + Stage.PROCESSOR.getVal() + " AND status.standingInt = " + Standing.SUCCESS.getVal() + " ) " + " AND NOT (status.stageInt = " + Stage.EVENT_STATION_SUBSETTER.getVal() + " AND status.standingInt = " + Standing.INIT.getVal() + " ) ";
        String query = "UPDATE " + EventChannelPair.class.getName() + queryEnd;
        int out = SodDB.getSession().createQuery(query).executeUpdate();
        query = "UPDATE " + EventVectorPair.class.getName() + queryEnd;
        out += SodDB.getSession().createQuery(query).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventNetworkPair createEventNetworkPair(StatefulEvent event, NetworkAttrImpl net) {
        Session session = SodDB.getSession();
        EventNetworkPair enp = new EventNetworkPair(event, (NetworkAttrImpl)session.merge((Object)net), Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
        logger.debug("Put " + enp);
        session.save((Object)enp);
        Queue<EventNetworkPair> queue = this.enpToDo;
        synchronized (queue) {
            this.enpToDo.offer(enp);
        }
        return enp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerEventNetworkPairs(List<EventNetworkPair> staPairList) {
        for (EventNetworkPair pair : staPairList) {
            Queue<EventNetworkPair> queue = this.enpToDo;
            synchronized (queue) {
                this.enpToDo.offer(pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerEventStationPair(List<EventStationPair> staPairList) {
        for (EventStationPair eventStationPair : staPairList) {
            Queue<EventStationPair> queue = this.espToDo;
            synchronized (queue) {
                this.espToDo.offer(eventStationPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerEventChannelPair(List<AbstractEventChannelPair> chanPairList) {
        for (AbstractEventChannelPair ecp : chanPairList) {
            Queue<AbstractEventChannelPair> queue = this.ecpToDo;
            synchronized (queue) {
                this.ecpToDo.offer(ecp);
            }
        }
    }

    public List<EventStationPair> loadESPForNetwork(StatefulEvent event, NetworkAttrImpl net) {
        if (this.espFromNet == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.espFromNet);
        query.setEntity("event", (Object)event);
        query.setEntity("net", (Object)net);
        return query.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventStationPair createEventStationPair(StatefulEvent event, StationImpl station) {
        logger.debug("Put esp (" + event.getDbid() + ",s " + station.getDbid() + ") ");
        Session session = SodDB.getSession();
        EventStationPair esp = new EventStationPair(event, (StationImpl)session.merge((Object)station), Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
        session.save((Object)esp);
        Queue<EventStationPair> queue = this.espToDo;
        synchronized (queue) {
            this.espToDo.offer(esp);
        }
        return esp;
    }

    public EventChannelPair createEventChannelPair(StatefulEvent event, ChannelImpl chan, EventStationPair esp) {
        Session session = SodDB.getSession();
        EventChannelPair eventChannelPair = new EventChannelPair(event, (ChannelImpl)session.merge((Object)chan), esp);
        logger.debug("Put " + eventChannelPair);
        session.save((Object)eventChannelPair);
        return eventChannelPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isECPTodo() {
        Queue<AbstractEventChannelPair> queue = this.ecpToDo;
        synchronized (queue) {
            return !this.ecpToDo.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isESPTodo() {
        Queue<EventStationPair> queue = this.espToDo;
        synchronized (queue) {
            return !this.espToDo.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isENPTodo() {
        Queue<EventNetworkPair> queue = this.enpToDo;
        synchronized (queue) {
            return !this.enpToDo.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventNetworkPair getNextENPFromCache() {
        EventNetworkPair enp;
        Queue<EventNetworkPair> queue = this.enpToDo;
        synchronized (queue) {
            ArrayList<EventNetworkPair> beingLoaded = new ArrayList<EventNetworkPair>();
            enp = this.enpToDo.poll();
            while (enp != null && Start.getNetworkArm().isBeingRefreshed(enp.getNetwork())) {
                beingLoaded.add(enp);
                enp = this.enpToDo.poll();
            }
            this.enpToDo.addAll(beingLoaded);
        }
        if (enp != null) {
            return (EventNetworkPair)SodDB.getSession().merge((Object)enp);
        }
        return null;
    }

    public synchronized EventNetworkPair getNextENP() {
        if (!this.isENPTodo()) {
            this.populateENPToDo();
        }
        return this.getNextENPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateENPToDo() {
        String q = "from " + EventNetworkPair.class.getName() + " e " + " left join fetch e.event " + " left join fetch e.network " + " where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = :standing";
        Query query = SodDB.getSession().createQuery(q);
        query.setInteger("standing", Standing.INIT.getVal());
        query.setMaxResults(100);
        List result = query.list();
        for (EventNetworkPair enpResult : result) {
            Queue<EventNetworkPair> queue = this.enpToDo;
            synchronized (queue) {
                this.enpToDo.offer(enpResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventStationPair getNextESPFromCache() {
        EventStationPair esp;
        Queue<EventStationPair> queue = this.espToDo;
        synchronized (queue) {
            esp = this.espToDo.poll();
        }
        if (esp != null) {
            return (EventStationPair)SodDB.getSession().merge((Object)esp);
        }
        return null;
    }

    public synchronized EventStationPair getNextESP() {
        if (!this.isESPTodo()) {
            this.populateESPToDo();
        }
        return this.getNextESPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateESPToDo() {
        String q = "from " + EventStationPair.class.getName() + " e " + " left join fetch e.event " + " left join fetch e.station " + " left join fetch e.station.networkAttr " + " where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = :standing ";
        Query query = SodDB.getSession().createQuery(q);
        query.setInteger("standing", Standing.INIT.getVal());
        query.setMaxResults(1000);
        List result = query.list();
        for (EventStationPair eventStationPair : result) {
            Queue<EventStationPair> queue = this.espToDo;
            synchronized (queue) {
                this.espToDo.offer(eventStationPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateECPToDo() {
        logger.debug("populateECPToDo");
        String q = "from " + this.getEcpClass().getName() + " e " + " left join fetch e.event ";
        q = this.getEcpClass().equals(EventChannelPair.class) ? q + " left join fetch e.channel  left join fetch e.channel.site  left join fetch e.channel.site.station  left join fetch e.channel.site.station.networkAttr " : q + " left join fetch e.channelGroup  left join fetch e.channelGroup.channel1.site  left join fetch e.channelGroup.channel1.site.station  left join fetch e.channelGroup.channel1.site.station.networkAttr  left join fetch e.channelGroup.channel2.site  left join fetch e.channelGroup.channel2.site.station  left join fetch e.channelGroup.channel2.site.station.networkAttr  left join fetch e.channelGroup.channel3.site  left join fetch e.channelGroup.channel3.site.station  left join fetch e.channelGroup.channel3.site.station.networkAttr ";
        q = q + " where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = :standing ";
        Query query = SodDB.getSession().createQuery(q);
        query.setInteger("standing", Standing.INIT.getVal());
        query.setMaxResults(1000);
        List result = query.list();
        logger.info("populate ECP/EVP ToDo: " + result.size());
        for (AbstractEventChannelPair ecp : result) {
            Queue<AbstractEventChannelPair> queue = this.ecpToDo;
            synchronized (queue) {
                this.ecpToDo.offer(ecp);
            }
        }
        logger.debug("Done populateECPToDo " + result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AbstractEventChannelPair getNextECPFromCache() {
        AbstractEventChannelPair ecp;
        Queue<AbstractEventChannelPair> queue = this.ecpToDo;
        synchronized (queue) {
            ecp = this.ecpToDo.poll();
        }
        if (ecp != null) {
            return (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
        }
        return null;
    }

    public AbstractEventChannelPair getNextECP() {
        if (!this.isECPTodo()) {
            this.populateECPToDo();
        }
        return this.getNextECPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEventChannelPair getNextRetryECPFromCache() {
        AbstractEventChannelPair ecp;
        Queue<AbstractEventChannelPair> queue = this.retryToDo;
        synchronized (queue) {
            ecp = this.retryToDo.poll();
        }
        if (ecp != null) {
            return (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRetryTodo() {
        Queue<AbstractEventChannelPair> queue = this.retryToDo;
        synchronized (queue) {
            return !this.retryToDo.isEmpty();
        }
    }

    public List<AbstractEventChannelPair> getRetryToDo() {
        logger.debug("Getting retry from db");
        String q = "from " + this.getEcpClass().getName() + "  where (status.standingInt = " + Standing.RETRY.getVal() + " or status.standingInt = " + Standing.CORBA_FAILURE.getVal() + " )  and seconds_between(:now, lastQuery) > :minDelay " + " and numRetries < " + this.maxRetries + " and (seconds_between(:now, lastQuery) > :maxDelay or seconds_between(:now, lastQuery) > power(:base, numRetries))  order by numRetries";
        Query query = SodDB.getSession().createQuery(q);
        query.setTimestamp("now", (Date)ClockUtil.now().getTimestamp());
        query.setFloat("base", this.retryBase);
        query.setFloat("minDelay", (float)this.getMinRetryDelay().getValue(UnitImpl.SECOND));
        query.setFloat("maxDelay", this.maxRetryDelay);
        query.setMaxResults(10000);
        logger.info("retry query: " + q);
        List result = query.list();
        logger.debug("retry query: " + q);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateRetryToDo() {
        List<AbstractEventChannelPair> result = this.getRetryToDo();
        for (AbstractEventChannelPair abstractEventChannelPair : result) {
            Queue<AbstractEventChannelPair> queue = this.retryToDo;
            synchronized (queue) {
                this.retryToDo.offer(abstractEventChannelPair);
            }
        }
        logger.debug("Got " + result.size() + " retries from db.");
    }

    public int getNumWorkUnits(Standing standing) {
        return this.getNumWorkUnits(standing, AbstractEventPair.class);
    }

    public int getNumEventNetworkWorkUnits(Standing standing) {
        return this.getNumWorkUnits(standing, EventNetworkPair.class);
    }

    private int getNumWorkUnits(Standing standing, Class EventPairClass) {
        String q = "select count(*) from " + EventPairClass.getName() + " e where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = " + standing.getVal() + " and e.numRetries =  0";
        Query query = SodDB.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return ((Number)result.get(0)).intValue();
        }
        return 0;
    }

    public EventChannelPair getECP(CacheEvent event, ChannelImpl chan) {
        Query query = SodDB.getSession().createQuery("from " + EventChannelPair.class.getName() + " where event = :event and channel = :channel");
        query.setEntity("event", (Object)event);
        query.setEntity("channel", (Object)chan);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return (EventChannelPair)result.get(0);
        }
        return null;
    }

    public EventVectorPair put(EventVectorPair eventVectorPair) {
        Session session = SodDB.getSession();
        session.lock((Object)eventVectorPair.getEvent(), LockMode.NONE);
        ChannelImpl[] chan = eventVectorPair.getChannelGroup().getChannels();
        for (int i = 0; i < chan.length; ++i) {
            session.lock((Object)chan[i], LockMode.NONE);
        }
        session.saveOrUpdate((Object)eventVectorPair);
        return eventVectorPair;
    }

    public TimeInterval getMinRetryDelay() {
        return this.minRetryDelay;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getNumSuccessful() {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.totalSuccess);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumSuccessful(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.successPerEvent);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumSuccessful(StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.success);
        query.setEntity("sta", (Object)station);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumSuccessful(CacheEvent event, StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.successPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumFailed(StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.failed);
        query.setEntity("sta", (Object)station);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumFailed(CacheEvent event, StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.failedPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumFailed(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.failedPerEvent);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumRetry(StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.retry);
        query.setEntity("sta", (Object)station);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumRetry(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.retryPerEvent);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumRetry(CacheEvent event, StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.retryPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public List<AbstractEventChannelPair> getAll(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.eventBase);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getSuccessful(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.successPerEvent);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getSuccessful(StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.success);
        query.setEntity("sta", (Object)station);
        return query.list();
    }

    public List<AbstractEventChannelPair> getSuccessful(CacheEvent event, StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.successPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getFailed(StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.failed);
        query.setEntity("sta", (Object)station);
        return query.list();
    }

    public List<AbstractEventChannelPair> getFailed(CacheEvent event, StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.failedPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getFailed(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.failedPerEvent);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getRetry(StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.retry);
        query.setEntity("sta", (Object)station);
        return query.list();
    }

    public List<AbstractEventChannelPair> getRetry(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.retryPerEvent);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getRetry(CacheEvent event, StationImpl station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.retryPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<StationImpl> getStationsForEvent(CacheEvent event) {
        String q = "select distinct ecp.esp.station from " + this.getEcpClass().getName() + " ecp where ecp.event = :event";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public EventStationPair getEventStationPair(CacheEvent event, StationImpl station) {
        String q = "from EventStationPair where event = :event and station = :station";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        query.setEntity("station", (Object)station);
        return (EventStationPair)query.uniqueResult();
    }

    public List<StationImpl> getSuccessfulStationsForEvent(CacheEvent event) {
        String q = "select distinct ecp.esp.station from " + this.getEcpClass().getName() + " ecp where ecp.event = :event and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<StationImpl> getUnsuccessfulStationsForEvent(CacheEvent event) {
        String q = "from " + StationImpl.class.getName() + " s where s not in (" + "select distinct ecp.esp.station from " + this.getEcpClass().getName() + " ecp where ecp.event = :event and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal() + " )";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<EventStationPair> getSuccessfulESPForEvent(CacheEvent event) {
        String q = "from EventStationPair where event = :event and status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<CacheEvent> getEventsForStation(StationImpl sta) {
        String q = "select distinct ecp.event from " + this.getEcpClass().getName() + " ecp where ecp.esp.station = :sta ";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public List<EventStationPair> getSuccessfulESPForStation(StationImpl sta) {
        String q = "from EventStationPair where station = :sta and status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public List<StatefulEvent> getSuccessfulEventsForStation(StationImpl sta) {
        String q = "select distinct ecp.event from " + this.getEcpClass().getName() + " ecp where ecp.esp.station = :sta  and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public List<CacheEvent> getUnsuccessfulEventsForStation(StationImpl sta) {
        String q = "from " + CacheEvent.class.getName() + " e where e not in (" + "select distinct ecp.event from " + this.getEcpClass().getName() + " ecp where ecp.esp.station = :sta  and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal() + " )";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public long put(RecordSectionItem item) {
        return (Long)SodDB.getSession().save((Object)item);
    }

    public RecordSectionItem getRecordSectionItemForEvent(CacheEvent event, ChannelImpl channel) {
        String q = "from " + RecordSectionItem.class.getName() + " where event = :event and channel = :channel";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        query.setEntity("channel", (Object)channel);
        Iterator it = query.iterate();
        if (it.hasNext()) {
            return (RecordSectionItem)it.next();
        }
        return null;
    }

    public List<String> getRecordSectionId(CacheEvent event) {
        String q = "select distinct recordSectionId from " + RecordSectionItem.class.getName() + " where event = :event";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<String> getRecordSectionOrientations(CacheEvent event) {
        String q = "select distinct orientationId from " + RecordSectionItem.class.getName() + " where event = :event";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public RecordSectionItem getRecordSectionItem(String orientationId, String recordSectionId, CacheEvent event, ChannelImpl channel) {
        String q = "from " + RecordSectionItem.class.getName() + " where event = :event and channel = :channel and orientationId = :orientationId and recordSectionId = :recsecid";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        query.setEntity("channel", (Object)channel);
        query.setString("orientationId", orientationId);
        query.setString("recsecid", recordSectionId);
        Iterator it = query.iterate();
        if (it.hasNext()) {
            return (RecordSectionItem)it.next();
        }
        return null;
    }

    public List<StationImpl> getStationsForRecordSection(String orientationId, String recordSectionId, CacheEvent event, boolean best) {
        Query q = SodDB.getSession().createQuery("select distinct channel.site.station from " + RecordSectionItem.class.getName() + " where recordSectionId = :recsecid and orientationId = :orientationId and event = :event and inBest = :best");
        q.setEntity("event", (Object)event);
        q.setString("recsecid", recordSectionId);
        q.setString("orientationId", orientationId);
        q.setBoolean("best", best);
        return q.list();
    }

    public List<ChannelImpl> getChannelsForRecordSection(String orientationId, CacheEvent event, boolean best) {
        Query q = SodDB.getSession().createQuery("select distinct channel from " + RecordSectionItem.class.getName() + " where orientationId = :orientationId and event = :event and inBest = :best");
        q.setEntity("event", (Object)event);
        q.setString("orientationId", orientationId);
        q.setBoolean("best", best);
        return q.list();
    }

    public List<RecordSectionItem> getBestForRecordSection(String orientationId, String recordSectionId, CacheEvent event) {
        Query q = SodDB.getSession().createQuery("from " + RecordSectionItem.class.getName() + " where inBest = true and event = :event and orientationid = :orientationid and recordSectionId = :recsecid");
        q.setEntity("event", (Object)event);
        q.setString("orientationid", orientationId);
        q.setString("recsecid", recordSectionId);
        return q.list();
    }

    public boolean updateBestForRecordSection(String orientationId, String recordSectionId, CacheEvent event, ChannelId[] channelIds) {
        RecordSectionItem item;
        Iterator dbit;
        ChannelId c;
        String msg = "updateBestForRecordSection(" + orientationId + ", " + recordSectionId + ", " + event + ", " + channelIds.length;
        String chanIdStr = "";
        for (int i = 0; i < channelIds.length; ++i) {
            msg = msg + " " + channelIds[i].network_id.network_code + "." + channelIds[i].station_code;
            chanIdStr = chanIdStr + "  " + ChannelIdUtil.toStringNoDates((ChannelId)channelIds[i]);
        }
        logger.debug(msg);
        logger.debug("RecordSection chan ids: " + chanIdStr);
        List<RecordSectionItem> best = this.getBestForRecordSection(orientationId, recordSectionId, event);
        msg = "Cur Best RecordSection: " + orientationId + ", " + recordSectionId + ", " + event + ", " + best.size();
        for (RecordSectionItem rs : best) {
            msg = msg + " " + rs.getChannel().getId().network_id.network_code + "." + rs.getChannel().getId().station_code;
        }
        logger.debug(msg);
        HashMap<String, ChannelId> removes = new HashMap<String, ChannelId>();
        Iterator<RecordSectionItem> it = best.iterator();
        while (it.hasNext()) {
            ChannelId cId = it.next().channel.get_id();
            removes.put(ChannelIdUtil.toString((ChannelId)cId), cId);
        }
        HashMap<String, ChannelId> adders = new HashMap<String, ChannelId>();
        logger.debug("RecordSection updating " + channelIds.length + " recordSectionItems for " + recordSectionId + " for event " + event);
        for (int i = 0; i < channelIds.length; ++i) {
            logger.debug("RecordSection channelid: " + ChannelIdUtil.toString((ChannelId)channelIds[i]));
            adders.put(ChannelIdUtil.toString((ChannelId)channelIds[i]), channelIds[i]);
        }
        Iterator chanIt = adders.keySet().iterator();
        while (chanIt.hasNext()) {
            String cId = (String)chanIt.next();
            if (!removes.containsKey(cId)) continue;
            removes.remove(cId);
            chanIt.remove();
        }
        if (removes.size() == 0 && adders.size() == 0) {
            logger.debug("RecordSection No adds and no removes");
            return false;
        }
        Query q = SodDB.getSession().createQuery("from " + RecordSectionItem.class.getName() + " where inBest = true and event = :event and recordSectionId = :recsecid and orientationid = :orientationid and " + MATCH_CHANNEL_CODES);
        chanIt = removes.keySet().iterator();
        while (chanIt.hasNext()) {
            c = (ChannelId)removes.get(chanIt.next());
            logger.debug("RecordSection remove: " + q + "  " + event.getDbid() + "  " + recordSectionId + " " + c.channel_code + " " + c.site_code + " " + c.station_code + " " + c.network_id.network_code);
            q.setEntity("event", (Object)event);
            q.setString("orientationid", orientationId);
            q.setString("recsecid", recordSectionId);
            q.setString("chanCode", c.channel_code);
            q.setString("siteCode", c.site_code);
            q.setString("staCode", c.station_code);
            q.setString("netCode", c.network_id.network_code);
            dbit = q.iterate();
            while (dbit.hasNext()) {
                item = (RecordSectionItem)dbit.next();
                logger.debug("RecordSection update false for " + ChannelIdUtil.toString((ChannelId)item.getChannel().get_id()));
                item.setInBest(false);
                SodDB.getSession().update((Object)item);
            }
        }
        q = SodDB.getSession().createQuery("from " + RecordSectionItem.class.getName() + " where inBest = false and event = :event and recordSectionId = :recsecid and orientationid = :orientationid and " + MATCH_CHANNEL_CODES);
        chanIt = adders.keySet().iterator();
        logger.debug("RecordSection adds.size()=" + adders.size());
        while (chanIt.hasNext()) {
            c = (ChannelId)adders.get(chanIt.next());
            logger.debug("RecordSection adds  " + event.getDbid() + "  " + recordSectionId + " " + c.channel_code + " " + c.site_code + " " + c.station_code + " " + c.network_id.network_code);
            q.setEntity("event", (Object)event);
            q.setString("orientationid", orientationId);
            q.setString("recsecid", recordSectionId);
            q.setString("chanCode", c.channel_code);
            q.setString("siteCode", c.site_code);
            q.setString("staCode", c.station_code);
            q.setString("netCode", c.network_id.network_code);
            dbit = q.iterate();
            while (dbit.hasNext()) {
                item = (RecordSectionItem)dbit.next();
                logger.debug("RecordSection update true for " + ChannelIdUtil.toString((ChannelId)item.getChannel().get_id()));
                item.setInBest(true);
                SodDB.getSession().saveOrUpdate((Object)item);
            }
        }
        best = this.getBestForRecordSection(orientationId, recordSectionId, event);
        msg = "after update Best RecordSection: " + orientationId + ", " + recordSectionId + ", " + event + ", " + best.size();
        for (RecordSectionItem rs : best) {
            msg = msg + " " + rs.getChannel().getId().network_id.network_code + "." + rs.getChannel().getId().station_code;
        }
        logger.debug(msg);
        return true;
    }

    public List<RecordSectionItem> getRecordSectionItemList(String orientationId, String recordSectionId, CacheEvent event) {
        Query q = SodDB.getSession().createQuery("from " + RecordSectionItem.class.getName() + " where event = :event and orientationid = :orientationid and recordSectionId = :recsecid");
        q.setEntity("event", (Object)event);
        q.setString("orientationid", orientationId);
        q.setString("recsecid", recordSectionId);
        return q.list();
    }

    public List<RecordSectionItem> recordSectionsForEvent(CacheEvent event) {
        Query q = SodDB.getSession().createQuery("from " + RecordSectionItem.class.getName() + " where event = :event");
        q.setEntity("event", (Object)event);
        return q.list();
    }

    public int putConfig(SodConfig sodConfig) {
        Integer dbid = (Integer)SodDB.getSession().save((Object)sodConfig);
        return dbid;
    }

    public SodConfig getCurrentConfig() {
        String q = "From edu.sc.seis.sod.SodConfig c ORDER BY c.time desc";
        Query query = SodDB.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return (SodConfig)result.get(0);
        }
        return null;
    }

    public SodConfig getConfig(int configid) {
        return (SodConfig)SodDB.getSession().get(SodConfig.class, (Serializable)Integer.valueOf(configid));
    }

    public QueryTime getQueryTime(String serverName, String serverDNS) {
        String q = "From edu.sc.seis.sod.QueryTime q WHERE q.serverName = :serverName AND q.serverDNS = :serverDNS";
        Query query = SodDB.getSession().createQuery(q);
        query.setString("serverName", serverName);
        query.setString("serverDNS", serverDNS);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return (QueryTime)result.get(0);
        }
        return null;
    }

    public int putQueryTime(QueryTime qtime) {
        QueryTime indb = this.getQueryTime(qtime.getServerName(), qtime.getServerDNS());
        if (indb != null) {
            indb.setTime(qtime.getTime());
            SodDB.getSession().saveOrUpdate((Object)indb);
            return indb.getDbid();
        }
        Integer dbid = (Integer)SodDB.getSession().save((Object)qtime);
        return dbid;
    }

    public Version getDBVersion() {
        String q = "From edu.sc.seis.sod.Version ORDER BY dbid desc";
        Session session = SodDB.getSession();
        Query query = SodDB.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            Version out = (Version)result.get(0);
            return out;
        }
        Version v = Version.current();
        session.save((Object)v);
        return v;
    }

    protected Version putDBVersion() {
        Version v = this.getDBVersion();
        Version current = Version.current();
        current.setDbid(v.getDbid());
        SodDB.getSession().merge((Object)current);
        SodDB.commit();
        return current;
    }

    public void initHQLStmts() {
        String baseStatement = "FROM " + this.getEcpClass().getName() + " ecp WHERE ";
        String staBase = baseStatement + " ecp.esp.station = :sta ";
        String staEventBase = baseStatement + " ecp.esp.station = :sta and ecp.event = :event ";
        Status pass = Status.get(Stage.PROCESSOR, Standing.SUCCESS);
        String PROCESS_SUCCESS = " ecp.status.stageInt = " + pass.getStageInt() + " AND ecp.status.standingInt = " + pass.getStandingInt();
        this.eventBase = baseStatement + " ecp.event = :event ";
        this.success = staBase + " AND " + PROCESS_SUCCESS;
        String failReq = " AND ecp.status.standingInt in (" + Standing.REJECT.getVal() + " , " + Standing.SYSTEM_FAILURE.getVal() + ")";
        this.failed = staBase + failReq;
        String retryReq = " AND ecp.status.standingInt in (" + Standing.RETRY.getVal() + " , " + Standing.CORBA_FAILURE.getVal() + ")";
        this.retry = staBase + retryReq;
        this.successPerEvent = this.eventBase + " AND " + PROCESS_SUCCESS;
        this.failedPerEvent = this.eventBase + failReq;
        this.retryPerEvent = this.eventBase + retryReq;
        this.successPerEventStation = staEventBase + "  AND " + PROCESS_SUCCESS;
        this.failedPerEventStation = staEventBase + failReq;
        this.retryPerEventStation = staEventBase + retryReq;
        this.totalSuccess = baseStatement + " " + PROCESS_SUCCESS;
        this.espFromNet = "FROM " + EventStationPair.class.getName() + " esp WHERE " + " esp.event = :event and esp.station.networkAttr = :net";
    }

    public static Class<? extends AbstractEventChannelPair> discoverDbEcpClass() {
        try {
            String q = "from " + EventVectorPair.class.getName();
            Query query = SodDB.getSession().createQuery(q);
            query.setMaxResults(1);
            List result = query.list();
            if (result.size() > 0) {
                Class<EventVectorPair> clazz = EventVectorPair.class;
                return clazz;
            }
            Class<EventChannelPair> clazz = EventChannelPair.class;
            return clazz;
        }
        catch (Throwable e) {
            logger.warn("Exception in SodDB.discoverDbEcpClass()", e);
            throw new RuntimeException("Exception in SodDB.discoverDbEcpClass()", e);
        }
        finally {
            SodDB.rollback();
        }
    }

    public static void setDefaultEcpClass(Class<? extends AbstractEventChannelPair> ecpClass) {
        if (ecpClass == null) {
            throw new IllegalArgumentException("ECP Class cannot be null");
        }
        defaultEcpClass = ecpClass;
        if (singleton != null && SodDB.singleton.ecpClass != null && SodDB.singleton.ecpClass != ecpClass) {
            throw new RuntimeException("Setting ecpClass but session is already open with different ecpClass: set(" + ecpClass + ") != " + SodDB.singleton.ecpClass);
        }
    }

    public Class<? extends AbstractEventChannelPair> getEcpClass() {
        if (this.ecpClass == null) {
            if (defaultEcpClass == null) {
                defaultEcpClass = SodDB.discoverDbEcpClass();
            }
            this.ecpClass = defaultEcpClass;
        }
        return this.ecpClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SodDB getSingleton() {
        Class<SodDB> clazz = SodDB.class;
        synchronized (SodDB.class) {
            if (singleton == null) {
                singleton = new SodDB();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }
}

