/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.channelGroup;

import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.channelGroup.OrientedSiteRule;
import edu.sc.seis.sod.channelGroup.SiteChannelRule;
import edu.sc.seis.sod.channelGroup.SiteMatchRule;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.PassChannel;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import edu.sc.seis.sod.subsetter.network.PassNetwork;
import edu.sc.seis.sod.subsetter.station.PassStation;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule {
    private String ruleName = "unknown";
    private NetworkSubsetter attrSubsetter = new PassNetwork();
    private StationSubsetter stationSubsetter = new PassStation();
    private ChannelSubsetter chanSubsetter = new PassChannel();
    private List<SiteChannelRule> siteChanRuleList = new ArrayList<SiteChannelRule>();
    public static final String[] PACKAGES = new String[]{"channel", "site", "station", "network"};
    private static final Logger logger = LoggerFactory.getLogger(Rule.class);

    public Rule(Element config, String ruleName) throws ConfigurationException {
        this.ruleName = ruleName;
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            if (el.getTagName().equals("siteMatchRule")) {
                this.siteChanRuleList.add(new SiteMatchRule(el));
                continue;
            }
            if (el.getTagName().equals("orientedSiteRule")) {
                this.siteChanRuleList.add(new OrientedSiteRule(el));
                continue;
            }
            Object sodElement = SodUtil.load(el, NetworkArm.PACKAGES);
            if (sodElement instanceof NetworkSubsetter) {
                this.attrSubsetter = (NetworkSubsetter)sodElement;
                continue;
            }
            if (sodElement instanceof StationSubsetter) {
                this.stationSubsetter = (StationSubsetter)sodElement;
                continue;
            }
            if (sodElement instanceof ChannelSubsetter) {
                this.chanSubsetter = (ChannelSubsetter)sodElement;
                continue;
            }
            throw new ConfigurationException("Unknown configuration object: " + sodElement.getClass());
        }
    }

    public List<ChannelGroup> acceptable(List<ChannelImpl> chanList, List<ChannelImpl> failures) {
        ArrayList<ChannelImpl> possible = new ArrayList<ChannelImpl>();
        for (ChannelImpl chan : chanList) {
            try {
                if (this.attrSubsetter.accept((NetworkAttrImpl)chan.getStation().getNetworkAttr()).isSuccess() && this.stationSubsetter.accept(chan.getStationImpl(), null).isSuccess() && this.chanSubsetter.accept(chan, null).isSuccess()) {
                    possible.add(chan);
                    continue;
                }
                failures.add(chan);
            }
            catch (Exception e) {
                logger.warn("Exception in channgeGrouper rule.", (Throwable)e);
                failures.add(chan);
            }
        }
        ArrayList<ChannelGroup> out = new ArrayList<ChannelGroup>();
        ArrayList<Object> stillToTest = new ArrayList<ChannelImpl>();
        for (SiteChannelRule threeChar : this.siteChanRuleList) {
            out.addAll(threeChar.acceptable(possible, stillToTest));
            possible = stillToTest;
            stillToTest = new ArrayList();
        }
        failures.addAll(possible);
        return out;
    }

    public String getRuleName() {
        return this.ruleName;
    }
}

