/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.ClassicRetryStrategy;
import edu.sc.seis.fissuresUtil.cache.CorbaServerWrapper;
import edu.sc.seis.sod.CommonAccess;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.source.AbstractSource;
import java.util.HashSet;
import java.util.Set;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserReportRetryStrategy
extends ClassicRetryStrategy {
    private Object addlInfo;
    private Set bustedServers = new HashSet();
    public static final String WILY_NS_URL = "http://www.seis.sc.edu/wily/GetAllServers?corbaLoc=";
    private static final Logger logger = LoggerFactory.getLogger(UserReportRetryStrategy.class);

    public UserReportRetryStrategy(int numRetries, String additionalInfo) {
        super(numRetries);
        this.addlInfo = additionalInfo;
    }

    public UserReportRetryStrategy(int numRetries) {
        this(numRetries, "");
    }

    public UserReportRetryStrategy() {
        this(BulletproofVestFactory.getDefaultNumRetry());
    }

    public synchronized boolean shouldRetry(Throwable exc, Object server, int tryCount) {
        String serverId = this.makeServerId(server);
        if (!this.bustedServers.contains(serverId)) {
            if (exc instanceof TRANSIENT && exc.getCause() instanceof NotFound) {
                this.print("SOD was unable to find a " + serverId + " in the name service.  Check\n" + UserReportRetryStrategy.getWilyURL() + "\n for that server to make sure you've put the correct location in your ingredient for that server.  If you're sure it's correct, just wait.  SOD will continue trying to find it until it's readded to the name server at which point an all clear message will be issued.  If you're tired of waiting, press Ctrl-C to quit.  " + this.addlInfo);
            } else if (Start.getArgs().isQuitOnError()) {
                StringBuilder stringBuilder = new StringBuilder().append("The ").append(serverId).append(" server just produced an error (").append(exc.getClass().getName()).append(").  SOD will quit due to the --");
                Start.getArgs();
                this.print(stringBuilder.append("quitOnError").append(" switch.  ").append(this.addlInfo).toString());
                System.exit(1);
            } else {
                this.print("The " + serverId + " server just produced an error (" + exc.getClass().getName() + ").  SOD will continue trying it until it recovers at which point an all clear message will be issued.  If it never recovers, email sod@seis.sc.edu with this report and we can inform the server maintainer.  If you're tired of waiting, press Ctrl-C to quit.  " + this.addlInfo);
            }
            logger.info(serverId + " error ", exc);
            this.bustedServers.add(serverId);
        }
        return super.shouldRetry(exc, server, tryCount);
    }

    public synchronized void serverRecovered(Object server) {
        String serverId = this.makeServerId(server);
        if (this.bustedServers.contains(serverId)) {
            this.bustedServers.remove(serverId);
            this.print("All clear!  " + serverId + " just recovered.  Processing will continue normally.");
        }
    }

    private void print(String msg) {
        logger.warn(msg);
    }

    private String makeServerId(Object server) {
        if (server instanceof CorbaServerWrapper) {
            return ((CorbaServerWrapper)server).getFullName() + " " + ((CorbaServerWrapper)server).getServerType();
        }
        if (server instanceof AbstractSource) {
            return ((AbstractSource)server).getName();
        }
        return server.toString();
    }

    public static String getWilyURL() {
        String nsLoc = CommonAccess.getNameServiceAddress();
        if (nsLoc.equals("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService")) {
            return "http://www.seis.sc.edu/ns/IRIS";
        }
        if (nsLoc.equals("corbaloc:iiop:nameservice.seis.sc.edu:6371/NameService")) {
            return "http://www.seis.sc.edu/ns/SC";
        }
        return WILY_NS_URL + nsLoc;
    }
}

