/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicCheckpointer
extends TimerTask {
    private static final int ONE_HOUR = 3600000;
    private static final Logger logger = LoggerFactory.getLogger(PeriodicCheckpointer.class);

    public PeriodicCheckpointer() {
        if (ConnMgr.getDB_TYPE().equals("HSQL")) {
            Timer t = new Timer(true);
            t.schedule((TimerTask)this, (Date)new MicroSecondDate().add(new TimeInterval(1.0, UnitImpl.HOUR)), 3600000L);
        } else {
            logger.warn("Checkpointing only makes sense for HSQLDB, not " + ConnMgr.getDB_TYPE());
        }
    }

    @Override
    public void run() {
        try {
            Connection conn = ConnMgr.createConnection();
            Statement stmt = conn.createStatement();
            logger.info("Checkpointing db");
            stmt.executeUpdate("CHECKPOINT");
            logger.info("Done checkpointing db");
            conn.close();
        }
        catch (SQLException e) {
            GlobalExceptionHandler.handle((Throwable)e);
        }
    }
}

