/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.bag.OrientationUtil;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.channelGroup.Rule;
import edu.sc.seis.sod.validator.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ChannelGrouper {
    private static Logger logger = LoggerFactory.getLogger(ChannelGrouper.class);
    private List<Rule> defaultRules;
    private List<Rule> additionalRules;
    List<Rule> ruleList = new ArrayList<Rule>();
    private static String defaultConfigFileLoc = "jar:edu/sc/seis/sod/data/grouper.xml";
    private static final String grouperSchemaLoc = "edu/sc/seis/sod/data/grouper.rng";

    public ChannelGrouper() throws ConfigurationException {
        this(null);
    }

    public ChannelGrouper(String configFileLoc) throws ConfigurationException {
        try {
            this.defaultRules = this.loadRules(defaultConfigFileLoc);
            this.additionalRules = this.loadRules(configFileLoc);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to configure three component rules", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Unable to configure three component rules", e);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to configure three component rules", e);
        }
    }

    public List<ChannelGroup> group(List<ChannelImpl> channels, List<ChannelImpl> failures) {
        return this.applyRules(channels, this.defaultRules, this.additionalRules, failures);
    }

    private List<ChannelGroup> applyRules(List<ChannelImpl> channels, List<Rule> defaultRules, List<Rule> additionalRules, List<ChannelImpl> failures) {
        LinkedList<ChannelGroup> groupableChannels = new LinkedList<ChannelGroup>();
        HashMap<String, List<ChannelImpl>> bandGain = this.groupByNetStaBandGain(channels);
        for (String key : bandGain.keySet()) {
            List<ChannelGroup> groups;
            ArrayList<Object> stillToTest;
            ArrayList<ChannelImpl> toTest = new ArrayList<ChannelImpl>();
            toTest.addAll((Collection)bandGain.get(key));
            for (Rule rule : additionalRules) {
                stillToTest = new ArrayList<ChannelImpl>();
                groups = rule.acceptable(toTest, stillToTest);
                groupableChannels.addAll(groups);
                toTest = stillToTest;
            }
            for (Rule rule : defaultRules) {
                stillToTest = new ArrayList();
                groups = rule.acceptable(toTest, stillToTest);
                groupableChannels.addAll(groups);
                toTest = stillToTest;
            }
            failures.addAll(toTest);
        }
        return groupableChannels;
    }

    public static boolean sanityCheck(ChannelGroup channelGroup) {
        return ChannelGrouper.haveSameSamplingRate(channelGroup) && ChannelGrouper.areOrthogonal(channelGroup);
    }

    private static boolean areOrthogonal(ChannelGroup channelGroup) {
        ChannelImpl[] chans = channelGroup.getChannels();
        for (int i = 0; i < chans.length; ++i) {
            for (int j = i + 1; j < chans.length; ++j) {
                if (OrientationUtil.areOrthogonal((Orientation)chans[i].getOrientation(), (Orientation)chans[j].getOrientation())) continue;
                logger.info("Fail areOrthogonal (" + i + "," + j + "): " + ChannelIdUtil.toString((ChannelId)chans[i].get_id()) + " " + OrientationUtil.toString((Orientation)chans[i].getOrientation()) + " " + ChannelIdUtil.toString((ChannelId)chans[j].get_id()) + " " + OrientationUtil.toString((Orientation)chans[j].getOrientation()));
                return false;
            }
        }
        return true;
    }

    private static boolean haveSameSamplingRate(ChannelGroup cg) {
        ChannelImpl[] chans = cg.getChannels();
        SamplingImpl sampl = (SamplingImpl)chans[0].getSamplingInfo();
        QuantityImpl freq = sampl.getFrequency();
        UnitImpl baseUnit = freq.getUnit();
        double samplingRate0 = freq.getValue() * (double)sampl.getNumPoints();
        for (int i = 1; i < chans.length; ++i) {
            SamplingImpl sample = (SamplingImpl)chans[i].getSamplingInfo();
            double sampleRate = sample.getFrequency().convertTo(baseUnit).getValue() * (double)sample.getNumPoints();
            if (sampleRate == samplingRate0) continue;
            logger.info("Fail haveSameSamplingRate (" + i + "): " + ChannelIdUtil.toString((ChannelId)chans[i].get_id()) + " " + chans[i].getSamplingInfo() + " " + ChannelIdUtil.toString((ChannelId)chans[0].get_id()) + " " + chans[0].getSamplingInfo());
            return false;
        }
        return true;
    }

    HashMap<String, List<ChannelImpl>> groupByNetStaBandGain(List<ChannelImpl> channels) {
        HashMap<String, List<ChannelImpl>> bandGain = new HashMap<String, List<ChannelImpl>>();
        for (ChannelImpl c : channels) {
            MicroSecondDate msd = new MicroSecondDate(c.get_id().begin_time);
            ChannelId cId = c.getId();
            String key = cId.network_id.network_code + "." + cId.station_code + "." + cId.channel_code;
            key = key.substring(0, key.length() - 1);
            key = msd + key;
            List<ChannelImpl> chans = bandGain.get(key);
            if (chans == null) {
                chans = new LinkedList<ChannelImpl>();
                bandGain.put(key, chans);
            }
            chans.add(c);
        }
        return bandGain;
    }

    private List<Rule> loadRules(String configFileLoc) throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        ArrayList<Rule> out = new ArrayList<Rule>();
        if (configFileLoc != null && configFileLoc.length() != 0) {
            Validator validator = new Validator(grouperSchemaLoc);
            if (!validator.validate(this.getRules(configFileLoc))) {
                throw new ConfigurationException("Invalid config file! " + configFileLoc + " " + validator.getErrorMessage());
            }
            Document doc = Start.createDoc(this.getRules(configFileLoc), configFileLoc);
            NodeList ruleList = doc.getElementsByTagName("rule");
            for (int i = 0; i < ruleList.getLength(); ++i) {
                out.add(new Rule((Element)ruleList.item(i), configFileLoc + " " + i));
            }
        }
        return out;
    }

    private InputSource getRules(String configFileLoc) throws IOException {
        ClassLoader loader = ChannelGrouper.class.getClassLoader();
        return Start.createInputSource(loader, configFileLoc);
    }
}

