/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.winston.WinstonUtil;

public class WinstonSCNL {
    static final String SEP = "$";
    String station;
    String channel;
    String network;
    String locId;
    String prefix;

    protected WinstonSCNL(String databaseName, String prefix) {
        this.prefix = prefix;
        String woPrefix = databaseName.substring(prefix.length() + 1);
        String[] s = woPrefix.split("\\$");
        if (s.length == 4) {
            this.locId = s[3];
        } else {
            if (s.length != 3) {
                throw new IllegalArgumentException("Invalid Winston database name: '" + databaseName + "', must have 2 or 3 $'s");
            }
            this.locId = null;
        }
        this.station = s[0];
        this.channel = s[1];
        this.network = s[2];
    }

    protected WinstonSCNL(String station, String channel, String network, String locId, String prefix) {
        this.station = station;
        this.channel = channel;
        this.network = network;
        this.locId = locId;
        this.prefix = prefix;
    }

    public String getDatabaseName() {
        return WinstonUtil.prefixTableName(this.prefix, this.concatSCNL());
    }

    public String concatSCNL() {
        return this.station + SEP + this.channel + SEP + this.network + (this.locId != null && this.locId.trim().length() != 0 ? SEP + this.locId : "");
    }

    public String getNSLCWithDots() {
        return this.network + "." + this.station + "." + this.locId + "." + this.channel;
    }

    public String getStation() {
        return this.station;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getLocId() {
        return this.locId;
    }

    public String toString() {
        return this.getDatabaseName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        result = 31 * result + (this.locId == null ? 0 : this.locId.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.station == null ? 0 : this.station.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WinstonSCNL other = (WinstonSCNL)obj;
        if (this.channel == null ? other.channel != null : !this.channel.equals(other.channel)) {
            return false;
        }
        if (this.locId == null ? other.locId != null : !this.locId.equals(other.locId)) {
            return false;
        }
        if (this.network == null ? other.network != null : !this.network.equals(other.network)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        return !(this.station == null ? other.station != null : !this.station.equals(other.station));
    }
}

