/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.earthworm.EarthwormExport;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonTable;
import edu.sc.seis.seisFile.winston.WinstonUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinstonClient {
    QueryParams params;
    Properties winstonConfig = new Properties();
    boolean doSync = false;
    boolean doExport = false;
    boolean doTbZip = false;
    boolean doChannelList = false;
    boolean heartbeatverbose = false;
    int exportPort = -1;
    int recordSize = 12;
    boolean doSteim1 = false;
    boolean doSteim2 = false;
    String heartbeatText = "alive";
    int heartbeat = 5;
    int module = 255;
    int institution = 255;
    int chunkSeconds = 60;
    int sleepMillis = 0;
    public static final int DEFAULT_CHUNK_SECONDS = 60;
    public static final int DEFAULT_HEARTBEAT = 5;
    public static final int DEFAULT_MODULE = 255;
    public static final int DEFAULT_INSTITUTION = 255;
    private static final Logger logger = LoggerFactory.getLogger(WinstonClient.class);

    protected WinstonClient(String[] args) throws SeisFileException, FileNotFoundException, IOException {
        QueryParams defaults = new QueryParams(new String[]{"-n", "*", "-s", "*", "-l", "*", "-c", "*"});
        this.params = new QueryParams(args, defaults);
        List<String> leftOverArgs = this.params.getUnknownArgs();
        this.winstonConfig.put("winston.driver", "com.mysql.jdbc.Driver");
        this.winstonConfig.put("winston.prefix", "W");
        this.winstonConfig.put("winston.url", "jdbc:mysql://localhost/?user=wwsuser&password=");
        Iterator<String> it = leftOverArgs.iterator();
        while (it.hasNext()) {
            String nextArg = it.next();
            if (nextArg.equals("--sync")) {
                this.doSync = true;
                continue;
            }
            if (nextArg.equals("--steim1")) {
                if (this.doSteim2) continue;
                this.doSteim1 = true;
                continue;
            }
            if (nextArg.equals("--steim2")) {
                this.doSteim1 = false;
                this.doSteim2 = true;
                continue;
            }
            if (nextArg.equals("--heartbeatverbose")) {
                this.heartbeatverbose = true;
                continue;
            }
            if (nextArg.equals("--tbzip")) {
                this.doTbZip = true;
                continue;
            }
            if (nextArg.equals("--list")) {
                this.doChannelList = true;
                continue;
            }
            if (it.hasNext()) {
                if (nextArg.equals("-p")) {
                    this.winstonConfig.load(new BufferedReader(new FileReader(it.next())));
                    continue;
                }
                if (nextArg.equals("-u")) {
                    this.winstonConfig.put("winston.url", it.next());
                    continue;
                }
                if (nextArg.equals("--recLen")) {
                    this.recordSize = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--export")) {
                    this.doExport = true;
                    this.exportPort = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--chunk")) {
                    this.chunkSeconds = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--module")) {
                    this.module = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--inst")) {
                    this.institution = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--heartbeat")) {
                    this.heartbeat = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--heartbeatText")) {
                    this.heartbeatText = it.next();
                    continue;
                }
                if (nextArg.equals("--sleepmillis")) {
                    this.sleepMillis = Integer.parseInt(it.next());
                    continue;
                }
                if (nextArg.equals("--j2KSecondsToDate")) {
                    System.out.println(WinstonUtil.j2KSecondsToDate(Double.parseDouble(it.next())));
                    System.exit(0);
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: " + nextArg);
            }
            throw new IllegalArgumentException("Unknown argument: " + nextArg);
        }
        if (!this.doSync && this.params.getOutFile() == null) {
            this.params.setOutFile("output.mseed");
        }
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.INFO);
        WinstonClient client = new WinstonClient(args);
        client.readData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData() throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        if (this.params.isPrintHelp()) {
            System.out.println(this.getHelp());
            return;
        }
        if (this.params.isPrintVersion()) {
            System.out.println("Version: " + BuildVersion.getDetailedVersion());
            return;
        }
        if (this.params.getNetwork() == null || this.params.getStation() == null || this.params.getChannel() == null) {
            System.out.println(BuildVersion.getDetailedVersion() + " one of scnl is null: n=" + this.params.getNetwork() + " s=" + this.params.getStation() + " l=" + this.params.getLocation() + " c=" + this.params.getChannel());
            System.out.println("LocId null is ok for scn, but needed for scnl");
            return;
        }
        if (this.params.isVerbose()) {
            WinstonUtil.setVerbose(true);
        }
        try (WinstonUtil winston = new WinstonUtil(this.getDbURL(), this.getUser(), this.getPassword(), this.winstonConfig.getProperty("winston.prefix"));){
            List<WinstonSCNL> allChannels = winston.listChannelDatabases();
            Pattern staPattern = Pattern.compile("*".equals(this.params.getStation()) ? ".*" : this.params.getStation());
            Pattern chanPattern = Pattern.compile("*".equals(this.params.getChannel()) ? ".*" : this.params.getChannel());
            Pattern netPattern = Pattern.compile("*".equals(this.params.getNetwork()) ? ".*" : this.params.getNetwork());
            Pattern locPattern = Pattern.compile("*".equals(this.params.getLocation()) ? ".*" : this.params.getLocation());
            if (this.doChannelList) {
                for (WinstonSCNL scnl : allChannels) {
                    if (staPattern.matcher(scnl.getStation()).matches() && chanPattern.matcher(scnl.getChannel()).matches() && netPattern.matcher(scnl.getNetwork()).matches() && locPattern.matcher(scnl.getLocId() == null ? "" : scnl.getLocId()).matches()) {
                        List<WinstonTable> dayTables = winston.listDayTables(scnl);
                        Collections.sort(dayTables, new Comparator<WinstonTable>(){

                            @Override
                            public int compare(WinstonTable c1, WinstonTable c2) {
                                return c1.getYear() * 10000 + c1.getMonth() * 100 + c1.getDay() - c2.getYear() * 10000 + c2.getMonth() * 100 + c2.getDay();
                            }
                        });
                        String s = scnl.getDatabaseName() + " ";
                        if (dayTables.size() != 0) {
                            WinstonTable first = dayTables.get(0);
                            WinstonTable last = dayTables.get(dayTables.size() - 1);
                            s = s + " " + first.getDateString() + " " + last.getDateString();
                        }
                        System.out.println(s);
                        continue;
                    }
                    logger.debug("Skipping, does not match patterns: " + scnl.getDatabaseName());
                }
            } else if (this.doSync) {
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.params.getDataOutputStream())));
                SyncFileWriter syncOut = new SyncFileWriter("winston", out);
                for (WinstonSCNL scnl : allChannels) {
                    if (staPattern.matcher(scnl.getStation()).matches() && chanPattern.matcher(scnl.getChannel()).matches() && netPattern.matcher(scnl.getNetwork()).matches() && locPattern.matcher(scnl.getLocId() == null ? "" : scnl.getLocId()).matches()) {
                        this.syncChannel(winston, scnl, syncOut);
                        continue;
                    }
                    logger.debug("Skipping, does not match patterns: " + scnl.getDatabaseName());
                }
                syncOut.close();
            } else if (this.doTbZip) {
                File f = new File(this.params.getOutFile());
                String dirName = f.getName();
                dirName = dirName.endsWith(".zip") ? dirName.substring(0, dirName.length() - 4) : dirName + "_TraceBufs";
                ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
                ZipEntry tbzip = new ZipEntry(dirName + "/");
                zip.putNextEntry(tbzip);
                zip.closeEntry();
                for (WinstonSCNL scnl : allChannels) {
                    if (!staPattern.matcher(scnl.getStation()).matches() || !chanPattern.matcher(scnl.getChannel()).matches() || !netPattern.matcher(scnl.getNetwork()).matches() || !locPattern.matcher(scnl.getLocId() == null ? "" : scnl.getLocId()).matches()) continue;
                    this.outputRawTraceBuf2s(winston, scnl, zip, dirName);
                }
                zip.close();
            } else if (this.doExport) {
                EarthwormExport exporter = new EarthwormExport(this.exportPort, this.module, this.institution, this.heartbeatText, this.heartbeat);
                if (this.heartbeatverbose) {
                    exporter.getHeartbeater().setVerbose(this.heartbeatverbose);
                }
                if (this.params.isVerbose()) {
                    exporter.setVerbose(true);
                    System.out.println("Waiting for client connect, port: " + this.exportPort);
                }
                exporter.waitForClient();
                Date startTime = this.params.getBegin();
                HashMap<WinstonSCNL, Date> lastSent = new HashMap<WinstonSCNL, Date>();
                for (WinstonSCNL scnl : allChannels) {
                    if (staPattern.matcher(scnl.getStation()).matches() && chanPattern.matcher(scnl.getChannel()).matches() && netPattern.matcher(scnl.getNetwork()).matches() && locPattern.matcher(scnl.getLocId() == null ? "" : scnl.getLocId()).matches()) {
                        lastSent.put(scnl, startTime);
                        continue;
                    }
                    logger.debug("Skipping, does not match patterns: " + scnl.getDatabaseName());
                }
                while (startTime.before(this.params.getEnd())) {
                    Date chunkEnd = new Date(startTime.getTime() + (long)(this.chunkSeconds * 1000));
                    for (WinstonSCNL scnl : lastSent.keySet()) {
                        Date chunkBegin = (Date)lastSent.get(scnl);
                        if (!chunkBegin.before(chunkEnd)) continue;
                        Date sentEnd = this.exportChannel(winston, scnl, chunkBegin, chunkEnd, exporter);
                        lastSent.put(scnl, new Date(sentEnd.getTime() + 1L));
                    }
                    startTime = new Date(chunkEnd.getTime() + 1L);
                }
                exporter.closeSocket();
                if (this.params.isVerbose()) {
                    System.out.println("Done sending, " + exporter.getNumTraceBufSent() + " (" + exporter.getNumSplitTraceBufSent() + " too big so split)");
                }
            } else {
                for (WinstonSCNL scnl : allChannels) {
                    if (!staPattern.matcher(scnl.getStation()).matches() || !chanPattern.matcher(scnl.getChannel()).matches() || !netPattern.matcher(scnl.getNetwork()).matches() || !locPattern.matcher(scnl.getLocId() == null ? "" : scnl.getLocId()).matches()) continue;
                    this.processChannel(winston, scnl);
                }
                this.params.getDataOutputStream().close();
            }
        }
    }

    void syncChannel(WinstonUtil winston, WinstonSCNL channel, SyncFileWriter syncOut) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(QueryParams.UTC);
        cal.setTime(this.params.getBegin());
        int startYear = cal.get(1);
        int startMonth = cal.get(2) + 1;
        int startDay = cal.get(5);
        cal.setTime(this.params.getEnd());
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int endDay = cal.get(5);
        winston.writeSyncBetweenDates(channel, startYear, startMonth, startDay, endYear, endMonth, endDay, syncOut);
    }

    Date exportChannel(WinstonUtil winston, WinstonSCNL channel, Date begin, Date end, EarthwormExport exporter) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(QueryParams.UTC);
        List<TraceBuf2> tbList = winston.extractData(channel, begin, end);
        Date lastSentEnd = end;
        double sampRate = 1.0;
        TraceBuf2 prev = null;
        for (TraceBuf2 traceBuf2 : tbList) {
            if (this.params.isVerbose()) {
                System.out.println("Tracebuf: " + traceBuf2.getNetwork() + "." + traceBuf2.getStation() + "." + traceBuf2.getLocId() + "." + traceBuf2.getChannel() + " " + sdf.format(traceBuf2.getStartDate()) + " " + traceBuf2.getNumSamples() + " " + sdf.format(traceBuf2.getEndDate()));
            }
            if (prev != null && prev.getEndDate().after(traceBuf2.getStartDate())) {
                System.out.println("WARNING: current tracebuf overlaps previous: ");
                System.out.println("  prev: " + prev);
                System.out.println("  curr: " + traceBuf2);
            }
            exporter.exportWithRetry(traceBuf2);
            if (lastSentEnd.before(traceBuf2.getPredictedNextStartDate())) {
                lastSentEnd = traceBuf2.getPredictedNextStartDate();
                sampRate = traceBuf2.getSampleRate();
            }
            if (this.params.isVerbose()) {
                System.out.print("sleep: " + this.sleepMillis + " milliseconds " + sdf.format(new Date()) + " ...");
            }
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.params.isVerbose()) continue;
            System.out.println("...back to work at " + sdf.format(new Date()) + ".");
        }
        return lastSentEnd;
    }

    void processChannel(WinstonUtil winston, WinstonSCNL channel) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        List<TraceBuf2> tbList = winston.extractData(channel, this.params.getBegin(), this.params.getEnd());
        for (TraceBuf2 traceBuf2 : tbList) {
            List<DataRecord> mseedList = this.doSteim1 ? traceBuf2.toMiniSeed(this.recordSize, 10) : (this.doSteim2 ? traceBuf2.toMiniSeed(this.recordSize, 11) : traceBuf2.toMiniSeedNoCompression(this.recordSize));
            for (DataRecord dr : mseedList) {
                dr.write(this.params.getDataOutputStream());
            }
        }
    }

    void outputRawTraceBuf2s(WinstonUtil winston, WinstonSCNL channel, ZipOutputStream zip, String dir) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        List<TraceBuf2> tbList = winston.extractData(channel, this.params.getBegin(), this.params.getEnd());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss.SSS");
        sdf.setTimeZone(QueryParams.UTC);
        for (TraceBuf2 tb : tbList) {
            ZipEntry tbzip = new ZipEntry(dir + "/" + tb.getNetwork().trim() + "." + tb.getStation().trim() + "." + tb.getLocId().trim() + "." + tb.getChannel().trim() + "." + sdf.format(tb.getStartDate()) + ".tb");
            zip.putNextEntry(tbzip);
            byte[] outBytes = tb.toByteArray();
            zip.write(outBytes, 0, outBytes.length);
            zip.closeEntry();
        }
    }

    String getDbURL() {
        return this.winstonConfig.getProperty("winston.url");
    }

    String getUser() throws URISyntaxException, SeisFileException {
        return WinstonUtil.getUrlQueryParam("user", this.getDbURL());
    }

    String getPassword() throws URISyntaxException, SeisFileException {
        return WinstonUtil.getUrlQueryParam("password", this.getDbURL());
    }

    public String getHelp() {
        return "java " + WinstonClient.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-p <winston.config file>][-u databaseURL][--sync][--steim1][--recLen len(8-12)][[--export port][--chunk sec][--module modNum][--inst institutionNum][--heartbeat sec][--heartbeatverbose]]";
    }
}

