/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.BtimeComparator;
import edu.sc.seis.seisFile.mseed.Utility;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Btime {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public int year = 1960;
    public int jday = 1;
    public int hour = 0;
    public int min = 0;
    public int sec = 0;
    public int tenthMilli = 0;
    private static BtimeComparator comparator = new BtimeComparator();

    public Btime(Date date) {
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTime(date);
        this.setFieldsFromCalendar(cal);
    }

    private void setFieldsFromCalendar(Calendar cal) {
        if (!cal.getTimeZone().equals(UTC)) {
            throw new IllegalArgumentException("Calendar time zone is not UTC: " + cal.getTimeZone());
        }
        this.tenthMilli = cal.get(14) * 10;
        this.year = cal.get(1);
        this.jday = cal.get(6);
        this.hour = cal.get(11);
        this.min = cal.get(12);
        this.sec = cal.get(13);
    }

    public Btime() {
    }

    public Btime(int year, int jday, int hour, int min, int sec, int tenthMilli) {
        this.year = year;
        this.jday = jday;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.tenthMilli = tenthMilli;
    }

    public Btime(byte[] bytes) {
        this(bytes, 0);
    }

    public Btime(byte[] bytes, int offset) {
        boolean byteSwapFlag = Btime.shouldSwapBytes(bytes, offset);
        this.year = Utility.uBytesToInt(bytes[offset], bytes[offset + 1], byteSwapFlag);
        this.jday = Utility.uBytesToInt(bytes[offset + 2], bytes[offset + 3], byteSwapFlag);
        this.hour = bytes[offset + 4] & 0xFF;
        this.min = bytes[offset + 5] & 0xFF;
        this.sec = bytes[offset + 6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(bytes[offset + 8], bytes[offset + 9], byteSwapFlag);
    }

    public Btime(double d) {
        long millis = Math.round(Math.floor(d * 1000.0));
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTimeInMillis(millis);
        this.setFieldsFromCalendar(cal);
        this.tenthMilli = (int)(Math.round(d * 10000.0) % 10000L);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.hour;
        result = 31 * result + this.jday;
        result = 31 * result + this.min;
        result = 31 * result + this.sec;
        result = 31 * result + this.tenthMilli;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Btime) {
            Btime oBtime = (Btime)o;
            return oBtime.year == this.year && oBtime.jday == this.jday && oBtime.hour == this.hour && oBtime.min == this.min && oBtime.sec == this.sec && oBtime.tenthMilli == this.tenthMilli;
        }
        return false;
    }

    public boolean before(Btime other) {
        return comparator.compare(this, other) == -1;
    }

    public boolean after(Btime other) {
        return comparator.compare(this, other) == 1;
    }

    public boolean afterOrEquals(Btime other) {
        return comparator.compare(this, other) >= 0;
    }

    public Calendar convertToCalendar() {
        Calendar cal = GregorianCalendar.getInstance(UTC);
        cal.set(14, this.getTenthMilli() / 10);
        cal.set(13, this.getSec());
        cal.set(12, this.getMin());
        cal.set(11, this.getHour());
        cal.set(6, this.getDayOfYear());
        cal.set(1, this.getYear());
        return cal;
    }

    public String toString() {
        return "BTime(" + this.year + ":" + this.jday + ":" + this.hour + ":" + this.min + ":" + this.sec + "." + this.tenthMilli + ")";
    }

    public int getYear() {
        return this.year;
    }

    public int getDayOfYear() {
        return this.getJDay();
    }

    public int getJDay() {
        return this.jday;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.min;
    }

    public int getSec() {
        return this.sec;
    }

    public int getTenthMilli() {
        return this.tenthMilli;
    }

    public static boolean shouldSwapBytes(byte[] btime) {
        return Btime.shouldSwapBytes(btime, 0);
    }

    public static boolean shouldSwapBytes(byte[] btime, int offset) {
        int year = Utility.uBytesToInt(btime[0 + offset], btime[1 + offset], false);
        return year < 1960 || year > 2055;
    }

    public byte[] getAsBytes() {
        byte[] bytes = new byte[10];
        System.arraycopy(Utility.intToByteArray(this.year), 2, bytes, 0, 2);
        System.arraycopy(Utility.intToByteArray(this.jday), 2, bytes, 2, 2);
        System.arraycopy(Utility.intToByteArray(this.hour), 3, bytes, 4, 1);
        System.arraycopy(Utility.intToByteArray(this.min), 3, bytes, 5, 1);
        System.arraycopy(Utility.intToByteArray(this.sec), 3, bytes, 6, 1);
        System.arraycopy(Utility.intToByteArray(this.tenthMilli), 2, bytes, 8, 2);
        return bytes;
    }
}

