/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.iris.dmc.seedcodec.Utility;
import edu.sc.seis.seisFile.gcf.GCFBlock;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import edu.sc.seis.seisFile.gcf.GCFHeader;
import edu.sc.seis.seisFile.gcf.GCFStatusBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractGCFBlock {
    GCFHeader header;

    protected AbstractGCFBlock(GCFHeader header) {
        this.header = header;
    }

    public GCFHeader getHeader() {
        return this.header;
    }

    public abstract int getSize();

    public abstract void write(DataOutput var1) throws NumberFormatException, IOException;

    public static AbstractGCFBlock read(DataInput in, boolean isSerial) throws IOException, GCFFormatException {
        GCFHeader h = GCFHeader.read(in);
        try {
            if (h.getSps() != 0.0f) {
                int i;
                int fs;
                int samp = fs = Utility.bytesToInt((byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (boolean)false);
                int[] d = new int[h.getNumPoints()];
                d[0] = samp;
                if (h.getCompression() == 1 && isSerial) {
                    for (i = 0; i < d.length; ++i) {
                        d[i] = Utility.bytesToInt((byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (boolean)false);
                    }
                } else if (h.getCompression() == 1 && !isSerial) {
                    for (i = 0; i < d.length; ++i) {
                        d[i] = Utility.bytesToInt((byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (boolean)false);
                    }
                } else if (h.getCompression() == 2) {
                    for (i = 0; i < d.length; ++i) {
                        d[i] = Utility.bytesToInt((byte)in.readByte(), (byte)in.readByte(), (boolean)false);
                    }
                } else if (h.getCompression() == 4) {
                    for (i = 0; i < d.length; ++i) {
                        d[i] = Utility.bytesToInt((byte)in.readByte());
                    }
                }
                int ls = Utility.bytesToInt((byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (byte)in.readByte(), (boolean)false);
                return new GCFBlock(h, d, fs, ls, isSerial);
            }
            byte[] statusBits = new byte[h.getNum32Records() * 4];
            in.readFully(statusBits);
            return new GCFStatusBlock(h, new String(statusBits));
        }
        catch (IOException e) {
            throw new GCFFormatException("Problem reading GCF block body. header:" + h, e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGCFBlock other = (AbstractGCFBlock)obj;
        return !(this.header == null ? other.header != null : !this.header.equals(other.header));
    }
}

