/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Coefficients
extends BaseFilterType {
    private String cfTransferType;
    List<FloatType> numeratorList = new ArrayList<FloatType>();
    List<FloatType> denominatorList = new ArrayList<FloatType>();

    public Coefficients(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Coefficients", reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("CfTransferFunctionType")) {
                    this.cfTransferType = StaxUtil.pullText(reader, "CfTransferFunctionType");
                    continue;
                }
                if (elName.equals("Numerator")) {
                    this.numeratorList.add(new FloatType(reader, "Numerator"));
                    continue;
                }
                if (elName.equals("Denominator")) {
                    this.denominatorList.add(new FloatType(reader, "Denominator"));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getCfTransferType() {
        return this.cfTransferType;
    }

    public List<FloatType> getNumeratorList() {
        return this.numeratorList;
    }

    public List<FloatType> getDenominatorList() {
        return this.denominatorList;
    }
}

