/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Switch;
import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.client.BoxAreaParser;
import edu.sc.seis.seisFile.client.DonutParser;
import edu.sc.seis.seisFile.client.ISOTimeParser;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNClient;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.LevelParser;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataAvailability;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class StationClient
extends AbstractFDSNClient {
    public StationClient(String[] args) throws JSAPException {
        super(args);
    }

    @Override
    protected void addParams() throws JSAPException {
        super.addParams();
        this.add((Parameter)BoxAreaParser.createParam("Event constraining box as west/east/south/north"));
        this.add((Parameter)DonutParser.createParam("Event constraining donut as lat/lon/minRadius/maxRadius"));
        this.add((Parameter)ISOTimeParser.createParam("begin", "The earliest time for acceptance", false));
        this.add((Parameter)ISOTimeParser.createParam("end", "The latest time for acceptance", true));
        this.add((Parameter)this.createListOption("network", 'n', "network", "A comma separated list of networks to search"));
        this.add((Parameter)this.createListOption("station", 's', "station", "A comma separated list of stations to search"));
        this.add((Parameter)this.createListOption("location", 'l', "location", "A comma separated list of locations to search"));
        this.add((Parameter)this.createListOption("channel", 'c', "channel", "A comma separated list of channels to search"));
        this.add((Parameter)LevelParser.createFlaggedOption());
        this.add((Parameter)new Switch("includeavailability", '\u0000', "availability", "include information about time series data availability"));
        this.add((Parameter)new Switch("includerestricted", '\u0000', "restricted", "include information for restricted stations"));
        this.add((Parameter)ISOTimeParser.createParam("updatedafter", "Only results that have changed since the date are accepted", false));
        this.add((Parameter)new Switch("validate", '\u0000', "validate", "Validate XML against schema"));
    }

    public void run() {
        JSAPResult result = this.getResult();
        if (this.shouldPrintHelp()) {
            System.out.println(this.jsap.getHelp());
            return;
        }
        if (this.shouldPrintVersion()) {
            System.out.println(BuildVersion.getVersion());
            return;
        }
        if (!this.isSuccess()) {
            Iterator errs = result.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println();
            System.err.println("Usage: java " + this.getClass().getName());
            System.err.println("                " + this.jsap.getUsage());
            System.err.println();
            System.err.println(this.jsap.getHelp());
            return;
        }
        try {
            FDSNStationQueryParams queryParams = this.configureQuery(result);
            if (this.getResult().getBoolean("printurl")) {
                System.out.println(queryParams.formURI());
                return;
            }
            FDSNStationQuerier querier = new FDSNStationQuerier(queryParams);
            if (this.getResult().getBoolean("validate")) {
                querier.validateFDSNStationXML();
                System.out.println("Valid");
            } else if (this.getResult().getBoolean("raw")) {
                querier.outputRaw(System.out);
            } else {
                FDSNStationXML stationXml = querier.getFDSNStationXML();
                if (!stationXml.checkSchemaVersion()) {
                    System.out.println("");
                    System.out.println("WARNING: XmlSchema of this document does not match this code, results may be incorrect.");
                    System.out.println("XmlSchema (code): 1.0");
                    System.out.println("XmlSchema (doc): " + stationXml.getSchemaVersion());
                }
                this.handleResults(stationXml);
                stationXml.closeReader();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    FDSNStationQueryParams configureQuery(JSAPResult result) throws SeisFileException {
        int i;
        String[] vals;
        FDSNStationQueryParams queryParams = new FDSNStationQueryParams();
        if (result.contains("box")) {
            HashMap box = (HashMap)result.getObject("box");
            queryParams.area(Float.parseFloat((String)box.get("west")), Float.parseFloat((String)box.get("east")), Float.parseFloat((String)box.get("south")), Float.parseFloat((String)box.get("north")));
        }
        if (result.contains("donut")) {
            HashMap donut = (HashMap)result.getObject("donut");
            queryParams.donut(Float.parseFloat((String)donut.get("lat")), Float.parseFloat((String)donut.get("lon")), Float.parseFloat((String)donut.get("min")), Float.parseFloat((String)donut.get("max")));
        }
        if (result.contains("updatedafter")) {
            queryParams.setUpdatedAfter((Date)result.getObject("updatedafter"));
        }
        if (result.contains("begin")) {
            queryParams.setEndAfter((Date)result.getObject("begin"));
        }
        if (result.contains("end")) {
            queryParams.setStartBefore((Date)result.getObject("end"));
        }
        if (result.contains("network")) {
            vals = result.getStringArray("network");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToNetwork(vals[i]);
            }
        }
        if (result.contains("station")) {
            vals = result.getStringArray("station");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToStation(vals[i]);
            }
        }
        if (result.contains("location")) {
            vals = result.getStringArray("location");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToLocation(vals[i]);
            }
        }
        if (result.contains("channel")) {
            vals = result.getStringArray("channel");
            for (i = 0; i < vals.length; ++i) {
                queryParams.appendToChannel(vals[i]);
            }
        }
        if (result.contains("level")) {
            queryParams.setLevel(result.getString("level"));
        }
        if (result.getBoolean("includeavailability")) {
            queryParams.setIncludeAvailability(true);
        }
        if (result.getBoolean("includerestricted")) {
            queryParams.setIncludeRestricted(true);
        }
        if (result.contains("host")) {
            queryParams.setHost(result.getString("host"));
        }
        if (result.contains("baseurl")) {
            try {
                queryParams.internalSetBaseURI(new URI(result.getString("baseurl")));
            }
            catch (URISyntaxException e) {
                throw new SeisFileException("Unable to parse URI: " + result.getString("baseurl"), e);
            }
        }
        return queryParams;
    }

    public void handleResults(FDSNStationXML stationXml) throws XMLStreamException, SeisFileException {
        NetworkIterator nIt = stationXml.getNetworks();
        while (nIt.hasNext()) {
            Network n = nIt.next();
            System.out.println(n.getCode() + " " + n.getStartDate() + " " + n.getDescription() + " " + this.extractDataAvailability(n));
            StationIterator sIt = n.getStations();
            while (sIt.hasNext()) {
                Station s = sIt.next();
                System.out.println("    " + n.getCode() + "." + s.getCode() + " " + s.getLatitude() + "/" + s.getLongitude() + " " + s.getSite() + " " + s.getStartDate() + " " + this.extractDataAvailability(s));
                List<Channel> chanList = s.getChannelList();
                for (Channel channel : chanList) {
                    System.out.println("        " + channel.getLocCode() + "." + channel.getCode() + " " + channel.getAzimuth() + "/" + channel.getDip() + " " + channel.getDepth().getValue() + " " + channel.getDepth().getUnit() + " " + channel.getStartDate() + " " + this.extractDataAvailability(channel));
                }
            }
        }
    }

    String extractDataAvailability(BaseNodeType node) {
        DataAvailability da = node.getDataAvailability();
        if (da != null && da.getExtent() != null) {
            return " (" + da.getExtent().getStart() + " to " + da.getExtent().getEnd() + ") ";
        }
        return "";
    }

    public static void main(String[] args) throws JSAPException {
        new StationClient(args).run();
    }
}

