/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.earthworm.BufferingEarthwormExport;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBufferingEarthwormExport
extends BufferingEarthwormExport {
    File bufferDir = new File("buffer");
    String filePrefix = "earthwormBuf";
    List<File> fileBuffers;
    List<TraceBuf2> popBuffer;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH:mm:ss.SSS");
    private static final Logger logger = LoggerFactory.getLogger(FileBufferingEarthwormExport.class);

    public FileBufferingEarthwormExport(int port, int module, int institution, String heartbeatMessage, int heartbeatSeconds, int bufferSize, int sleepMillis, String bufferDirPath) throws UnknownHostException, IOException, SeisFileException {
        super(port, module, institution, heartbeatMessage, heartbeatSeconds, bufferSize, sleepMillis);
        if (bufferDirPath != null) {
            this.bufferDir = new File(bufferDirPath);
            if (!this.bufferDir.exists() && !this.bufferDir.mkdirs()) {
                throw new SeisFileException("Unable to create all parent dirs for " + bufferDirPath);
            }
        }
        this.fileBuffers = Collections.synchronizedList(new ArrayList());
        this.popBuffer = Collections.synchronizedList(new ArrayList(this.maxSize));
        List<String> bufferFileList = Arrays.asList(this.bufferDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(FileBufferingEarthwormExport.this.filePrefix);
            }
        }));
        Collections.sort(bufferFileList);
        for (String filename : bufferFileList) {
            this.fileBuffers.add(new File(this.bufferDir, filename));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = FileBufferingEarthwormExport.this.buffer;
                synchronized (list) {
                    FileBufferingEarthwormExport.this.saveBufferToFile();
                    FileBufferingEarthwormExport.this.buffer.notifyAll();
                }
            }
        });
    }

    @Override
    public void offer(TraceBuf2 tb) {
        if (this.buffer.size() >= this.getMaxSize()) {
            this.saveBufferToFile();
        }
        logger.info("call super.offer");
        super.offer(tb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveBufferToFile() {
        logger.info("save buffer to file " + this.buffer.size());
        ArrayList<TraceBuf2> tempBuf = new ArrayList<TraceBuf2>(this.buffer.size() + 1);
        List list = this.buffer;
        synchronized (list) {
            logger.info("In Sync");
            for (TraceBuf2 bufTB : this.buffer) {
                tempBuf.add(bufTB);
            }
            this.buffer.clear();
            logger.info("after clear");
            this.buffer.notifyAll();
        }
        logger.info("mem copied buffer.size()=" + this.buffer.size() + " " + tempBuf.size());
        File bufFile = this.nextBufferFile((TraceBuf2)tempBuf.get(0));
        logger.info("Writing " + tempBuf.size() + " tb to " + bufFile.getAbsolutePath());
        this.fileBuffers.add(bufFile);
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(bufFile)));
            for (TraceBuf2 traceBuf2 : tempBuf) {
                traceBuf2.write(dos);
            }
            dos.close();
        }
        catch (FileNotFoundException e) {
            logger.error("Unable to save to file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to save to file", (Throwable)e);
        }
        logger.info("Done writing to " + bufFile.getAbsolutePath());
    }

    @Override
    public TraceBuf2 pop() {
        while (this.popBuffer.size() == 0 && this.fileBuffers.size() != 0) {
            File next = this.fileBuffers.remove(0);
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(next)));
                while (in.available() > 0) {
                    TraceBuf2 tb = TraceBuf2.read(in);
                    this.popBuffer.add(tb);
                }
                next.delete();
                return this.popBuffer.remove(0);
            }
            catch (FileNotFoundException e) {
                logger.error("Unable to load from file: " + next, (Throwable)e);
            }
            catch (EOFException e) {
                logger.error("IOException loading from file: " + next, (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IOException loading from file: " + next, (Throwable)e);
            }
        }
        if (this.popBuffer.size() != 0) {
            return this.popBuffer.remove(0);
        }
        return super.pop();
    }

    File nextBufferFile(TraceBuf2 tb) {
        String filename = this.filePrefix + this.sdf.format(tb.getStartDate());
        return new File(this.bufferDir, filename);
    }
}

