/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile;

import edu.sc.seis.seisFile.SeisFileException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class QueryParams {
    protected String network;
    protected String station;
    protected String location;
    protected String channel;
    protected Date begin;
    protected Date end;
    protected Float duration = Float.valueOf(600.0f);
    protected int maxRecords = -1;
    protected String outFile = null;
    protected boolean verbose = false;
    protected boolean timed = false;
    protected boolean printVersion = false;
    protected boolean printHelp = false;
    protected DataOutputStream dos = null;
    protected boolean append = false;
    QueryParams defaults;
    List<String> unknownArgs = new ArrayList<String>();
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public QueryParams(String[] args) throws SeisFileException {
        this(args, null);
    }

    public QueryParams(String[] args, QueryParams defaults) throws SeisFileException {
        this.defaults = defaults;
        for (int i = 0; i < args.length; ++i) {
            if (i < args.length - 1) {
                if (args[i].equals("-n")) {
                    this.network = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-s")) {
                    this.station = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-l")) {
                    this.location = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-c")) {
                    this.channel = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-b")) {
                    this.begin = this.extractDate(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-e")) {
                    this.end = this.extractDate(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-d")) {
                    this.duration = Float.valueOf(Float.parseFloat(args[i + 1]));
                    ++i;
                    continue;
                }
                if (args[i].equals("-o")) {
                    this.outFile = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-m")) {
                    this.maxRecords = Integer.parseInt(args[i + 1]);
                    ++i;
                    if (this.maxRecords >= -1) continue;
                    this.maxRecords = -1;
                    continue;
                }
            }
            if (args[i].equals("--append")) {
                this.append = true;
                continue;
            }
            if (args[i].equals("--verbose")) {
                this.setVerbose(true);
                continue;
            }
            if (args[i].equals("--timed")) {
                this.timed = true;
                continue;
            }
            if (args[i].equals("--version")) {
                this.printVersion = true;
                continue;
            }
            if (args[i].equals("--help")) {
                this.printHelp = true;
                continue;
            }
            this.unknownArgs.add(args[i]);
        }
        if (args.length == 0) {
            this.printHelp = true;
        }
        GregorianCalendar cal = new GregorianCalendar(UTC);
        cal.add(13, -1 * Math.round(this.duration.floatValue()));
        cal.add(14, -1000 * Math.round(this.duration.floatValue() - (float)Math.round(this.duration.floatValue())));
        if (this.begin == null) {
            this.begin = cal.getTime();
        }
        if (this.end == null) {
            cal.setTime(this.begin);
            cal.add(13, Math.round(this.duration.floatValue()));
            cal.add(14, 1000 * Math.round(this.duration.floatValue() - (float)Math.round(this.duration.floatValue())));
            this.end = cal.getTime();
        }
    }

    public String getNetwork() {
        if (this.network == null && this.defaults != null) {
            return this.defaults.getNetwork();
        }
        return this.network;
    }

    public String getStation() {
        if (this.station == null && this.defaults != null) {
            return this.defaults.getStation();
        }
        return this.station;
    }

    public String getLocation() {
        if (this.location == null) {
            if (this.defaults != null) {
                return this.defaults.getLocation();
            }
            return "  ";
        }
        return this.location;
    }

    public String getChannel() {
        if (this.channel == null && this.defaults != null) {
            return this.defaults.getChannel();
        }
        return this.channel;
    }

    public Date getBegin() {
        return this.begin;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }

    public Float getDuration() {
        return this.duration;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public static String getStandardHelpOptions() {
        return "[-n net][-s sta][-l loc][-c chan][-b yyyy-MM-dd[THH:mm:ss.SSS]][-e yyyy-MM-dd[THH:mm:ss.SSS]][-d seconds][-o outfile][-m maxpackets][--append][--verbose][--version][--help]";
    }

    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        if (this.dos == null) {
            this.dos = this.getOutFile() == null ? new DataOutputStream(System.out) : new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile, this.isAppend())));
        }
        return this.dos;
    }

    Date extractDate(String dateString) throws SeisFileException {
        int zoneIndex = (dateString = dateString.trim()).indexOf(90);
        if (zoneIndex == -1) {
            if (dateString.length() > 10 && dateString.matches(".+\\d")) {
                dateString = dateString + "GMT";
            }
        } else if (dateString.charAt(zoneIndex) == 'Z') {
            dateString = dateString.substring(0, zoneIndex) + "GMT";
        }
        SimpleDateFormat dateFormat = dateString.length() > 22 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz") : (dateString.length() > 18 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz") : new SimpleDateFormat("yyyy-MM-dd"));
        dateFormat.setTimeZone(UTC);
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw new SeisFileException("Illegal date format, should be: yyyy-MM-dd or yyyy-MM-dd'T'HH:mm:ss or yyyy-MM-dd'T'HH:mm:ss.SSS", e);
        }
    }

    public boolean isTimed() {
        return this.timed;
    }

    public void setTimed(boolean timed) {
        this.timed = timed;
    }

    public List<String> getUnknownArgs() {
        return this.unknownArgs;
    }
}

