/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationIdUtil;

public class StationImpl
extends Station {
    protected int dbid;

    protected StationImpl() {
    }

    public static StationImpl createEmpty() {
        return new StationImpl();
    }

    public StationImpl(StationId id, String name, Location my_location, TimeRange effective_time, String operator, String description, String comment, NetworkAttr my_network) {
        this.id = id;
        this.name = name;
        this.setLocation(my_location);
        this.setEffectiveTime(effective_time);
        this.operator = operator;
        this.description = description;
        this.comment = comment;
        this.setNetworkAttr(my_network);
    }

    public StationImpl(StationId id, String name, Location my_location, String operator, String description, String comment, NetworkAttr my_network) {
        this(id, name, my_location, new TimeRange(id.begin_time, TimeUtils.timeUnknown), operator, description, comment, my_network);
    }

    public StationId get_id() {
        return this.getId();
    }

    public String get_code() {
        return this.getId().station_code;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    public int getDbid() {
        return this.dbid;
    }

    public void associateInDB(StationImpl indb) {
        this.setDbid(indb.getDbid());
    }

    public static StationImpl[] implize(Station[] stations) {
        StationImpl[] out = new StationImpl[stations.length];
        for (int i = 0; i < stations.length; ++i) {
            out[i] = (StationImpl)stations[i];
        }
        return out;
    }

    public NetworkAttrImpl getNetworkAttrImpl() {
        return (NetworkAttrImpl)this.getNetworkAttr();
    }

    public String toString() {
        return StationIdUtil.toStringNoDates(this);
    }
}

