/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.network.NetworkIdUtil;

public class NetworkAttrImpl
extends NetworkAttr {
    protected int dbid;
    protected String sourceServerName;
    protected String sourceServerDNS;

    protected NetworkAttrImpl() {
    }

    public static NetworkAttrImpl createEmpty() {
        return new NetworkAttrImpl();
    }

    public NetworkAttrImpl(NetworkId id, String name, String description, String owner, TimeRange effective_time) {
        this.id = id;
        this.setName(name);
        this.setDescription(description);
        this.setOwner(owner);
        this.setEffectiveTime(effective_time);
    }

    public NetworkAttrImpl(NetworkId id, String name, String description, String owner) {
        this(id, name, description, owner, new TimeRange(id.begin_time, TimeUtils.timeUnknown));
    }

    public NetworkId get_id() {
        return this.id;
    }

    public String get_code() {
        return this.id.network_code;
    }

    public void updateBeginTime(Time t) {
        this.getId().begin_time = t;
        this.setBeginTime(t);
    }

    public String getSourceServerName() {
        return this.sourceServerName;
    }

    public void setSourceServerName(String sourceServerName) {
        this.sourceServerName = sourceServerName;
    }

    public String getSourceServerDNS() {
        return this.sourceServerDNS;
    }

    public void setSourceServerDNS(String sourceServerDNS) {
        this.sourceServerDNS = sourceServerDNS;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    public int getDbid() {
        return this.dbid;
    }

    public void associateInDB(NetworkAttrImpl attr) {
        this.setDbid(attr.getDbid());
    }

    public boolean equals(Object o) {
        if (o instanceof NetworkAttr) {
            NetworkAttr n = (NetworkAttr)o;
            return NetworkIdUtil.areEqual(this.get_id(), n.get_id());
        }
        return false;
    }

    public int hashCode() {
        return NetworkIdUtil.hashCode(this.get_id());
    }

    public String toString() {
        return NetworkIdUtil.toString(this);
    }
}

