/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitBase;
import edu.iris.Fissures.model.UnitImpl;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class QuantityImpl
extends Quantity {
    protected NumberFormat format = null;

    protected QuantityImpl() {
    }

    public static Serializable createEmpty() {
        return new QuantityImpl();
    }

    public QuantityImpl(double f, Unit the_unit) {
        this.value = f;
        this.the_units = the_unit;
    }

    public static QuantityImpl createQuantityImpl(Quantity q) {
        if (q instanceof QuantityImpl) {
            return (QuantityImpl)q;
        }
        return new QuantityImpl(q.value, UnitImpl.createUnitImpl(q.the_units));
    }

    @Deprecated
    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public String formatValue(String format) {
        return new DecimalFormat(format).format(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(UnitImpl unit) {
        return this.convertTo(unit).getValue();
    }

    protected void setValue(double value) {
        this.value = value;
    }

    public double get_value() {
        return this.getValue();
    }

    public UnitImpl getUnit() {
        return (UnitImpl)this.the_units;
    }

    protected void setUnit(UnitImpl unit) {
        this.the_units = unit;
    }

    public UnitImpl get_unit() {
        return this.getUnit();
    }

    public QuantityImpl convertTo(UnitImpl newUnit) {
        UnitImpl currUnit = this.getUnit();
        if (currUnit.equals((Object)newUnit)) {
            return this;
        }
        if (!currUnit.isConvertableTo(newUnit)) {
            throw new IllegalArgumentException("Cannot convert, units are not compatible, " + (Object)((Object)currUnit) + " and " + (Object)((Object)newUnit));
        }
        if (currUnit.the_unit_base == UnitBase.KELVIN) {
            if (currUnit.name.equalsIgnoreCase("KELVIN")) {
                if (newUnit.name.equalsIgnoreCase("CELSIUS")) {
                    return new QuantityImpl(this.getValue() - 273.15, newUnit);
                }
                if (newUnit.name.equalsIgnoreCase("FAHRENHEIT")) {
                    return new QuantityImpl((this.getValue() - 273.15) * 9.0 / 5.0 + 32.0, newUnit);
                }
            } else if (currUnit.name.equalsIgnoreCase("CELSIUS")) {
                if (newUnit.name.equalsIgnoreCase("KELVIN")) {
                    return new QuantityImpl(this.getValue() + 273.15, newUnit);
                }
                if (newUnit.name.equalsIgnoreCase("FAHRENHEIT")) {
                    return new QuantityImpl(this.getValue() * 9.0 / 5.0 + 32.0, newUnit);
                }
            } else if (currUnit.name.equalsIgnoreCase("FAHRENHEIT")) {
                if (newUnit.name.equalsIgnoreCase("CELSIUS")) {
                    return new QuantityImpl((this.getValue() - 32.0) * 5.0 / 9.0, newUnit);
                }
                if (newUnit.name.equalsIgnoreCase("KELVIN")) {
                    return new QuantityImpl((this.getValue() - 32.0) * 5.0 / 9.0 + 273.15, newUnit);
                }
            }
        }
        double mulfac = currUnit.getTotalMultiFactor() / newUnit.getTotalMultiFactor();
        int powerDiff = currUnit.getTotalPower() - newUnit.getTotalPower();
        double newValue = this.getValue() * mulfac;
        if (powerDiff != 0) {
            newValue *= Math.pow(10.0, powerDiff);
        }
        return new QuantityImpl(newValue, newUnit);
    }

    public QuantityImpl add(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return new QuantityImpl(this.getValue() + val, this.getUnit());
    }

    public QuantityImpl subtract(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return new QuantityImpl(this.getValue() - val, this.getUnit());
    }

    public QuantityImpl multiplyBy(QuantityImpl q) {
        double val = q.getValue();
        return new QuantityImpl(this.getValue() * val, UnitImpl.multiply(this.getUnit(), q.getUnit()));
    }

    public QuantityImpl divideBy(QuantityImpl q) {
        double val = q.getValue();
        return new QuantityImpl(this.getValue() / val, UnitImpl.divide(this.getUnit(), q.getUnit()));
    }

    public QuantityImpl multiplyBy(double f) {
        return new QuantityImpl(this.getValue() * f, this.getUnit());
    }

    public QuantityImpl divideBy(double f) {
        return new QuantityImpl(this.getValue() / f, this.getUnit());
    }

    public QuantityImpl abs() {
        return new QuantityImpl(Math.abs(this.getValue()), this.getUnit());
    }

    public QuantityImpl inverse() {
        return new QuantityImpl(1.0 / this.getValue(), this.getUnit().inverse());
    }

    public String toString() {
        if (this.format == null) {
            return this.getValue() + " " + (Object)((Object)this.getUnit());
        }
        return this.format.format(this.getValue()) + " " + (Object)((Object)this.getUnit());
    }

    public boolean greaterThan(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() > val;
    }

    public boolean greaterThanEqual(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() >= val;
    }

    public boolean lessThan(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() < val;
    }

    public boolean lessThanEqual(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() <= val;
    }

    public int hashCode() {
        int result = 22;
        long valBits = Double.doubleToLongBits(this.value);
        result = 37 * result + (int)(valBits ^ valBits >>> 32);
        result = 37 * result + this.the_units.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof QuantityImpl) {
            QuantityImpl q = (QuantityImpl)((Object)o);
            if (this.getUnit().isConvertableTo(q.getUnit()) && q.convertTo(this.getUnit()).getValue() == this.getValue()) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        QuantityImpl q = new QuantityImpl(5.0, UnitImpl.HOUR);
        QuantityImpl halfq = new QuantityImpl(2.5, UnitImpl.HOUR);
        System.out.println("q=" + (Object)((Object)q));
        System.out.println("q.convertTo(UnitImpl.SECOND)=" + (Object)((Object)q.convertTo(UnitImpl.SECOND)));
        System.out.println("q.inverse=" + (Object)((Object)q.inverse()));
        System.out.println("q.add(q)=" + (Object)((Object)q.add(q)));
        System.out.println("q.subtract(halfq)=" + (Object)((Object)q.subtract(halfq)));
        System.out.println("q.convertTo(MICROSECOND)=" + (Object)((Object)q.convertTo(UnitImpl.MICROSECOND)));
        QuantityImpl p = new QuantityImpl(10.0, UnitImpl.METER);
        System.out.println("p=" + (Object)((Object)p));
        System.out.println("p.divideBy(q)=" + (Object)((Object)p.divideBy(q)));
        System.out.println("p.multiplyBy(q)=" + (Object)((Object)p.multiplyBy(q)));
    }
}

