/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class Targets {
    static final int MAX_NODELIST = 7;
    static final int GEO_TARGETS = 0;
    static final int ENV_TARGETS = 1;
    static final int BEH_TARGETS = 2;
    static final int SND_TARGETS = 3;
    static final int VPF_TARGETS = 4;
    static final int BLN_TARGETS = 5;
    static final int GRP_TARGETS = 6;
    ArrayList[] targetList = new ArrayList[7];

    Targets() {
    }

    void addNode(NnuId nnuId, int n) {
        if (this.targetList[n] == null) {
            this.targetList[n] = new ArrayList(1);
        }
        this.targetList[n].add(nnuId);
    }

    void addNodeArray(NnuId[] nnuIdArray, int n) {
        if (this.targetList[n] == null) {
            this.targetList[n] = new ArrayList(1);
        }
        this.targetList[n].add(nnuIdArray);
    }

    void removeNode(int n, int n2) {
        if (this.targetList[n2] != null) {
            this.targetList[n2].remove(n);
        }
    }

    void addNodes(ArrayList arrayList, int n) {
        if (this.targetList[n] == null) {
            this.targetList[n] = new ArrayList(1);
        }
        this.targetList[n].addAll(arrayList);
    }

    void clearNodes() {
        int n = 0;
        while (n < 7) {
            if (this.targetList[n] != null) {
                this.targetList[n].clear();
            }
            ++n;
        }
    }

    CachedTargets snapShotInit() {
        CachedTargets cachedTargets = new CachedTargets();
        int n = 0;
        while (n < 7) {
            if (this.targetList[n] != null) {
                int n2 = this.targetList[n].size();
                NnuId[] nnuIdArray = new NnuId[n2];
                this.targetList[n].toArray(nnuIdArray);
                cachedTargets.targetArr[n] = nnuIdArray;
                NnuIdManager.sort(cachedTargets.targetArr[n]);
            } else {
                cachedTargets.targetArr[n] = null;
            }
            ++n;
        }
        this.clearNodes();
        return cachedTargets;
    }

    CachedTargets snapShotAdd(CachedTargets cachedTargets) {
        CachedTargets cachedTargets2 = new CachedTargets();
        int n = 0;
        while (n < 7) {
            NnuId[] nnuIdArray;
            int n2;
            if (this.targetList[n] != null && cachedTargets.targetArr[n] == null) {
                n2 = this.targetList[n].size();
                nnuIdArray = new NnuId[n2];
                this.targetList[n].toArray(nnuIdArray);
                cachedTargets2.targetArr[n] = nnuIdArray;
                NnuIdManager.sort(cachedTargets2.targetArr[n]);
            } else if (this.targetList[n] != null && cachedTargets.targetArr[n] != null) {
                n2 = this.targetList[n].size();
                nnuIdArray = new NnuId[n2];
                this.targetList[n].toArray(nnuIdArray);
                NnuIdManager.sort(nnuIdArray);
                cachedTargets2.targetArr[n] = NnuIdManager.merge(cachedTargets.targetArr[n], nnuIdArray);
            } else if (this.targetList[n] == null && cachedTargets.targetArr[n] != null) {
                cachedTargets2.targetArr[n] = cachedTargets.targetArr[n];
            }
            ++n;
        }
        this.clearNodes();
        return cachedTargets2;
    }

    CachedTargets snapShotRemove(CachedTargets cachedTargets) {
        CachedTargets cachedTargets2 = new CachedTargets();
        int n = 0;
        while (n < 7) {
            if (this.targetList[n] != null && cachedTargets.targetArr[n] != null) {
                int n2 = this.targetList[n].size();
                NnuId[] nnuIdArray = new NnuId[n2];
                this.targetList[n].toArray(nnuIdArray);
                NnuIdManager.sort(nnuIdArray);
                cachedTargets2.targetArr[n] = NnuIdManager.delete(cachedTargets.targetArr[n], nnuIdArray);
            } else if (this.targetList[n] == null && cachedTargets.targetArr[n] != null) {
                cachedTargets2.targetArr[n] = cachedTargets.targetArr[n];
            } else if (this.targetList[n] != null && cachedTargets.targetArr[n] == null) {
                System.out.println("You can't remove something that isn't there");
            }
            ++n;
        }
        this.clearNodes();
        return cachedTargets2;
    }

    boolean isEmpty() {
        boolean bl = true;
        int n = 0;
        while (n < 7) {
            if (this.targetList[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    void addCachedTargets(CachedTargets cachedTargets) {
        int n = 0;
        while (n < 7) {
            if (cachedTargets.targetArr[n] != null) {
                this.addNodeArray(cachedTargets.targetArr[n], n);
            }
            ++n;
        }
    }

    void dump() {
        int n = 0;
        while (n < 7) {
            if (this.targetList[n] != null) {
                System.out.println("  " + CachedTargets.typeString[n]);
                int n2 = 0;
                while (n2 < this.targetList[n].size()) {
                    System.out.println("  " + this.targetList[n].get(n2));
                    ++n2;
                }
            }
            ++n;
        }
    }
}

