/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.wanderer;

import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.File;

public class ChangeCase
extends Wanderer
implements WandererCallback {
    boolean toUpper = false;
    boolean verbose = false;

    public ChangeCase(boolean toUpperCase) {
        this.toUpper = toUpperCase;
        this.setCallback(this);
    }

    public void setVerbose(boolean val) {
        this.verbose = val;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void handleDirectory(File directory) {
        this.handleFile(directory);
    }

    public void handleFile(File file) {
        String parent = file.getParent();
        File newFile = parent != null ? (this.toUpper ? new File(parent, file.getName().toUpperCase()) : new File(parent, file.getName().toLowerCase())) : (this.toUpper ? new File(file.getName().toUpperCase()) : new File(file.getName().toLowerCase()));
        if (file.renameTo(newFile)) {
            if (this.verbose) {
                System.out.println("Renamed " + (file.getParent() == null ? "." : file.getParent()) + File.separator + file.getName() + " to " + (newFile.getParent() == null ? "." : newFile.getParent()) + File.separator + newFile.getName());
            }
        } else {
            System.out.println("Renaming " + (file.getParent() == null ? "." : file.getParent()) + File.separator + file.getName() + " to " + (newFile.getParent() == null ? "." : newFile.getParent()) + File.separator + newFile.getName() + " FAILED");
        }
    }

    public static void main(String[] argv) {
        Debug.init();
        boolean toUpper = true;
        ArgParser ap = new ArgParser("ChangeCase");
        ap.add("upper", "Change file and directory names to UPPER CASE (default). <path> <path> ...", -1);
        ap.add("lower", "Change file and directory names to lower case. <path> <path> ...", -1);
        ap.add("verbose", "Announce all changes, failures will still be reported.");
        if (argv.length == 0) {
            ap.bail("", true);
        }
        ap.parse(argv);
        String[] dirs = ap.getArgValues("lower");
        if (dirs != null) {
            Debug.output("Converting to lower case names...");
            toUpper = false;
        } else {
            dirs = ap.getArgValues("upper");
            if (dirs == null) {
                dirs = argv;
            }
            Debug.output("Converting to UPPER CASE names...");
        }
        boolean verbose = false;
        String[] verboseTest = ap.getArgValues("verbose");
        if (verboseTest != null) {
            verbose = true;
        }
        ChangeCase cc = new ChangeCase(toUpper);
        cc.setVerbose(verbose);
        int i = 0;
        while (i < dirs.length) {
            cc.handleEntry(new File(dirs[i]));
            ++i;
        }
    }
}

