/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.icon;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.icon.IconPart;
import com.bbn.openmap.tools.icon.IconPartCollectionEntry;
import com.bbn.openmap.tools.icon.IconPartList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IconPartCollection
extends IconPartCollectionEntry {
    protected Map entryMap;
    protected List collections;

    protected IconPartCollection() {
    }

    public IconPartCollection(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public void add(IconPartCollectionEntry entry) {
        if (entry != null) {
            String entryName = entry.getName();
            if (entryName != null) {
                this.getEntryMap().put(entryName.intern(), entry);
            }
            if (entry instanceof IconPartCollection) {
                this.getCollections().add(entry);
            }
        }
    }

    public Object remove(IconPartCollectionEntry entry) {
        return this.getEntryMap().remove(entry);
    }

    public void clear() {
        this.getEntryMap().clear();
    }

    public Set keySet() {
        return this.getEntryMap().keySet();
    }

    public IconPart get(String name, DrawingAttributes da) {
        IconPart ip = this.get(name);
        if (ip != null) {
            ip.setRenderingAttributes(da);
        }
        return ip;
    }

    public IconPart get(String name) {
        Object entry = this.getEntryMap().get(name.intern());
        IconPart part = null;
        if (entry != null) {
            part = (IconPart)((IconPartCollectionEntry)entry).getIconPart().clone();
        }
        if (part == null) {
            Iterator it = this.collections.iterator();
            while (it.hasNext()) {
                IconPartCollection ipc = (IconPartCollection)it.next();
                part = ipc.get(name);
                if (part != null) break;
            }
        }
        return part;
    }

    public String getDescription(String name) {
        Object entry = this.getEntryMap().get(name.intern());
        String desc = null;
        if (entry != null) {
            desc = ((IconPartCollectionEntry)entry).getDescription();
        }
        if (desc == null) {
            Iterator it = this.collections.iterator();
            while (it.hasNext()) {
                IconPartCollection ipc = (IconPartCollection)it.next();
                desc = ipc.getDescription(name);
                if (desc != null) break;
            }
        }
        return desc;
    }

    public IconPart compose(List list) {
        IconPartList ipl = new IconPartList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            IconPart part;
            Object obj = it.next();
            if (!(obj instanceof String) || (part = this.get((String)obj)) == null) continue;
            ipl.add(part);
        }
        return ipl;
    }

    public List composeDescription(List list) {
        LinkedList<String> ll = new LinkedList<String>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String des;
            Object obj = it.next();
            if (!(obj instanceof String) || (des = this.getDescription((String)obj)) == null) continue;
            ll.add(des);
        }
        return ll;
    }

    protected void setEntryMap(Map map) {
        this.entryMap = map;
    }

    protected Map getEntryMap() {
        if (this.entryMap == null) {
            this.entryMap = new Hashtable();
        }
        return this.entryMap;
    }

    protected void setCollections(List list) {
        this.collections = list;
    }

    protected List getCollections() {
        if (this.collections == null) {
            this.collections = new LinkedList();
        }
        return this.collections;
    }

    public void setIconPart(IconPart part) {
        this.part = part;
    }

    public IconPart getIconPart() {
        return this.part;
    }
}

