/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.beanbox;

import com.bbn.openmap.tools.beanbox.GenericPropertyEditorInterface;
import com.bbn.openmap.tools.beanbox.GenericPropertySheet;
import com.bbn.openmap.tools.beanbox.PropertyCanvas;
import com.bbn.openmap.tools.beanbox.PropertySelector;
import com.bbn.openmap.tools.beanbox.PropertyText;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PropertySheetPanel
extends JPanel {
    private GenericPropertySheet _frame;
    private Object targetBean;
    private PropertyDescriptor[] properties;
    private PropertyEditor[] editors;
    private Object[] values;
    private Component[] views;
    private JLabel[] labels;
    private boolean processEvents;
    static /* synthetic */ Class class$java$awt$Component;

    PropertySheetPanel(GenericPropertySheet frame) {
        this._frame = frame;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
    }

    synchronized void setTarget(Object targ) {
        this.setVisible(false);
        this.removeAll();
        this.targetBean = targ;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.targetBean.getClass());
            this.properties = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            this.error("GenericPropertySheet: Couldn't introspect", ex);
            return;
        }
        this.editors = new PropertyEditor[this.properties.length];
        this.values = new Object[this.properties.length];
        this.views = new Component[this.properties.length];
        this.labels = new JLabel[this.properties.length];
        int numEditorsToDisplay = 0;
        int i = 0;
        while (i < this.properties.length) {
            block23: {
                String name = this.properties[i].getDisplayName();
                if (this.properties[i].isHidden() || this.properties[i].isExpert()) {
                    System.out.println("Ignoring hidden or expert property " + name);
                } else {
                    Class<?> type = this.properties[i].getPropertyType();
                    Method getter = this.properties[i].getReadMethod();
                    Method setter = this.properties[i].getWriteMethod();
                    if (getter == null || setter == null) {
                        System.out.println("Ignoring read-only/write-only property " + name);
                    } else {
                        Component view;
                        block24: {
                            view = null;
                            try {
                                Object value;
                                Object[] args = new Object[]{};
                                this.values[i] = value = getter.invoke(this.targetBean, args);
                                PropertyEditor editor = null;
                                Class<?> pec = this.properties[i].getPropertyEditorClass();
                                if (pec != null) {
                                    try {
                                        editor = (PropertyEditor)pec.newInstance();
                                    }
                                    catch (Exception ex) {
                                        System.out.println("Cannot instanciate editor class: " + pec);
                                        System.out.println("Will try to find editor using PropertyEditorManager");
                                    }
                                }
                                if (editor == null) {
                                    editor = PropertyEditorManager.findEditor(type);
                                }
                                this.editors[i] = editor;
                                if (editor == null) {
                                    String getterClass = this.properties[i].getReadMethod().getDeclaringClass().getName();
                                    if (getterClass.indexOf("java.") != 0) {
                                        System.err.println("Warning: Can't find public property editor for property \"" + name + "\".  Skipping.");
                                    }
                                    break block23;
                                }
                                editor.setValue(value);
                                editor.addPropertyChangeListener(this._frame);
                                if (editor.isPaintable() && editor.supportsCustomEditor()) {
                                    view = new PropertyCanvas(this._frame, editor);
                                } else if (editor.getTags() != null) {
                                    view = new PropertySelector(editor);
                                } else {
                                    if (editor.getAsText() == null) {
                                        System.err.println("Warning: Property \"" + name + "\" has non-displayabale editor. Skipping.");
                                        break block23;
                                    }
                                    String init = editor.getAsText();
                                    view = new PropertyText(editor);
                                }
                                if (!(editor instanceof GenericPropertyEditorInterface)) break block24;
                                ((GenericPropertyEditorInterface)((Object)editor)).setTargetBean(this.targetBean);
                            }
                            catch (InvocationTargetException ex) {
                                System.err.println("Skipping property " + name + " ; exception on target: " + ex.getTargetException());
                                ex.getTargetException().printStackTrace();
                                break block23;
                            }
                            catch (Exception ex) {
                                System.err.println("Skipping property " + name + "; exception: " + ex);
                                ex.printStackTrace();
                                break block23;
                            }
                        }
                        this.labels[i] = new JLabel(name, 2);
                        this.views[i] = view;
                        ++numEditorsToDisplay;
                    }
                }
            }
            ++i;
        }
        this.setLayout(new GridLayout(numEditorsToDisplay, 2));
        int i2 = 0;
        while (i2 < this.properties.length) {
            if (this.views[i2] != null) {
                this.add(this.labels[i2]);
                this.add(this.views[i2]);
            }
            ++i2;
        }
        this._frame.setNumEditorsToDisplay(numEditorsToDisplay);
        this._frame.setFrameSize();
        this.processEvents = true;
        this.setVisible(true);
    }

    synchronized void setCustomizer(Customizer c) {
        if (c != null) {
            c.addPropertyChangeListener(this._frame);
        }
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        if (!this.processEvents) {
            return;
        }
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            int i = 0;
            while (i < this.editors.length) {
                if (this.editors[i] == editor) {
                    PropertyDescriptor property = this.properties[i];
                    Object value = editor.getValue();
                    if (value != null && value instanceof String && ((String)value).trim().equalsIgnoreCase("null")) {
                        value = null;
                    }
                    this.values[i] = value;
                    Method setter = property.getWriteMethod();
                    try {
                        Object[] args = new Object[]{value};
                        args[0] = value;
                        setter.invoke(this.targetBean, args);
                    }
                    catch (InvocationTargetException ex) {
                        if (ex.getTargetException() instanceof PropertyVetoException) {
                            System.err.println("WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage());
                        } else {
                            this.error("InvocationTargetException while updating " + property.getName(), ex.getTargetException());
                        }
                    }
                    catch (Exception ex) {
                        this.error("Unexpected exception while updating " + property.getName(), ex);
                    }
                    if (this.views[i] == null || !(this.views[i] instanceof PropertyCanvas)) break;
                    this.views[i].repaint();
                    break;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.properties.length) {
            block23: {
                Object o;
                block25: {
                    block24: {
                        try {
                            Method getter = this.properties[i].getReadMethod();
                            Object[] args = new Object[]{};
                            o = getter.invoke(this.targetBean, args);
                        }
                        catch (Exception ex) {
                            o = null;
                        }
                        if (!(o instanceof Object[]) || !(this.values[i] instanceof Object[])) break block24;
                        Object[] newVal = (Object[])o;
                        Object[] oldVal = (Object[])this.values[i];
                        if (newVal.length != oldVal.length) break block25;
                        int j = 0;
                        while (j < newVal.length) {
                            if (newVal[j].equals(oldVal[j])) {
                                ++j;
                                continue;
                            }
                            break block23;
                        }
                        break block23;
                    }
                    if (o == this.values[i] || o != null && o.equals(this.values[i])) break block23;
                }
                this.values[i] = o;
                if (this.editors[i] != null) {
                    this.editors[i].setValue(o);
                    if (this.views[i] != null) {
                        this.views[i].repaint();
                    }
                }
            }
            ++i;
        }
        if (Beans.isInstanceOf(this.targetBean, class$java$awt$Component == null ? (class$java$awt$Component = PropertySheetPanel.class$("java.awt.Component")) : class$java$awt$Component)) {
            ((Component)Beans.getInstanceOf(this.targetBean, class$java$awt$Component == null ? (class$java$awt$Component = PropertySheetPanel.class$("java.awt.Component")) : class$java$awt$Component)).repaint();
        }
    }

    private void warning(String s) {
        System.out.println("Warning: " + s);
    }

    private void error(String message, Throwable th) {
        String mess = message + ":\n" + th;
        System.err.println(message);
        th.printStackTrace();
        System.out.println(mess);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

