/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class CADRG
extends Cylindrical
implements EqualArc {
    public static final transient String CADRGName = "CADRG";
    public static final transient int CADRGType = 42;
    public static final transient float epsilon = 1.0E-4f;
    private static final float NORTH_LIMIT = ProjMath.degToRad(80.0f);
    private static final float SOUTH_LIMIT = -NORTH_LIMIT;
    private double spps_x;
    private double spps_y;
    private static final int[] CADRG_ARC_A = new int[]{369664, 302592, 245760, 199168, 163328, 137216, 110080, 82432};
    private static final double CADRG_SCALE_LIMIT = 2000.0;
    private static final int[] CADRG_get_zone_old_extents = new int[]{32, 48, 56, 64, 68, 72, 76, 80, 90};
    private int oy;
    private double x_pix_constant;
    private double y_pix_constant;
    private Point ul;
    private float[] lower_zone_extents;
    private float[] upper_zone_extents;
    private int zone;

    public CADRG(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 42);
        this.minscale = 500.0f;
    }

    public float normalize_latitude(float lat) {
        if (lat > NORTH_LIMIT) {
            lat = NORTH_LIMIT;
        } else if (lat < SOUTH_LIMIT) {
            lat = SOUTH_LIMIT;
        }
        return lat;
    }

    public String toString() {
        return "CADRG[ spps_x=" + this.spps_x + " spps_y=" + this.spps_y + " x_pix=" + this.x_pix_constant + " y_pix=" + this.y_pix_constant + " oy=" + this.oy + " ul(" + this.ul.x + "," + this.ul.y + ")" + super.toString();
    }

    public int getZone() {
        return this.zone;
    }

    public static int getProjZone(char asciiZone) {
        int z = asciiZone;
        if (z == 74) {
            --z;
        }
        z = z > 64 ? (z -= 64) : (z -= 48);
        return z;
    }

    public float getPlanetPixelCircumference() {
        return 1000000.0f * (float)CADRG_ARC_A[this.zone - 1] / 1.5f;
    }

    private int getZone(double lat, double y_pix_constant) {
        int NOT_SET;
        int ret = NOT_SET = -1;
        double ppd = y_pix_constant / 90.0;
        if (this.upper_zone_extents == null) {
            this.upper_zone_extents = new float[CADRG_get_zone_old_extents.length];
        }
        if (this.lower_zone_extents == null) {
            this.lower_zone_extents = new float[CADRG_get_zone_old_extents.length + 1];
        }
        double delta = y_pix_constant == 0.0 ? 0.0 : (double)this.height / 2.0 * 90.0 / y_pix_constant;
        Debug.message("proj", "height = " + this.height);
        double upper_lat = Math.abs(Math.abs(lat) + delta);
        double lower_lat = Math.abs(Math.abs(lat) - delta);
        Debug.message("proj", "upper_lat = " + upper_lat);
        Debug.message("proj", "lower_lat = " + lower_lat);
        this.lower_zone_extents[0] = 0.0f;
        this.lower_zone_extents[8] = 80.0f;
        this.upper_zone_extents[8] = 90.0f;
        int x = 0;
        while (x < CADRG_get_zone_old_extents.length - 1) {
            double pivot = ppd * (double)CADRG_get_zone_old_extents[x] / 1536.0;
            pivot = Math.floor(pivot);
            Debug.message("proj", "pivot = " + pivot);
            this.lower_zone_extents[x + 1] = (float)(pivot * 1536.0 / ppd);
            this.upper_zone_extents[x] = (float)((pivot += 1.0) * 1536.0 / ppd);
            Debug.message("proj", "lower_zone_extents[" + x + "] = " + this.lower_zone_extents[x]);
            Debug.message("proj", "upper_zone_extents[" + x + "] = " + this.upper_zone_extents[x]);
            if (lower_lat <= (double)this.upper_zone_extents[x] && upper_lat <= (double)this.upper_zone_extents[x] && ret == NOT_SET) {
                ret = x + 1;
            }
            ++x;
        }
        if (ret == NOT_SET) {
            ret = CADRG_get_zone_old_extents.length - 1;
        }
        return ret;
    }

    public double getXPixConstant() {
        return this.x_pix_constant;
    }

    public double getYPixConstant() {
        return this.y_pix_constant;
    }

    public float getUpperZoneExtent(int zone) {
        if (zone < 1) {
            zone = 1;
        }
        if (zone > 8) {
            zone = 9;
        }
        return this.upper_zone_extents[zone - 1];
    }

    public float getLowerZoneExtent(int zone) {
        if (zone < 1) {
            zone = 1;
        }
        if (zone > 8) {
            zone = 9;
        }
        return this.lower_zone_extents[zone - 1];
    }

    public int numHorizontalFrames() {
        return (int)Math.ceil(this.x_pix_constant / 1536.0);
    }

    public int numVerticalFrames() {
        return (int)Math.round((double)(this.upper_zone_extents[this.zone - 1] - this.lower_zone_extents[this.zone - 1]) * (this.y_pix_constant / 90.0) / 1536.0);
    }

    private double CADRG_x_pix_constant(double adrgscale, int zone) {
        double tempx = 0.0;
        double x_pix = adrgscale * (double)CADRG_ARC_A[zone - 1] / 512.0;
        x_pix = Math.ceil(x_pix);
        x_pix *= 1.33333;
        x_pix = Math.round(x_pix);
        return x_pix * 256.0;
    }

    private float CADRG_calc_maxscale() {
        return 1000000.0f * (float)CADRG_ARC_A[0] / ((float)this.width * 1.5f);
    }

    private double CADRG_y_pix_constant(double adrgscale) {
        double tempy = 0.0;
        int CADRG_ARC_B = 400384;
        double y_pix = adrgscale * 400384.0 / 512.0;
        y_pix = Math.ceil(y_pix);
        y_pix *= 0.33333;
        y_pix = Math.round(y_pix);
        return y_pix * 256.0;
    }

    public boolean isPlotable(float lat, float lon) {
        return (lat = this.normalize_latitude(ProjMath.degToRad(lat))) - 1.0E-4f < NORTH_LIMIT && lat + 1.0E-4f > SOUTH_LIMIT;
    }

    public Point forward(LatLonPoint pt, Point ret_val) {
        float lon_ = Proj.wrap_longitude(pt.radlon_ - this.ctrLon);
        float lat_ = this.normalize_latitude(pt.radlat_);
        ret_val.x = (int)ProjMath.roundAdjust(this.spps_x * (double)lon_) - this.ul.x;
        ret_val.y = (int)ProjMath.roundAdjust(-this.spps_y * (double)lat_) + this.ul.y + this.oy;
        return ret_val;
    }

    public Point forward(float lat, float lon, Point ret_val, boolean b) {
        float lon_ = Proj.wrap_longitude(lon - this.ctrLon);
        float lat_ = this.normalize_latitude(lat);
        ret_val.x = (int)ProjMath.roundAdjust(this.spps_x * (double)lon_) - this.ul.x;
        ret_val.y = (int)ProjMath.roundAdjust(-this.spps_y * (double)lat_) + this.ul.y + this.oy;
        return ret_val;
    }

    public Point forward(float lat, float lon, Point ret_val) {
        float lon_ = Proj.wrap_longitude(ProjMath.degToRad(lon) - this.ctrLon);
        float lat_ = this.normalize_latitude(ProjMath.degToRad(lat));
        ret_val.x = (int)ProjMath.roundAdjust(this.spps_x * (double)lon_) - this.ul.x;
        ret_val.y = (int)ProjMath.roundAdjust(-this.spps_y * (double)lat_) + this.ul.y + this.oy;
        return ret_val;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint ret_val) {
        Point pixpoint = new Point(0, 0);
        pixpoint.x = pt.x + this.ul.x;
        pixpoint.y = -pt.y + this.ul.y + this.oy;
        if (pixpoint.x > (int)ProjMath.roundAdjust((double)this.world.x / 2.0)) {
            pixpoint.x = (int)ProjMath.roundAdjust((double)this.world.x / 2.0);
        } else if (pixpoint.x < (int)ProjMath.roundAdjust((double)(-this.world.x) / 2.0)) {
            pixpoint.x = (int)ProjMath.roundAdjust((double)(-this.world.x) / 2.0);
        }
        if (pixpoint.y > (int)ProjMath.roundAdjust((double)this.world.y / 2.0)) {
            pixpoint.y = (int)ProjMath.roundAdjust((double)this.world.y / 2.0);
        } else if (pixpoint.y < (int)ProjMath.roundAdjust((double)(-this.world.y) / 2.0)) {
            pixpoint.y = (int)ProjMath.roundAdjust((double)(-this.world.y) / 2.0);
        }
        float lat_ = this.normalize_latitude((float)((double)pixpoint.y / this.spps_y));
        ret_val.setLatitude(ProjMath.radToDeg(lat_));
        ret_val.setLongitude(ProjMath.radToDeg((float)((double)pixpoint.x / this.spps_x) + this.ctrLon));
        return ret_val;
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint ret_val) {
        Point pixpoint = new Point(0, 0);
        pixpoint.x = x + this.ul.x;
        pixpoint.y = -y + this.ul.y + this.oy;
        if (pixpoint.x > (int)ProjMath.roundAdjust((double)this.world.x / 2.0)) {
            pixpoint.x = (int)ProjMath.roundAdjust((double)this.world.x / 2.0);
        } else if (pixpoint.x < (int)ProjMath.roundAdjust((double)(-this.world.x) / 2.0)) {
            pixpoint.x = (int)ProjMath.roundAdjust((double)(-this.world.x) / 2.0);
        }
        if (pixpoint.y > (int)ProjMath.roundAdjust((double)this.world.y / 2.0)) {
            pixpoint.y = (int)ProjMath.roundAdjust((double)this.world.y / 2.0);
        } else if (pixpoint.y < (int)ProjMath.roundAdjust((double)(-this.world.y) / 2.0)) {
            pixpoint.y = (int)ProjMath.roundAdjust((double)(-this.world.y) / 2.0);
        }
        float lat_ = this.normalize_latitude((float)((double)pixpoint.y / this.spps_y));
        ret_val.setLatitude(ProjMath.radToDeg(lat_));
        ret_val.setLongitude(ProjMath.radToDeg((float)((double)pixpoint.x / this.spps_x) + this.ctrLon));
        return ret_val;
    }

    protected void computeParameters() {
        int h;
        int w;
        double adrgscale;
        if (this.ul == null) {
            this.ul = new Point(0, 0);
        }
        this.maxscale = this.CADRG_calc_maxscale();
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        if ((adrgscale = 1000000.0 / (double)this.scale) > 2000.0) {
            Debug.message("proj", "CADRG: adrgscale > CADRG_SCALE_LIMIT");
            adrgscale = 2000.0;
        }
        this.y_pix_constant = this.CADRG_y_pix_constant(adrgscale);
        if (Debug.debugging("proj")) {
            Debug.output("Y pix constant = " + this.y_pix_constant);
        }
        this.zone = this.getZone(ProjMath.radToDeg(this.ctrLat), this.y_pix_constant);
        if (Debug.debugging("proj")) {
            Debug.output("Zone = " + this.zone);
        }
        this.x_pix_constant = this.CADRG_x_pix_constant(adrgscale, this.zone);
        if (Debug.debugging("proj")) {
            Debug.output("x_pix_constant = " + this.x_pix_constant);
        }
        if (this.world == null) {
            this.world = new Point(0, 0);
        }
        this.world.x = (int)ProjMath.roundAdjust(this.x_pix_constant);
        this.world.y = (int)ProjMath.roundAdjust(this.y_pix_constant * 4.0 / 2.0);
        Debug.message("proj", "world = " + this.world.x + "," + this.world.y);
        this.spps_x = this.x_pix_constant / 6.2831854820251465;
        this.spps_y = this.y_pix_constant / 1.5707963705062866;
        Debug.message("proj", "spps = " + this.spps_x + "," + this.spps_y);
        if (this.width > this.world.x) {
            Debug.message("proj", "CADRG: fixing small world");
            w = this.world.x;
        } else {
            w = this.width;
        }
        if (this.height > this.world.y) {
            h = this.world.y;
            this.oy = (int)ProjMath.roundAdjust((double)(this.height - h) / 2.0);
        } else {
            h = this.height;
            this.oy = 0;
        }
        long temp = (long)ProjMath.roundAdjust(this.spps_y * (double)this.ctrLat);
        if (Debug.debugging("proj")) {
            Debug.output("CADRG.temp = " + temp);
        }
        if (this.ul == null) {
            this.ul = new Point(0, 0);
        }
        this.ul.x = (int)ProjMath.roundAdjust((double)(-w) / 2.0);
        this.ul.y = temp != 0L && this.oy != 0 ? (int)ProjMath.roundAdjust((double)h / 2.0) : (int)temp + (int)ProjMath.roundAdjust((double)h / 2.0);
        if (Debug.debugging("proj")) {
            Debug.output("CADRG: ul = " + this.ul.x + "," + this.ul.y);
            Debug.output(" oy = " + this.oy);
        }
        this.half_world = this.world.x / 2;
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        Debug.message("proj", "CADRG.computeParameters(): maxscale: " + this.maxscale);
    }

    public String getName() {
        return CADRGName;
    }

    public float getScale(LatLonPoint ll1, LatLonPoint ll2, Point point1, Point point2) {
        return this.getScale(ll1, ll2, point1, point2, 0);
    }

    private float getScale(LatLonPoint ll1, LatLonPoint ll2, Point point1, Point point2, int recursiveCount) {
        try {
            float pixPerDegree;
            int deltaPix;
            float deltaDegrees;
            float dx = Math.abs(point2.x - point1.x);
            float dy = Math.abs(point2.y - point1.y);
            float nCenterLat = Math.min(ll1.getLatitude(), ll2.getLatitude()) + Math.abs(ll1.getLatitude() - ll2.getLatitude()) / 2.0f;
            float nCenterLon = Math.min(ll1.getLongitude(), ll2.getLongitude()) + Math.abs(ll1.getLongitude() - ll2.getLongitude()) / 2.0f;
            if (dx < dy) {
                float dlat;
                deltaDegrees = dlat = Math.abs(ll1.getLatitude() - ll2.getLatitude());
                deltaPix = this.getHeight();
                pixPerDegree = this.getScale() * (float)this.getYPixConstant() / 90.0f;
            } else {
                float lon2;
                float lon1;
                if (point1.x > point2.x) {
                    float lat1 = ll1.getLatitude();
                    lon1 = ll1.getLongitude();
                    ll1.setLatLon(ll2);
                    ll2.setLatLon(lat1, lon1);
                }
                float dlon = (lon1 = ll1.getLongitude()) > (lon2 = ll2.getLongitude()) ? 180.0f - lon1 + (180.0f + lon2) : lon2 - lon1;
                deltaDegrees = dlon;
                deltaPix = this.getWidth();
                pixPerDegree = this.getPlanetPixelCircumference() / 360.0f;
            }
            float ret = pixPerDegree / ((float)deltaPix / deltaDegrees);
            CADRG newcadrg = new CADRG(new LatLonPoint(nCenterLat, nCenterLon), ret, this.getWidth(), this.getHeight());
            if (newcadrg.getZone() != this.zone && recursiveCount < 2) {
                ret = newcadrg.getScale(ll1, ll2, newcadrg.forward(ll1), newcadrg.forward(ll2), recursiveCount + 1);
            }
            return ret;
        }
        catch (NullPointerException npe) {
            Debug.error("ProjMath.getScale(): caught null pointer exception.");
            return Float.MAX_VALUE;
        }
    }
}

