/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.awt;

import com.bbn.openmap.omGraphics.awt.AbstractShapeDecoration;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;

public class CircleShapeDecoration
extends AbstractShapeDecoration {
    private boolean filled = true;

    public CircleShapeDecoration(int length, int radius) {
        super(length, radius, 1);
    }

    public CircleShapeDecoration(int length, int radius, Paint paint) {
        super(length, radius, 1);
        this.setPaint(paint);
    }

    public void draw(Graphics g, Point2D[] points, boolean complete) {
        Graphics2D g2D = (Graphics2D)g;
        this.setGraphics(g);
        int nbpts = points.length;
        double xcoord1 = points[0].getX();
        double ycoord1 = points[0].getY();
        double xcoord2 = points[nbpts - 1].getX();
        double ycoord2 = points[nbpts - 1].getY();
        if (complete) {
            double dx = xcoord2 - xcoord1;
            double dy = ycoord2 - ycoord1;
            double norm = Math.sqrt(dx * dx + dy * dy);
            double rcos = dx / norm;
            double rsin = dy / norm;
            double r = (double)this.getLength() / 2.0;
            double w = this.getWidth();
            int x = (int)(xcoord1 + r * rcos);
            int y = (int)(ycoord1 + r * rsin);
            if (this.filled) {
                g.fillOval((int)((double)x - w / 2.0), (int)((double)y - w / 2.0), (int)w, (int)w);
            } else {
                g.drawOval((int)((double)x - w / 2.0), (int)((double)y - w / 2.0), (int)w, (int)w);
            }
        }
        this.restoreGraphics(g);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }
}

