/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public class OMPoint
extends OMGraphic
implements Serializable {
    public static final int DEFAULT_RADIUS = 2;
    public static final boolean DEFAULT_ISOVAL = false;
    protected int radius = 2;
    protected int x = 0;
    protected int y = 0;
    protected float lat1 = 0.0f;
    protected float lon1 = 0.0f;
    protected boolean oval = false;

    public OMPoint() {
    }

    public OMPoint(float lat, float lon) {
        this(lat, lon, 2);
    }

    public OMPoint(float lat, float lon, int radius) {
        this.setRenderType(1);
        this.set(lat, lon);
        this.radius = radius;
    }

    public OMPoint(float lat, float lon, int offsetx, int offsety) {
        this(lat, lon, offsetx, offsety, 2);
    }

    public OMPoint(float lat, float lon, int offsetx, int offsety, int radius) {
        this.setRenderType(3);
        this.set(lat, lon, offsetx, offsety);
        this.radius = radius;
    }

    public OMPoint(int x, int y) {
        this(x, y, 2);
    }

    public OMPoint(int x, int y, int radius) {
        this.setRenderType(2);
        this.set(x, y);
        this.radius = radius;
    }

    public void set(float lat, float lon) {
        this.setLat(lat);
        this.setLon(lon);
    }

    public void set(float lat, float lon, int offsetx, int offsety) {
        this.setLat(lat);
        this.setLon(lon);
        this.set(offsetx, offsety);
    }

    public void set(int x, int y) {
        this.x = x;
        this.y = y;
        this.setNeedToRegenerate(true);
    }

    public void setLat(float lat) {
        this.lat1 = lat;
        this.setNeedToRegenerate(true);
    }

    public float getLat() {
        return this.lat1;
    }

    public void setLon(float lon) {
        this.lon1 = lon;
        this.setNeedToRegenerate(true);
    }

    public float getLon() {
        return this.lon1;
    }

    public void setX(int x) {
        this.x = x;
        this.setNeedToRegenerate(true);
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
        this.setNeedToRegenerate(true);
    }

    public int getY() {
        return this.y;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.setNeedToRegenerate(true);
    }

    public int getRadius() {
        return this.radius;
    }

    public void setOval(boolean set) {
        if (this.oval != set) {
            this.setNeedToRegenerate(true);
            this.oval = set;
        }
    }

    public boolean isOval() {
        return this.oval;
    }

    public boolean generate(Projection proj) {
        this.setShape(null);
        if (proj == null) {
            Debug.message("omgraphic", "OMPoint: null projection in generate!");
            return false;
        }
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        switch (this.renderType) {
            case 2: {
                x1 = this.x - this.radius;
                y1 = this.y - this.radius;
                x2 = this.x + this.radius;
                y2 = this.y + this.radius;
                break;
            }
            case 1: 
            case 3: {
                if (!proj.isPlotable(this.lat1, this.lon1)) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point p1 = proj.forward(this.lat1, this.lon1);
                x1 = p1.x + this.x - this.radius;
                y1 = p1.y + this.y - this.radius;
                x2 = p1.x + this.x + this.radius;
                y2 = p1.y + this.y + this.radius;
                break;
            }
            case 0: {
                System.err.println("OMPoint.generate(): invalid RenderType");
                return false;
            }
        }
        this.shape = this.oval ? new GeneralPath(new Ellipse2D.Float(Math.min(x2, x1), Math.min(y2, y1), Math.abs(x2 - x1), Math.abs(y2 - y1))) : BasicGeometry.createBoxShape(Math.min(x2, x1), Math.min(y2, y1), Math.abs(x2 - x1), Math.abs(y2 - y1));
        this.initLabelingDuringGenerate();
        this.setLabelLocation(new Point(x2, y1));
        this.setNeedToRegenerate(false);
        return true;
    }

    protected boolean hasLineTypeChoice() {
        return false;
    }
}

