/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.layer.vpf.VPFLayer;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.tools.roads.LayerView;
import com.bbn.openmap.tools.roads.RoadFinder;
import com.bbn.openmap.tools.roads.RoadServices;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class VPFRoadLayer
extends VPFLayer
implements ProjectionListener,
RoadServices,
LayerView {
    Logger logger = Logger.getLogger(this.getClass().getName());
    RoadFinder helper;
    List toDraw = new ArrayList();
    boolean drawIntersections = false;
    boolean drawResults = false;
    public static final String DrawIntersectionsProperty = "drawIntersections";
    public static final String DrawResultsProperty = "drawResults";

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setDrawIntersections(PropUtils.booleanFromProperties(props, realPrefix + DrawIntersectionsProperty, this.drawIntersections));
        this.setDrawResults(PropUtils.booleanFromProperties(props, realPrefix + DrawResultsProperty, this.drawResults));
        this.setHelper();
    }

    protected void setDrawIntersections(boolean val) {
        this.drawIntersections = val;
    }

    protected void setDrawResults(boolean val) {
        this.drawResults = val;
    }

    protected void setHelper() {
        this.logger.info("draw inter " + this.drawIntersections);
        this.helper = new RoadFinder(this, this.drawIntersections, this.drawResults);
    }

    public List getPathOnRoad(Point start, Point end, List segments) {
        return this.helper.getPathOnRoad(start, end, segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectionChanged(ProjectionEvent e) {
        super.projectionChanged(e);
        this.logger.info("calling helper - projection changed.");
        VPFRoadLayer vPFRoadLayer = this;
        synchronized (vPFRoadLayer) {
            if (this.helper == null) {
                this.setHelper();
            }
            this.helper.projectionChanged(e);
        }
    }

    public void setExtraGraphics(List toDraw) {
        this.logger.info("setting to draw " + toDraw.size() + " new graphics.");
        this.toDraw = toDraw;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.drawIntersections || this.drawResults) {
            OMGraphicList graphics = new OMGraphicList(this.toDraw);
            graphics.generate(this.getProjection(), true);
            this.logger.info("rendering toDraw " + this.toDraw.size() + " items");
            graphics.render(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMGraphicList prepare() {
        VPFRoadLayer vPFRoadLayer = this;
        synchronized (vPFRoadLayer) {
            return super.prepare();
        }
    }

    public List getGraphicList() {
        OMGraphicList omgl = this.getList();
        if (omgl != null) {
            return omgl.getTargets();
        }
        return new ArrayList();
    }
}

