/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VPFFeatureGraphicWarehouse
extends VPFLayerGraphicWarehouse
implements VPFFeatureWarehouse {
    public static final String DEFAULT = "DEFAULT";
    protected Hashtable featureDrawingAttributes;
    protected String info = null;

    protected void initDrawingAttributes() {
        this.drawingAttributes = new FeatureDrawingAttributes();
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.createFeatureDrawingAttributes(prefix, props, this.getFeatures());
    }

    public void createFeatureDrawingAttributes(String prefix, Properties props, List features) {
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.featureDrawingAttributes = new Hashtable();
        if (this.drawingAttributes != null) {
            this.featureDrawingAttributes.put(DEFAULT, this.drawingAttributes);
        } else {
            this.drawingAttributes = new FeatureDrawingAttributes();
        }
        Iterator fiter = features.iterator();
        while (fiter.hasNext()) {
            String feature = ((String)fiter.next()).intern();
            FeatureDrawingAttributes da = (FeatureDrawingAttributes)this.drawingAttributes.clone();
            da.setStroke(this.drawingAttributes.cloneBasicStroke());
            da.setProperties(realPrefix + feature, props);
            this.featureDrawingAttributes.put(feature, da);
        }
    }

    public void setFeatureDrawingAttributes(Hashtable attributes) {
        this.featureDrawingAttributes = attributes;
    }

    public Hashtable getFeatureDrawingAttributes() {
        return this.featureDrawingAttributes;
    }

    public Component getGUI(LibrarySelectionTable lst) {
        JTabbedPane jtp = new JTabbedPane();
        jtp.addTab(DEFAULT, null, this.drawingAttributes.getGUI(), "General Attributes");
        List features = this.getFeatures();
        int numFeatures = features.size();
        int i = 0;
        while (i < numFeatures) {
            String currentFeature = (String)features.get(i);
            FeatureDrawingAttributes da = this.getAttributesForFeature(currentFeature);
            if (da != null) {
                String desc = null;
                try {
                    desc = lst.getDescription(currentFeature);
                }
                catch (FormatException fe) {
                    // empty catch block
                }
                if (desc == null) {
                    desc = "Feature Description Unavailable";
                }
                JPanel featurePanel = new JPanel();
                featurePanel.add(((DrawingAttributes)da).getGUI());
                jtp.addTab(currentFeature, null, featurePanel, desc);
            }
            ++i;
        }
        return jtp;
    }

    public FeatureDrawingAttributes getAttributesForFeature(String featureType) {
        if (featureType != null) {
            FeatureDrawingAttributes ret;
            if (this.featureDrawingAttributes != null) {
                ret = (FeatureDrawingAttributes)this.featureDrawingAttributes.get(featureType);
                if (ret == null) {
                    ret = (FeatureDrawingAttributes)this.drawingAttributes;
                }
            } else {
                ret = (FeatureDrawingAttributes)this.drawingAttributes;
            }
            return ret;
        }
        return (FeatureDrawingAttributes)this.drawingAttributes;
    }

    public void createArea(CoverageTable covtable, AreaTable areatable, List facevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, String featureType) {
        ArrayList ipts = new ArrayList();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = LayerGraphicWarehouseSupport.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        int id = (Integer)facevec.get(0);
        this.setAttributesForFeature(py, covtable, featureType, id);
        py.setLinePaint(OMColor.clear);
        py.setSelectPaint(OMColor.clear);
        this.addArea(py);
    }

    public void createEdge(CoverageTable c, EdgeTable edgetable, List edgevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, CoordFloatString coords, String featureType) {
        int id = (Integer)edgevec.get(0);
        OMPoly py = LayerGraphicWarehouseSupport.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.setAttributesForFeature(py, c, featureType, id);
        py.setFillPaint(OMColor.clear);
        py.setIsPolygon(false);
        this.addEdge(py);
    }

    protected void setAttributesForFeature(OMGraphic omg, CoverageTable c, String featureType, int id) {
        FeatureDrawingAttributes fda = this.getAttributesForFeature(featureType);
        if (fda.getFci() == null) {
            fda.setFci(c.getFeatureClassInfo(featureType));
        }
        fda.setTo(omg, id);
    }

    public void createText(CoverageTable c, TextTable texttable, List textvec, float latitude, float longitude, String text, String featureType) {
        OMText txt = LayerGraphicWarehouseSupport.createOMText(text, latitude, longitude);
        int id = (Integer)textvec.get(0);
        this.setAttributesForFeature(txt, c, featureType, id);
        this.addText(txt);
    }

    public void createNode(CoverageTable c, NodeTable t, List nodeprim, float latitude, float longitude, boolean isEntityNode, String featureType) {
        OMPoint pt = LayerGraphicWarehouseSupport.createOMPoint(latitude, longitude);
        int id = (Integer)nodeprim.get(0);
        this.setAttributesForFeature(pt, c, featureType, id);
        this.addPoint(pt);
    }

    public boolean needToFetchTileContents(String currentFeature, TileDirectory currentTile) {
        return true;
    }

    public static void main(String[] argv) {
        new VPFFeatureGraphicWarehouse();
    }
}

