/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.util.BitSet;

public class DcwSpatialIndex {
    private BinaryFile inputFile = null;
    private final int numberOfPrimitives;
    private final float boundingRectx1;
    private final float boundingRecty1;
    private final float boundingRectx2;
    private final float boundingRecty2;
    private final int nodesInTree;
    int[][] nodeinfo;

    public DcwSpatialIndex(String filename, boolean border) throws FormatException {
        try {
            this.inputFile = new BinaryBufferedFile(filename);
        }
        catch (IOException e) {
            throw new FormatException("Can't open file " + filename + ": " + e.getMessage());
        }
        this.inputFile.byteOrder(border);
        try {
            this.numberOfPrimitives = this.inputFile.readInteger();
            this.boundingRectx1 = this.inputFile.readFloat();
            this.boundingRecty1 = this.inputFile.readFloat();
            this.boundingRectx2 = this.inputFile.readFloat();
            this.boundingRecty2 = this.inputFile.readFloat();
            this.nodesInTree = this.inputFile.readInteger();
            if (Debug.debugging("vpfserver")) {
                System.out.println("NumberOfPrimitives = " + this.numberOfPrimitives);
                System.out.println("Bounding Rect = (" + this.boundingRectx1 + ", " + this.boundingRecty1 + ") - (" + this.boundingRectx2 + ", " + this.boundingRecty2 + ")");
                System.out.println("Nodes in Tree = " + this.nodesInTree);
            }
            this.nodeinfo = new int[this.nodesInTree][2];
            int i = 0;
            while (i < this.nodesInTree) {
                this.inputFile.readIntegerArray(this.nodeinfo[i], 0, 2);
                ++i;
            }
            if (Debug.debugging("vpfserver")) {
                int baseOffset = 24 + this.nodesInTree * 8;
                BitSet b = new BitSet(this.nodesInTree);
                int actprimcnt = 0;
                b.set(0);
                int i2 = 0;
                while (i2 < this.nodesInTree) {
                    if ((long)(baseOffset + this.nodeinfo[i2][0]) != this.inputFile.getFilePointer()) {
                        throw new FormatException("SI Input appears to be out-of-sync");
                    }
                    StringBuffer pr = new StringBuffer("i=" + (i2 + 1));
                    pr.append(" offset=" + this.nodeinfo[i2][0]);
                    pr.append(" count=" + this.nodeinfo[i2][1]);
                    int j = 0;
                    while (j < this.nodeinfo[i2][1]) {
                        ++actprimcnt;
                        PrimitiveRecord prim = new PrimitiveRecord(this.inputFile);
                        pr.append("\n\t").append(prim.toString());
                        ++j;
                    }
                    if (this.nodeinfo[i2][1] != 0) {
                        if (i2 < 15 || i2 + 1 == this.nodesInTree) {
                            System.out.println(pr);
                        }
                        b.set(i2 + 1);
                        if (!b.get((i2 + 1) / 2)) {
                            throw new FormatException("condition failed");
                        }
                    }
                    ++i2;
                }
                if (actprimcnt == this.numberOfPrimitives) {
                    System.out.println("Got the right number of primitives");
                } else {
                    System.out.println("!!Got the wrong number of primitives");
                }
                if (this.inputFile.available() != 0L) {
                    throw new FormatException("Bytes left at end of file " + this.inputFile.available());
                }
            }
        }
        catch (EOFException e) {
            throw new FormatException("Hit Premature EOF in thematic index");
        }
        catch (IOException i) {
            throw new FormatException("Encountered IO Exception: " + i.getMessage());
        }
    }

    public int getNumberOfPrimitives() {
        return this.numberOfPrimitives;
    }

    public float getBoundingX1() {
        return this.boundingRectx1;
    }

    public float getBoundingX2() {
        return this.boundingRectx2;
    }

    public float getBoundingY1() {
        return this.boundingRecty1;
    }

    public float getBoundingY2() {
        return this.boundingRecty2;
    }

    public int getNodesInTree() {
        return this.nodesInTree;
    }

    public int getPrimitiveCount(int node) {
        return this.nodeinfo[node][1];
    }

    public int getPrimitiveOffset(int node) {
        return this.nodeinfo[node][0];
    }

    public PrimitiveRecord[] getPrimitiveRecords(int node) throws FormatException {
        int count = this.getPrimitiveCount(node);
        int offset = this.getPrimitiveOffset(node);
        PrimitiveRecord[] ret = new PrimitiveRecord[count];
        try {
            this.inputFile.seek(offset + 24 + this.nodesInTree * 8);
            int i = 0;
            while (i < count) {
                ret[i] = new PrimitiveRecord(this.inputFile);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new FormatException("Error reading spatial index file");
        }
        return ret;
    }

    public void close() {
        try {
            this.inputFile.close();
        }
        catch (IOException i) {
            System.out.println("Caught ioexception " + i.getClass() + " " + i.getMessage());
        }
    }

    public static class PrimitiveRecord {
        public final short x1;
        public final short y1;
        public final short x2;
        public final short y2;
        public final int primId;

        public PrimitiveRecord(BinaryFile inputFile) throws FormatException, EOFException {
            this.x1 = (short)(inputFile.readChar() & 0xFF);
            this.y1 = (short)(inputFile.readChar() & 0xFF);
            this.x2 = (short)(inputFile.readChar() & 0xFF);
            this.y2 = (short)(inputFile.readChar() & 0xFF);
            this.primId = inputFile.readInteger();
        }

        public String toString() {
            return "(" + this.primId + ": \t" + this.x1 + " \t" + this.x2 + " \t" + this.y1 + " \t" + this.y2 + ")";
        }
    }
}

