/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.DcwColumnInfo;
import com.bbn.openmap.layer.vpf.DcwVariableLengthIndexFile;
import com.bbn.openmap.layer.vpf.TilingAdapter;
import com.bbn.openmap.layer.vpf.VPFUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DcwRecordFile {
    protected BinaryFile inputFile = null;
    protected String tableDescription = null;
    protected String documentationFileName = null;
    private int headerLength = 4;
    protected boolean MSBFirst = false;
    protected DcwColumnInfo[] columnInfo = null;
    protected int recordLength = 0;
    protected DcwVariableLengthIndexFile vli = null;
    protected final String filename;
    protected String tablename = null;
    protected boolean byteorder = true;
    int cursorRow = -1;
    public static final String ID_COLUMN_NAME = "id";

    public DcwRecordFile(String name) throws FormatException {
        this(name, false);
    }

    public DcwRecordFile(String name, boolean deferInit) throws FormatException {
        this.filename = name;
        if (!deferInit) {
            this.finishInitialization();
        }
    }

    private void internTableName() {
        int strlen = this.filename.length();
        int firstchar = this.filename.lastIndexOf(47);
        int lastchar = this.filename.endsWith(".") ? strlen - 1 : strlen;
        this.tablename = this.filename.substring(firstchar + 1, lastchar).toLowerCase().intern();
    }

    public String getTableFile() {
        return this.filename;
    }

    public String getTableName() {
        return this.tablename;
    }

    public synchronized void finishInitialization() throws FormatException {
        this.internTableName();
        try {
            this.inputFile = new BinaryBufferedFile(this.filename);
        }
        catch (IOException e) {
            throw new FormatException(e.toString());
        }
        try {
            byte[] preHeaderLen = this.inputFile.readBytes(4, false);
            char delim = this.inputFile.readChar();
            switch (delim) {
                case 'L': 
                case 'l': {
                    delim = this.inputFile.readChar();
                }
                case ';': {
                    this.byteorder = false;
                    this.inputFile.byteOrder(this.byteorder);
                    break;
                }
                case 'M': 
                case 'm': {
                    this.byteorder = true;
                    this.inputFile.byteOrder(this.byteorder);
                    delim = this.inputFile.readChar();
                    break;
                }
                default: {
                    throw new FormatException("Invalid Byte Encoding Format");
                }
            }
            this.headerLength += MoreMath.BuildInteger(preHeaderLen, this.byteorder);
            if (delim != ';') {
                throw new FormatException("Unexpected character in header");
            }
            this.tableDescription = this.inputFile.readToDelimiter(';');
            this.documentationFileName = this.inputFile.readToDelimiter(';');
            if ("-".equals(this.documentationFileName)) {
                this.documentationFileName = null;
            }
            ArrayList<DcwColumnInfo> tmpcols = new ArrayList<DcwColumnInfo>();
            try {
                while (true) {
                    DcwColumnInfo dci;
                    int collen;
                    this.recordLength = (collen = (dci = new DcwColumnInfo(this.inputFile)).fieldLength()) == -1 || this.recordLength == -1 ? -1 : (this.recordLength += collen);
                    tmpcols.add(dci);
                }
            }
            catch (EOFException e) {
                this.columnInfo = new DcwColumnInfo[tmpcols.size()];
                tmpcols.toArray(this.columnInfo);
                this.cursorRow = 1;
            }
        }
        catch (EOFException e) {
            throw new FormatException("Caught EOFException: " + e.getMessage());
        }
        catch (NullPointerException npe) {
        }
    }

    public TilingAdapter getTilingAdapter(String primColumnName) {
        return this.getTilingAdapter(-1, this.whatColumn(primColumnName));
    }

    public TilingAdapter getTilingAdapter(String tileColumnName, String primColumnName) {
        return this.getTilingAdapter(this.whatColumn(tileColumnName), this.whatColumn(primColumnName));
    }

    public TilingAdapter getTilingAdapter(int tileColumn, int primColumn) {
        DcwColumnInfo tile;
        DcwColumnInfo dcwColumnInfo = tile = tileColumn != -1 ? this.columnInfo[tileColumn] : null;
        if (primColumn == -1) {
            return null;
        }
        DcwColumnInfo prim = this.columnInfo[primColumn];
        TilingAdapter retval = null;
        char primFieldType = prim.getFieldType();
        if (tile == null) {
            if (primFieldType == 'K') {
                retval = new TilingAdapter.CrossTileAdapter(primColumn);
            } else if (primFieldType == 'I' || primFieldType == 'S') {
                retval = new TilingAdapter.UntiledAdapter(primColumn);
            }
        } else if (primFieldType == 'K') {
            retval = new TilingAdapter.CrossTileAdapter(primColumn);
        } else if (primFieldType == 'I' || primFieldType == 'S') {
            retval = new TilingAdapter.TiledAdapter(tileColumn, primColumn);
        }
        return retval;
    }

    public int[] lookupSchema(String[] names, boolean mustExist) throws FormatException {
        int[] retval = new int[names.length];
        int i = 0;
        while (i < retval.length) {
            retval[i] = this.whatColumn(names[i]);
            if (retval[i] == -1 && mustExist) {
                throw new FormatException("Column " + names[i] + " doesn't exist");
            }
            ++i;
        }
        return retval;
    }

    public int[] lookupSchema(String[] names, boolean mustExist, char[] type, int[] length, boolean strictlength) throws FormatException {
        int[] retval = this.lookupSchema(names, mustExist);
        if (type.length == names.length && length.length == names.length) {
            int i = 0;
            while (i < retval.length) {
                if (retval[i] != -1) {
                    this.columnInfo[retval[i]].assertSchema(type[i], length[i], strictlength);
                }
                ++i;
            }
        }
        return retval;
    }

    public void parseAllRowsAndPrintSome() throws FormatException {
        int row_id_column = this.whatColumn(ID_COLUMN_NAME);
        String vectorString = null;
        int rowcount = 0;
        ArrayList l = new ArrayList(this.getColumnCount());
        while (this.parseRow(l)) {
            int cnt = ((Number)l.get(row_id_column)).intValue();
            if (cnt != ++rowcount) {
                System.out.println("Non-consecutive row number.  Expected " + rowcount + " got " + cnt);
            }
            vectorString = VPFUtil.listToString(l);
            if (rowcount >= 20 && rowcount % 100 != 0) continue;
            System.out.println(vectorString);
        }
        if (rowcount > 20) {
            System.out.println(vectorString);
        }
    }

    public void parseSomeRowsAndPrint() throws FormatException {
        int row_id_column = this.whatColumn(ID_COLUMN_NAME);
        int rowcount = this.getRecordCount();
        int i = 1;
        while (i <= rowcount) {
            if (i <= 10 || i % 100 == 0 || i == rowcount) {
                this.seekToRow(i);
                List l = this.parseRow();
                int cnt = (Integer)l.get(row_id_column);
                if (cnt != i) {
                    System.out.println("Possible incorrect seek for row number " + i + " got " + cnt);
                }
                System.out.println(VPFUtil.listToString(l));
            }
            ++i;
        }
    }

    public List parseRow() throws FormatException {
        ArrayList retval = new ArrayList(this.getColumnCount());
        return this.parseRow(retval) ? retval : null;
    }

    public synchronized boolean parseRow(List retval) throws FormatException {
        retval.clear();
        try {
            int i = 0;
            while (i < this.columnInfo.length) {
                Object newobj = this.columnInfo[i].parseField(this.inputFile);
                retval.add(newobj);
                ++i;
            }
            ++this.cursorRow;
            return true;
        }
        catch (FormatException f) {
            throw new FormatException("DcwRecordFile: parserow on table " + this.filename + ": " + f.getMessage());
        }
        catch (EOFException e) {
            if (retval.size() > 0) {
                throw new FormatException("DcwRecordFile: hit EOF when list = " + VPFUtil.listToString(retval));
            }
            try {
                if (this.inputFile.available() > 0L) {
                    throw new FormatException("DcwRecordFile: hit EOF with available = " + this.inputFile.available() + " when list = " + VPFUtil.listToString(retval));
                }
            }
            catch (IOException i) {
                throw new FormatException("IOException calling available()");
            }
            return false;
        }
    }

    public String getDocumentationFilename() {
        return this.documentationFileName;
    }

    public String getDescription() {
        return this.tableDescription;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getRecordCount() throws FormatException {
        try {
            if (this.recordLength == -1) {
                return this.vli().getRecordCount();
            }
            return (int)(this.inputFile.length() - (long)this.headerLength) / this.recordLength;
        }
        catch (IOException i) {
            System.out.println("RecordCount: io exception " + i.getMessage());
        }
        catch (NullPointerException npe) {
        }
        return -1;
    }

    private final DcwVariableLengthIndexFile vli() throws FormatException, IOException {
        if (this.vli == null) {
            this.openVLI();
        }
        return this.vli;
    }

    private void openVLI() throws FormatException, IOException {
        String fopen;
        String realfname = this.filename.toString();
        boolean endwithdot = realfname.endsWith(".");
        if (endwithdot) {
            StringBuffer newf = new StringBuffer(realfname.substring(0, realfname.length() - 2));
            fopen = newf.append("x.").toString();
        } else {
            StringBuffer newf = new StringBuffer(realfname.substring(0, realfname.length() - 1));
            fopen = newf.append("x").toString();
        }
        this.vli = new DcwVariableLengthIndexFile(new BinaryBufferedFile(fopen), this.byteorder);
    }

    public List getRow(int rownumber) throws FormatException {
        ArrayList l = new ArrayList(this.getColumnCount());
        return this.getRow(l, rownumber) ? l : null;
    }

    public synchronized boolean getRow(List retval, int rownumber) throws FormatException {
        if (this.inputFile == null) {
            this.reopen(rownumber);
        } else {
            this.seekToRow(rownumber);
        }
        return this.parseRow(retval);
    }

    public synchronized void seekToRow(int recordNumber) throws FormatException {
        if (recordNumber <= 0) {
            throw new IllegalArgumentException("DcwRecordFile: seekToRow(" + recordNumber + "," + this.getRecordCount() + "," + this.filename + ")");
        }
        if (recordNumber == this.cursorRow) {
            return;
        }
        this.cursorRow = recordNumber;
        int offset = 0;
        try {
            offset = this.recordLength == -1 && recordNumber != 1 ? this.vli().recordOffset(recordNumber) : this.recordLength * (recordNumber - 1) + this.headerLength;
            this.inputFile.seek(offset);
        }
        catch (IOException io) {
            throw new FormatException("SeekToRow IOException " + io.getMessage() + " offset: " + offset + " " + this.tablename + " " + this.filename);
        }
    }

    public int whatColumn(String columnname) {
        int i = 0;
        while (i < this.columnInfo.length) {
            if (this.columnInfo[i].getColumnName().equals(columnname)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getColumnName(int index) {
        return this.columnInfo[index].getColumnName();
    }

    public void printSchema() throws FormatException {
        System.out.println("File Name: " + this.filename + "\nTable name: " + this.tablename + "\nTable Description: " + this.tableDescription + "\nDocumentation File Name: " + this.documentationFileName + "\nRecord Length: " + this.recordLength + " Record Count: " + this.getRecordCount());
        int i = 0;
        while (i < this.columnInfo.length) {
            System.out.print("Column " + i + " " + this.columnInfo[i].toString() + "\n");
            ++i;
        }
        System.out.flush();
    }

    public synchronized void close() {
        this.cursorRow = -1;
        try {
            if (this.inputFile != null) {
                this.inputFile.close();
            }
            this.inputFile = null;
        }
        catch (IOException i) {
            System.out.println("Caught ioexception " + i.getMessage());
        }
    }

    public synchronized void reopen(int seekRow) throws FormatException {
        try {
            if (this.inputFile == null) {
                this.inputFile = new BinaryBufferedFile(this.filename);
                this.inputFile.byteOrder(this.byteorder);
            }
            if (seekRow > 0) {
                this.seekToRow(seekRow);
            }
        }
        catch (IOException i) {
            throw new FormatException(i.getClass() + ": " + i.getMessage());
        }
    }

    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    public final DcwColumnInfo[] getColumnInfo() {
        return this.columnInfo;
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i]);
            try {
                DcwRecordFile foo = new DcwRecordFile(args[i]);
                foo.printSchema();
                foo.close();
                foo.reopen(1);
                ArrayList l = new ArrayList();
                while (foo.parseRow(l)) {
                    System.out.println(VPFUtil.listToString(l));
                }
                foo.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

