/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.util.cacheHandler;

import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.util.Debug;
import java.util.Arrays;
import java.util.ListIterator;

public abstract class CacheHandler {
    protected CacheObject[] objs;
    protected int logicalClock;
    public static int DEFAULT_MAX_CACHE_SIZE = 25;

    public CacheHandler() {
        this.initCache(DEFAULT_MAX_CACHE_SIZE);
    }

    public CacheHandler(int max_size) {
        this.initCache(max_size);
    }

    private void initCache(int max_size) {
        if (this.objs != null && this.objs.length == max_size) {
            this.clear();
        } else {
            this.objs = new CacheObject[max_size];
        }
        this.logicalClock = 0;
    }

    public void clear() {
        if (this.objs != null) {
            int i = 0;
            while (i < this.objs.length) {
                this.objs[i] = null;
                ++i;
            }
        }
    }

    public void resetCache() {
        this.initCache(this.objs.length);
    }

    public void resetCache(int max_size) {
        this.initCache(max_size);
    }

    public int getCacheSize() {
        return this.objs.length;
    }

    public Object get(String key) {
        CacheObject ret = this.searchCache(key);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(key);
        if (ret == null) {
            return null;
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public abstract CacheObject load(String var1);

    public CacheObject searchCache(String key) {
        int i = 0;
        while (i < this.objs.length) {
            CacheObject co = this.objs[i];
            if (co == null) break;
            if (co.id.equalsIgnoreCase(key)) {
                return co;
            }
            ++i;
        }
        return null;
    }

    protected void replaceLeastUsed(CacheObject newObj) {
        int i = this.objs.length - 1;
        while (i >= 0) {
            if (this.objs[i] == null) {
                if (i == 0) {
                    this.objs[0] = newObj;
                    if (Debug.debugging("cache")) {
                        Debug.output("CacheHandler: was empty - added " + newObj.id);
                    }
                    return;
                }
            } else {
                if (i == this.objs.length - 1) break;
                this.objs[i + 1] = newObj;
                if (Debug.debugging("cache")) {
                    Debug.output("CacheHandler: had room - added " + newObj.id + " to the " + i + " spot.");
                }
                return;
            }
            --i;
        }
        int minClock = this.logicalClock + 1;
        int LUIndex = -1;
        i = this.objs.length - 1;
        while (i >= 0) {
            if (this.objs[i].older(minClock)) {
                LUIndex = i;
                minClock = this.objs[i].cachedTime;
            }
            --i;
        }
        if (LUIndex != -1) {
            if (Debug.debugging("cache")) {
                Debug.output("CacheHandler: Tossing " + this.objs[LUIndex].id + " from cache to add " + newObj.id);
            }
            this.objs[LUIndex] = newObj;
            newObj.cachedTime = this.logicalClock++;
        }
    }

    public ListIterator listIterator() {
        return Arrays.asList(this.objs).listIterator();
    }
}

