/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape.areas;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.areas.AreaHandler;
import com.bbn.openmap.layer.shape.areas.PoliticalArea;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import java.awt.event.MouseEvent;
import java.util.Properties;
import java.util.Vector;

public class AreaShapeLayer
extends ShapeLayer
implements MapMouseListener {
    protected AreaHandler areas;
    private OMGraphic selectedGraphic;

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.areas = new AreaHandler(this.spatialIndex, this.drawingAttributes);
        this.areas.setProperties(prefix, props);
    }

    public void setAreas(AreaHandler a) {
        this.areas = a;
    }

    public AreaHandler getAreas() {
        return this.areas;
    }

    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        LatLonPoint ul = projection.getUpperLeft();
        LatLonPoint lr = projection.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        OMGraphicList list = this.areas.getGraphics(ulLat, ulLon, lrLat, lrLon);
        list.generate(this.getProjection(), true);
        return list;
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.areas.setDrawingAttributes(da);
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.areas.getDrawingAttributes();
    }

    public PoliticalArea findPoliticalArea(String area_abbrev) {
        return this.areas.findPoliticalArea(area_abbrev);
    }

    public boolean mouseMoved(MouseEvent e) {
        OMGraphicList omgraphics = this.getList();
        if (omgraphics == null) {
            return false;
        }
        OMGraphic newSelectedGraphic = omgraphics.selectClosest(e.getX(), e.getY(), 2.0f);
        if (newSelectedGraphic != this.selectedGraphic) {
            if (this.selectedGraphic != null) {
                this.selectedGraphic.deselect();
            }
            this.selectedGraphic = newSelectedGraphic;
            if (newSelectedGraphic != null) {
                newSelectedGraphic.select();
                Object obj = newSelectedGraphic.getAppObject();
                if (obj instanceof String) {
                    this.fireRequestInfoLine((String)obj);
                } else if (obj instanceof Vector) {
                    this.fireRequestInfoLine(this.areas.getName((Vector)obj));
                } else if (obj instanceof Integer) {
                    this.fireRequestInfoLine(this.areas.getName((Integer)obj));
                } else {
                    this.fireRequestInfoLine("");
                }
            } else {
                this.fireRequestInfoLine("");
            }
            this.repaint();
            return true;
        }
        return newSelectedGraphic != null;
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        String[] modes = new String[]{SelectMouseMode.modeID};
        return modes;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }
}

