/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.util.Debug;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public class RpfFileSearch {
    protected Vector files = new Vector();

    public RpfFileSearch() {
    }

    public RpfFileSearch(String startingDir) {
        this.handleEntry(startingDir);
    }

    public boolean handleEntry(String startingDir) {
        File startingFile = null;
        if (startingDir != null && !(startingFile = new File(startingDir)).exists()) {
            startingFile = null;
            Debug.output("RpfFileSearch: " + startingDir + " doesn't exist.");
            return false;
        }
        if (startingFile == null) {
            return false;
        }
        boolean rpfDir = false;
        String start = startingFile.getAbsolutePath();
        if (start.indexOf("RPF") != -1 || start.indexOf("rpf") != -1) {
            rpfDir = true;
        }
        if (Debug.debugging("maketoc")) {
            Debug.output("RpfFileSearch: Starting RPF file search from " + startingDir + ", RPF directory " + (rpfDir ? "found." : "not found."));
        }
        this.handleEntry(startingFile, rpfDir);
        return true;
    }

    public void handleEntry(File file, boolean RPFDirFound) {
        block19: {
            try {
                String[] filenames = file.list();
                boolean dirTest = false;
                boolean not14 = false;
                try {
                    Method method = file.getClass().getDeclaredMethod("isDirectory", null);
                    Object obj = method.invoke((Object)file, (Object[])null);
                    if (obj instanceof Boolean) {
                        dirTest = (Boolean)obj;
                    }
                }
                catch (NoSuchMethodException nsme) {
                    not14 = true;
                }
                catch (SecurityException se) {
                    not14 = true;
                }
                catch (IllegalAccessException iae) {
                    not14 = true;
                }
                catch (IllegalArgumentException iae2) {
                    not14 = true;
                }
                catch (InvocationTargetException ite) {
                    not14 = true;
                }
                if (not14) {
                    boolean bl = dirTest = filenames != null;
                }
                if (dirTest) {
                    if (Debug.debugging("maketocdetail")) {
                        Debug.output("RpfFileSearch.handleEntry(" + file + ", " + RPFDirFound + "), file is a directory");
                    }
                    File[] contents = new File[filenames.length];
                    int i = 0;
                    while (i < contents.length) {
                        contents[i] = new File(file, filenames[i]);
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < contents.length) {
                        boolean rpf = false;
                        if (!RPFDirFound) {
                            rpf = filenames[i2].equalsIgnoreCase("RPF");
                        }
                        this.handleEntry(contents[i2], RPFDirFound || rpf);
                        ++i2;
                    }
                    break block19;
                }
                if (Debug.debugging("maketocdetail")) {
                    Debug.output("RpfFileSearch.handleEntry(" + file + ", " + RPFDirFound + "), adding to list...");
                }
                String parent = file.getParent();
                if (!RPFDirFound) break block19;
                if (parent != null) {
                    this.files.add(file.getParent() + File.separator + file.getName());
                } else {
                    this.files.add("." + File.separator + file.getName());
                }
            }
            catch (NullPointerException npe) {
            }
            catch (SecurityException se) {}
        }
    }

    public String[] getFiles() {
        String[] fs = new String[this.files.size()];
        this.files.toArray(fs);
        return fs;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("RpfFileSearch:\n");
        int i = 0;
        while (i < this.files.size()) {
            s.append("  file " + i + ": " + this.files.elementAt(i) + "\n");
            ++i;
        }
        return s.toString();
    }

    public static void main(String[] argv) {
        Debug.init();
        RpfFileSearch search = new RpfFileSearch();
        int i = 0;
        while (i < argv.length) {
            search.handleEntry(argv[i]);
            ++i;
        }
        System.out.println(search);
    }
}

