/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkBitmap;
import com.bbn.openmap.layer.link.LinkCircle;
import com.bbn.openmap.layer.link.LinkConstants;
import com.bbn.openmap.layer.link.LinkGrid;
import com.bbn.openmap.layer.link.LinkLine;
import com.bbn.openmap.layer.link.LinkPoint;
import com.bbn.openmap.layer.link.LinkPoly;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkRaster;
import com.bbn.openmap.layer.link.LinkRectangle;
import com.bbn.openmap.layer.link.LinkText;
import com.bbn.openmap.omGraphics.OMBitmap;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.ColorFactory;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.Iterator;

public class LinkGraphic
implements LinkConstants,
LinkPropertiesConstants {
    public static void write(OMGraphic omGraphic, Link link) throws IOException {
        LinkGraphic.write(omGraphic, link, null);
    }

    public static void write(OMGraphic omGraphic, Link link, LinkProperties props) throws IOException {
        if (props == null) {
            Object obj = omGraphic.getAppObject();
            props = obj != null && obj instanceof LinkProperties ? (LinkProperties)obj : new LinkProperties();
        }
        if (omGraphic instanceof OMGraphicList) {
            Iterator iterator = ((OMGraphicList)omGraphic).getTargets().iterator();
            while (iterator.hasNext()) {
                LinkGraphic.write((OMGraphic)iterator.next(), link);
            }
            return;
        }
        props.setProperty("lineWidth", Integer.toString((int)((BasicStroke)omGraphic.getStroke()).getLineWidth()));
        Paint paint = omGraphic.getLinePaint();
        if (paint instanceof Color) {
            props.setProperty("lineColor", ColorFactory.getHexColorString((Color)paint));
        }
        if ((paint = omGraphic.getFillPaint()) instanceof Color) {
            props.setProperty("fillColor", ColorFactory.getHexColorString((Color)paint));
        }
        if ((paint = omGraphic.getSelectPaint()) instanceof Color) {
            props.setProperty("highlightColor", ColorFactory.getHexColorString((Color)paint));
        }
        if (omGraphic instanceof OMBitmap) {
            LinkBitmap.write((OMBitmap)omGraphic, link, props);
        } else if (omGraphic instanceof OMCircle) {
            LinkCircle.write((OMCircle)omGraphic, link, props);
        } else if (omGraphic instanceof OMGrid) {
            LinkGrid.write((OMGrid)omGraphic, link, props);
        } else if (omGraphic instanceof OMLine) {
            LinkLine.write((OMLine)omGraphic, link, props);
        } else if (omGraphic instanceof OMPoint) {
            LinkPoint.write((OMPoint)omGraphic, link, props);
        } else if (omGraphic instanceof OMRect) {
            LinkRectangle.write((OMRect)omGraphic, link, props);
        } else if (omGraphic instanceof OMRaster) {
            LinkRaster.write((OMRaster)omGraphic, link, props);
        } else if (omGraphic instanceof OMText) {
            LinkText.write((OMText)omGraphic, link, props);
        } else if (omGraphic instanceof OMPoly) {
            LinkPoly.write((OMPoly)omGraphic, link, props);
        } else {
            Debug.error("LinkGraphic.write: OMGraphic Type not handled by LinkProtocol");
        }
    }
}

