/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class XBMFile {
    public File f;
    public short width;
    public short height;
    public byte[] bits;
    public int paddedWidth;
    String fileStuffString;
    int pict_size;

    public XBMFile(String filename) {
        this.f = new File(filename);
        if (this.f.exists()) {
            this.readin();
        } else {
            System.out.println("XBMFile: framename not valid.");
        }
    }

    public XBMFile(File fileObj) {
        this.f = fileObj;
        if (this.f.exists()) {
            this.readin();
        } else {
            System.out.println("XBMFile: file not valid.");
        }
    }

    public XBMFile(short w, short h, byte[] b) {
        this.width = w;
        this.height = h;
        this.paddedWidth = (int)Math.ceil((double)this.width / 8.0) * 8;
        int dim = this.paddedWidth * this.height;
        if (b.length != dim) {
            System.out.println("XBMFile: byte[] doesn't fit into dimensions");
            if (b.length > dim) {
                this.bits = b;
            } else {
                this.bits = new byte[this.paddedWidth * this.height];
                int i = 0;
                while (i < b.length) {
                    this.bits[i] = b[i];
                    ++i;
                }
            }
        } else {
            this.bits = b;
        }
    }

    private void readin() {
        try {
            byte[] fileStuff = new byte[(int)this.f.length()];
            FileInputStream in = new FileInputStream(this.f);
            in.read(fileStuff);
            this.fileStuffString = new String(fileStuff);
            int startWidth = this.fileStuffString.indexOf("width") + 6;
            int endWidth = this.fileStuffString.indexOf("\n", startWidth);
            int startHeight = this.fileStuffString.indexOf("height") + 7;
            int endHeight = this.fileStuffString.indexOf("\n", startHeight);
            int startBits = this.fileStuffString.indexOf("0x");
            int endBits = this.fileStuffString.indexOf("};");
            this.width = Short.parseShort(this.fileStuffString.substring(startWidth, endWidth));
            this.height = Short.parseShort(this.fileStuffString.substring(startHeight, endHeight));
            this.paddedWidth = (int)Math.ceil((double)this.width / 8.0) * 8;
            int num_bytes = this.paddedWidth * this.height;
            this.pict_size = this.height * (int)Math.ceil((double)this.width / 8.0);
            this.bits = new byte[num_bytes];
            this.setBits(this.fileStuffString.substring(startBits, endBits));
        }
        catch (IOException e3) {
            System.out.println("XBMFile: Error reading file.");
        }
    }

    public void setBits(String tmpString) {
        int num_bytes = this.paddedWidth * this.height;
        int i = 0;
        int j = 0;
        while (j < num_bytes) {
            i = tmpString.indexOf("0x", i);
            int first = Character.digit(tmpString.charAt(i + 2), 16) * 16;
            int second = Character.digit(tmpString.charAt(i + 3), 16);
            this.bits[j] = new Integer(first + second).byteValue();
            ++j;
            i += 4;
        }
    }

    private int widthCheck(int widthTrak) {
        if (widthTrak > this.paddedWidth - 2) {
            System.out.println();
            widthTrak = 0;
        } else {
            ++widthTrak;
        }
        return widthTrak;
    }

    public void printout() {
        int widthTrak = -1;
        int i = 0;
        while (i < this.pict_size) {
            int val = new Byte(this.bits[i]).intValue();
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 1) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 2) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 4) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 8) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 0x10) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 0x20) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 0x40) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            widthTrak = this.widthCheck(widthTrak);
            if ((val & 0x80) != 0) {
                System.out.print('*');
            } else {
                System.out.print(' ');
            }
            ++i;
        }
        System.out.println("");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("XBMFile:  Need a path/filename");
            System.exit(0);
        }
        System.out.println("XBMFile: " + args[0]);
        XBMFile xbm = new XBMFile(args[0]);
        xbm.printout();
    }
}

