/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.util.Properties;

public class ImageServerUtils
implements ImageServerConstants {
    public static Proj createOMProjection(Properties props, Projection defaultProj) {
        float scale = PropUtils.floatFromProperties(props, "SCALE", defaultProj.getScale());
        int height = PropUtils.intFromProperties(props, "HEIGHT", defaultProj.getHeight());
        int width = PropUtils.intFromProperties(props, "WIDTH", defaultProj.getWidth());
        LatLonPoint llp = defaultProj.getCenter();
        float longitude = PropUtils.floatFromProperties(props, "LON", llp.getLongitude());
        float latitude = PropUtils.floatFromProperties(props, "LAT", llp.getLatitude());
        Class<?> projClass = null;
        String projType = props.getProperty("PROJTYPE");
        if (projType != null) {
            projClass = ProjectionFactory.getProjClassForName(projType);
        }
        if (projClass == null) {
            projClass = defaultProj.getClass();
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServerUtils.createOMProjection: projection " + projClass.getName() + ", with HEIGHT = " + height + ", WIDTH = " + width + ", lat = " + latitude + ", lon = " + longitude);
        }
        Proj proj = (Proj)ProjectionFactory.makeProjection(projClass, latitude, longitude, scale, width, height);
        return proj;
    }

    public static Color getBackground(Properties props) {
        boolean transparent = PropUtils.booleanFromProperties(props, "TRANSPARENT", false);
        Color backgroundColor = PropUtils.parseColorFromProperties(props, "BGCOLOR", "FFFFFF");
        if (transparent) {
            backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 0);
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("ImageServerUtils.createOMProjection: projection color: " + Integer.toHexString(backgroundColor.getRGB()) + ", transparent(" + transparent + ")");
        }
        return backgroundColor;
    }
}

