/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class WindowSupport
extends ListenerSupport
implements ComponentListener,
ActionListener {
    protected Component content;
    protected String title;
    protected Point componentLocation;
    protected Dimension componentSize;
    public static final String DisplayWindowCmd = "displayWindowCmd";
    public static final String KillWindowCmd = "killWindowCmd";
    protected transient JInternalFrame iFrame;
    protected transient JDialog dialog;
    protected int maxHeight = -1;
    protected int maxWidth = -1;

    public WindowSupport(Component content, String windowTitle) {
        super(content);
        this.content = content;
        this.title = windowTitle;
    }

    public void setComponentLocation(Point p) {
        this.componentLocation = p;
    }

    public Point getComponentLocation() {
        return this.componentLocation;
    }

    public void setComponentSize(Dimension dim) {
        this.componentSize = dim;
    }

    public Dimension getComponentSize() {
        return this.componentSize;
    }

    public void componentResized(ComponentEvent e) {
        Component source = (Component)e.getSource();
        if (source instanceof JFrame) {
            source = ((JFrame)source).getContentPane();
        } else if (source instanceof JInternalFrame) {
            source = ((JInternalFrame)source).getContentPane();
        } else if (source instanceof JDialog) {
            source = ((JDialog)source).getContentPane();
        }
        this.setComponentSize(new Dimension(source.getWidth(), source.getHeight()));
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentResized(e);
        }
    }

    public void componentMoved(ComponentEvent e) {
        this.setComponentLocation(((Component)e.getSource()).getLocation());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentMoved(e);
        }
    }

    public void componentShown(ComponentEvent e) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentShown(e);
        }
    }

    public void componentHidden(ComponentEvent e) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentHidden(e);
        }
        Component source = (Component)e.getSource();
        if (source == this.dialog || source == this.iFrame) {
            this.cleanUp();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == KillWindowCmd) {
            this.killWindow();
        } else if (command == DisplayWindowCmd) {
            this.displayInWindow();
        }
    }

    protected void finalize() {
        if (Debug.debugging("gc")) {
            Debug.output("WindowSupport being gc'd");
        }
    }

    public void setTitle(String tle) {
        this.title = tle;
        if (this.iFrame != null) {
            this.iFrame.setTitle(tle);
        } else if (this.dialog != null) {
            this.dialog.setTitle(tle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public Component modifyContent(Component comp) {
        return comp;
    }

    public void setContent(Component comp) {
        this.content = comp;
        if (this.iFrame != null) {
            this.iFrame.getContentPane().add(this.modifyContent(this.content));
            this.iFrame.pack();
        } else if (this.dialog != null) {
            this.dialog.getContentPane().removeAll();
            this.dialog.getContentPane().add(this.modifyContent(this.content));
            this.dialog.pack();
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setMaxSize(int width, int height) {
        this.maxHeight = height;
        this.maxWidth = width;
    }

    public void displayInWindow() {
        this.displayInWindow(null);
    }

    public void displayInWindow(Frame owner) {
        boolean w = false;
        boolean h = false;
        Dimension dim = this.getComponentSize();
        if (dim != null) {
            this.content.setSize(dim);
        }
        int x = -1;
        int y = -1;
        Point loc = this.getComponentLocation();
        if (loc != null) {
            x = (int)loc.getX();
            y = (int)loc.getY();
        }
        this.displayInWindow(owner, x, y, -1, -1);
    }

    public void displayInWindow(int x, int y, int width, int height) {
        this.displayInWindow(null, x, y, width, height);
    }

    public void displayInWindow(Frame owner, int x, int y, int width, int height) {
        if (this.content == null) {
            Debug.message("windowsupport", "WindowSupport asked to display window with null content");
            return;
        }
        if (this.iFrame == null && this.dialog == null) {
            if (Environment.getBoolean("openmap.UseInternalFrames")) {
                this.iFrame = new JInternalFrame(this.title, true, true, true, true);
                this.iFrame.setOpaque(true);
                this.iFrame.addComponentListener(this);
                JLayeredPane desktop = Environment.getInternalFrameDesktop();
                Debug.message("windows", "WindowSupport creating internal frame");
                if (desktop != null) {
                    desktop.remove(this.iFrame);
                    desktop.add((Component)this.iFrame, JLayeredPane.PALETTE_LAYER);
                } else {
                    Debug.output("WindowSupport:  No desktop set for internal frame");
                }
            } else {
                this.dialog = new JDialog(owner, this.title);
                this.dialog.addComponentListener(this);
                Debug.message("windows", "WindowSupport creating frame");
            }
        }
        this.setContent(this.content);
        if (this.content instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)((Object)this.content));
        }
        if (this.iFrame != null) {
            this.iFrame.pack();
            this.checkBounds(this.iFrame, x, y, width, height);
            this.iFrame.show();
            this.iFrame.toFront();
        } else if (this.dialog != null) {
            this.dialog.pack();
            this.checkBounds(this.dialog, x, y, width, height);
            if (owner != null && x < 0 && y < 0) {
                this.dialog.setLocationRelativeTo(owner);
            } else if (owner == null) {
                this.setPosition(this.dialog);
            }
            this.dialog.show();
        }
    }

    protected void checkBounds(Component comp, int x, int y, int width, int height) {
        if (comp != null) {
            if (width <= 0) {
                width = comp.getWidth();
            }
            if (this.maxWidth > 0 && width > this.maxWidth) {
                width = this.maxWidth;
            }
            if (height <= 0) {
                height = comp.getHeight();
            }
            if (this.maxHeight > 0 && height > this.maxHeight) {
                height = this.maxHeight;
            }
            comp.setBounds(x, y, width, height);
        }
    }

    protected void setPosition(Component comp) {
        int w = comp.getWidth();
        int h = comp.getHeight();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Debug.message("basic", "Screen dimensions are " + d);
        int x = d.width / 2 - w / 2;
        int y = d.height / 2 - h / 2;
        if (Debug.debugging("basic")) {
            Debug.output("Setting PLG frame X and Y from properties to " + x + " " + y);
        }
        comp.setBounds(x, y, w, h);
    }

    public void killWindow() {
        ComponentEvent ce = null;
        JDialog dialogLocal = this.dialog;
        JInternalFrame iFrameLocal = this.iFrame;
        if (dialogLocal != null) {
            dialogLocal.setVisible(false);
            ce = new ComponentEvent(dialogLocal, 103);
        } else if (iFrameLocal != null) {
            iFrameLocal.setVisible(false);
            ce = new ComponentEvent(iFrameLocal, 103);
        }
        if (ce != null) {
            this.componentHidden(ce);
        }
    }

    protected void cleanUp() {
        if (this.dialog != null) {
            this.dialog.removeComponentListener(this);
            this.dialog.dispose();
            this.dialog = null;
        } else if (this.iFrame != null) {
            this.iFrame.removeComponentListener(this);
            this.iFrame.dispose();
            this.iFrame = null;
        }
        if (this.content instanceof ComponentListener) {
            this.removeComponentListener((ComponentListener)((Object)this.content));
        }
    }

    public void addComponentListener(ComponentListener l) {
        this.addListener(l);
    }

    public void removeComponentListener(ComponentListener l) {
        this.removeListener(l);
    }

    public Container getWindow() {
        if (this.dialog != null) {
            return this.dialog;
        }
        return this.iFrame;
    }
}

