/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.LayerStatusListener;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class StatusLightPanel
extends OMComponentPanel
implements LayerStatusListener,
PropertyChangeListener,
PropertyConsumer {
    protected int numlayers = 0;
    protected MapBean map;
    protected Layer[] layers;
    protected Hashtable statusLights = new Hashtable();
    protected JToolBar container = null;
    protected static final transient URL greyURL = (class$com$bbn$openmap$gui$StatusLightPanel == null ? (class$com$bbn$openmap$gui$StatusLightPanel = StatusLightPanel.class$("com.bbn.openmap.gui.StatusLightPanel")) : class$com$bbn$openmap$gui$StatusLightPanel).getResource("grey.gif");
    public static final transient ImageIcon greyIcon = new ImageIcon(greyURL, "unknown");
    protected static final transient URL redURL = (class$com$bbn$openmap$gui$StatusLightPanel == null ? (class$com$bbn$openmap$gui$StatusLightPanel = StatusLightPanel.class$("com.bbn.openmap.gui.StatusLightPanel")) : class$com$bbn$openmap$gui$StatusLightPanel).getResource("red.gif");
    public static final transient ImageIcon redIcon = new ImageIcon(redURL, "working");
    protected static final transient URL greenURL = (class$com$bbn$openmap$gui$StatusLightPanel == null ? (class$com$bbn$openmap$gui$StatusLightPanel = StatusLightPanel.class$("com.bbn.openmap.gui.StatusLightPanel")) : class$com$bbn$openmap$gui$StatusLightPanel).getResource("green.gif");
    public static final transient ImageIcon greenIcon = new ImageIcon(greenURL, "stable");
    protected boolean waitingForLayers = false;
    protected boolean showWaitCursor = false;
    protected boolean lightTriggers = true;
    public static final String LightTriggersProperty = "triggers";
    public static final String defaultKey = "StatusLightPanel";
    protected String key = "StatusLightPanel";
    static /* synthetic */ Class class$com$bbn$openmap$gui$StatusLightPanel;

    public StatusLightPanel() {
        this.setLayout(new GridLayout(1, 0));
        this.reset();
    }

    public void setMap(MapBean map) {
        if (this.map != null) {
            this.map.removePropertyChangeListener(this);
        }
        this.map = map;
        if (map != null) {
            map.addPropertyChangeListener(this);
        }
    }

    public MapBean getMap() {
        return this.map;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "MapBean.layers") {
            this.listenToLayers((Layer[])evt.getNewValue());
        }
    }

    protected void listenToLayers(Layer[] newLayers) {
        int i;
        if (this.layers != null) {
            i = 0;
            while (i < this.layers.length) {
                if (this.layers[i] != null) {
                    this.layers[i].removeLayerStatusListener(this);
                    boolean stillOnMap = false;
                    int j = 0;
                    while (j < newLayers.length) {
                        if (this.layers[i] == newLayers[j]) {
                            stillOnMap = true;
                        }
                        ++j;
                    }
                    if (!stillOnMap) {
                        JButton light = (JButton)this.statusLights.get(this.layers[i]);
                        light.removeActionListener(this.layers[i]);
                        this.statusLights.remove(this.layers[i]);
                    }
                    this.layers[i] = null;
                }
                ++i;
            }
        }
        if (newLayers != null) {
            i = 0;
            while (i < newLayers.length) {
                if (newLayers[i] != null) {
                    newLayers[i].addLayerStatusListener(this);
                    this.getStatusLightForLayer(newLayers[i]);
                } else {
                    Debug.message("statuslights", "StatusLightPanel: null layer in new layer array");
                }
                ++i;
            }
            this.layers = newLayers;
            this.reset();
        }
    }

    protected JButton getStatusLightForLayer(Layer layer) {
        if (layer == null) {
            return null;
        }
        JButton newLight = (JButton)this.statusLights.get(layer);
        if (newLight == null) {
            newLight = new JButton(greenIcon);
            newLight.setToolTipText(layer.getName());
            newLight.setMargin(new Insets(2, 1, 2, 1));
            this.statusLights.put(layer, newLight);
            if (this.lightTriggers) {
                newLight.setActionCommand("displayPaletteCmd");
                newLight.addActionListener(layer);
                newLight.setBorderPainted(true);
            } else {
                newLight.setBorderPainted(false);
            }
        }
        return newLight;
    }

    public void reset() {
        this.removeAll();
        if (this.container != null) {
            this.container.removeAll();
        }
        if (this.lightTriggers) {
            if (this.container == null) {
                this.container = new JToolBar();
                this.container.setFloatable(false);
            }
            this.add(this.container);
        } else {
            this.container = null;
        }
        if (this.layers != null) {
            int i = 0;
            while (i < this.layers.length) {
                JButton statusgif = this.getStatusLightForLayer(this.layers[i]);
                if (statusgif != null) {
                    if (this.lightTriggers) {
                        this.container.add(statusgif);
                    } else {
                        this.add(statusgif);
                    }
                }
                ++i;
            }
        }
        this.revalidate();
    }

    protected void setLayerStatus(Layer layer, Icon icon) {
        JButton statusgif = (JButton)this.statusLights.get(layer);
        if (statusgif != null) {
            statusgif.setIcon(icon);
            if (this.map != null) {
                if (icon == redIcon && this.showWaitCursor) {
                    this.waitingForLayers = true;
                } else if (icon == greenIcon) {
                    Enumeration lights = this.statusLights.elements();
                    this.waitingForLayers = false;
                    while (lights.hasMoreElements()) {
                        JButton light = (JButton)lights.nextElement();
                        if (light.getIcon() != redIcon) continue;
                        this.waitingForLayers = true;
                    }
                }
            }
        }
    }

    public void updateLayerStatus(LayerStatusEvent evt) {
        switch (evt.getStatus()) {
            case 8342: {
                this.setLayerStatus((Layer)evt.getSource(), redIcon);
                break;
            }
            case 8350: {
                break;
            }
            case 8359: {
                this.setLayerStatus((Layer)evt.getSource(), greenIcon);
                break;
            }
            default: {
                System.err.println("InformationDelegator.updateLayerStatus(): unknown status: " + evt.getStatus());
            }
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setMap((MapBean)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            this.setMap(null);
        }
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setLightTriggers(LayerUtils.booleanFromProperties(props, prefix + LightTriggersProperty, this.lightTriggers));
    }

    public void setLightTriggers(boolean set) {
        this.lightTriggers = set;
        this.statusLights.clear();
        this.reset();
    }

    public boolean getLightTriggers() {
        return this.lightTriggers;
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + LightTriggersProperty, new Boolean(this.lightTriggers).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(LightTriggersProperty, "Lights should launch layer palettes");
        props.put("triggers.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

