/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.gui.MouseModePanel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class MouseModeButtonPanel
extends MouseModePanel {
    private JToolBar toolBar = null;
    protected boolean floatable = false;
    protected HashMap buttonSet = new HashMap();
    protected JToggleButton enabledButton = null;
    public static final String defaultKey = "mousemodebuttonpanel";

    public MouseModeButtonPanel() {
        this.setKey(defaultKey);
    }

    protected void setPanel(MouseDelegator md) {
        if (this.toolBar != null) {
            this.remove(this.toolBar);
        }
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(this.floatable);
        String activeMode = md.getActiveMouseModeID();
        ButtonGroup bg = new ButtonGroup();
        MapMouseMode[] modes = md.getMouseModes();
        int i = 0;
        while (i < modes.length) {
            String modeStr = modes[i].getID();
            boolean on = modeStr == activeMode;
            Icon icon = modes[i].getGUIIcon();
            JToggleButton btn = icon != null ? new JToggleButton(icon, on) : new JToggleButton(modeStr, on);
            if (on) {
                this.enabledButton = btn;
            }
            this.buttonSet.put(modeStr, btn);
            bg.add(btn);
            btn.setToolTipText(modes[i].getPrettyName());
            this.toolBar.add(btn);
            btn.setActionCommand(modeStr);
            btn.addActionListener(this);
            btn.setVisible(modes[i].isVisible());
            ++i;
        }
        this.add(this.toolBar);
        this.revalidate();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mouseDelegator == null) {
            return;
        }
        this.mouseDelegator.setActiveMouseModeWithID(e.getActionCommand());
    }

    public void setFloatable(boolean floatable) {
        this.floatable = floatable;
        this.toolBar.setFloatable(floatable);
    }

    public boolean getFloatable() {
        return this.toolBar.isFloatable();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            String mmID = ((MapMouseMode)evt.getNewValue()).getID();
            JToggleButton btn = (JToggleButton)this.buttonSet.get(mmID);
            if (btn != null) {
                btn.setSelected(true);
                this.enabledButton = btn;
            }
        } else if (evt.getPropertyName() == "NewListOfMouseModes") {
            this.toolBar.removeAll();
            this.setPanel(this.mouseDelegator);
        }
    }
}

