/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.input;

import com.bbn.openmap.dataAccess.shape.input.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShxInputStream {
    private int _type = -1;
    private LittleEndianInputStream _leis = null;

    public ShxInputStream(InputStream is) {
        BufferedInputStream bis = new BufferedInputStream(is);
        this._leis = new LittleEndianInputStream(bis);
    }

    public int[][] getIndex() {
        int[][] indexData = null;
        try {
            int fileCode = this._leis.readInt();
            this._leis.skipBytes(20);
            int fileLength = this._leis.readInt();
            int numShapes = (fileLength - 50) / 4;
            indexData = new int[2][numShapes];
            this._leis.skipBytes(4);
            byte[] intBytes = new byte[4];
            this._type = this._leis.readLEInt();
            this._leis.skip(64L);
            int i = 0;
            while (i <= numShapes - 1) {
                indexData[0][i] = this._leis.readInt();
                indexData[1][i] = this._leis.readInt();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return indexData;
    }

    public void close() throws IOException {
        this._leis.close();
    }
}

