/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.input;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPoint;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolyline;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.LittleEndianInputStream;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.util.Debug;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShpInputStream
implements ShapeConstants {
    private LittleEndianInputStream _leis = null;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();

    public ShpInputStream(InputStream is) {
        BufferedInputStream bis = new BufferedInputStream(is);
        this._leis = new LittleEndianInputStream(bis);
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.drawingAttributes = da;
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.drawingAttributes;
    }

    public EsriGraphicList getGeometry(int[][] indexData) throws Exception {
        EsriGraphicList list = null;
        int shapeType = this.readHeader();
        if (shapeType == 1) {
            list = this.getPointGeometry(indexData);
        } else if (shapeType == 3) {
            list = this.getPolyGeometry(indexData, 3);
        } else if (shapeType == 5) {
            list = this.getPolyGeometry(indexData, 5);
        }
        return list;
    }

    private int[] getPartOffsets(OMGraphicList sublist) {
        int pos = 0;
        int[] offsets = new int[sublist.size()];
        int j = 0;
        while (j < sublist.size()) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(j);
            float[] data = poly.getLatLonArray();
            offsets[j] = pos / 2;
            pos += data.length;
            ++j;
        }
        return offsets;
    }

    public EsriGraphicList getPointGeometry(int[][] indexData) throws Exception {
        EsriPointList list = new EsriPointList();
        int numShapes = indexData[1].length;
        int i = 0;
        while (i < numShapes) {
            int shpRecord = this._leis.readInt();
            int shpContentLength = this._leis.readInt();
            int shpType = this._leis.readLEInt();
            double lambda = this._leis.readLEDouble();
            double phi = this._leis.readLEDouble();
            Double d1 = new Double(lambda);
            Double d2 = new Double(phi);
            float f1 = d1.floatValue();
            float f2 = d2.floatValue();
            EsriPoint point = new EsriPoint(f2, f1);
            point.setAppObject(new Integer(shpRecord));
            if (this.drawingAttributes != null) {
                this.drawingAttributes.setTo(point);
            } else {
                DrawingAttributes.DEFAULT.setTo(point);
            }
            ((EsriGraphicList)list).add(point);
            ++i;
        }
        return list;
    }

    private int getPointsPerShape(OMGraphicList sublist) {
        int numPoints = 0;
        int i = 0;
        while (i < sublist.size()) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(i);
            float[] data = poly.getLatLonArray();
            numPoints += data.length;
            ++i;
        }
        return numPoints /= 2;
    }

    public EsriGraphicList getPolyGeometry(int[][] indexData, int shapeType) throws Exception {
        EsriGraphicList list = null;
        if (shapeType == 3) {
            list = new EsriPolylineList();
        } else if (shapeType == 5) {
            list = new EsriPolygonList();
        }
        boolean pos = false;
        int numShapes = indexData[1].length;
        int t = 0;
        while (t < numShapes) {
            int shpRecord = this._leis.readInt();
            int shpContentLength = this._leis.readInt();
            int shpType = this._leis.readLEInt();
            double xLeft = this._leis.readLEDouble();
            double xBottom = this._leis.readLEDouble();
            double xRight = this._leis.readLEDouble();
            double xTop = this._leis.readLEDouble();
            int numParts = this._leis.readLEInt();
            int numPoints = this._leis.readLEInt();
            double[] ptsx = new double[numPoints];
            double[] ptsy = new double[numPoints];
            int[] offsets = new int[numParts];
            int n = 0;
            while (n < numParts) {
                offsets[n] = this._leis.readLEInt();
                ++n;
            }
            OMPoly poly = null;
            EsriGraphicList sublist = null;
            if (numParts > 1) {
                if (shapeType == 3) {
                    sublist = new EsriPolylineList();
                } else if (shapeType == 5) {
                    sublist = new EsriPolygonList();
                }
                sublist.setVague(true);
                sublist.setAppObject(new Integer(shpRecord));
            }
            int j = 0;
            while (j < numParts) {
                float[] points;
                int numVertices;
                int i = 0;
                if (j != numParts - 1) {
                    numVertices = offsets[j + 1] - offsets[j];
                    points = new float[numVertices * 2];
                } else {
                    numVertices = numPoints - offsets[j];
                    points = new float[numVertices * 2];
                }
                int n2 = 0;
                while (n2 < numVertices) {
                    double lambda = this._leis.readLEDouble();
                    double phi = this._leis.readLEDouble();
                    Double d1 = new Double(phi);
                    Double d2 = new Double(lambda);
                    points[i++] = d1.floatValue();
                    points[i++] = d2.floatValue();
                    ++n2;
                }
                if (shapeType == 3) {
                    poly = new EsriPolyline(points, 0, 1);
                } else if (shapeType == 5) {
                    poly = new EsriPolygon(points, 0, 1);
                }
                poly.setAppObject(new Integer(shpRecord));
                if (this.drawingAttributes != null) {
                    this.drawingAttributes.setTo(poly);
                } else {
                    DrawingAttributes.DEFAULT.setTo(poly);
                }
                if (poly instanceof EsriPolyline) {
                    ((OMGraphic)poly).setFillPaint(OMColor.clear);
                }
                if (sublist != null) {
                    sublist.addOMGraphic(poly);
                }
                ++j;
            }
            if (sublist != null) {
                list.add(sublist);
            } else {
                list.add(poly);
            }
            if (Debug.debugging("esri")) {
                EsriGraphic eg = null;
                eg = sublist == null ? (EsriGraphic)((Object)poly) : sublist;
                float[] ex1 = eg.getExtents();
                Debug.output("extents of list: xmin=" + ex1[1] + ", ymin=" + ex1[0] + ", xmax=" + ex1[3] + ", ymax=" + ex1[2]);
                Debug.output("list.size=" + list.size());
            }
            ++t;
        }
        if (Debug.debugging("esri")) {
            float[] ex = list.getExtents();
            Debug.output("extents of list: xmin=" + ex[1] + ", ymin=" + ex[0] + ", xmax=" + ex[3] + ", ymax=" + ex[2]);
        }
        return list;
    }

    public int readHeader() throws IOException {
        int fileCode = this._leis.readInt();
        this._leis.skipBytes(20);
        int fileLength = this._leis.readInt();
        int version = this._leis.readLEInt();
        int shapeType = this._leis.readLEInt();
        double xMin = this._leis.readLEDouble();
        double yMin = this._leis.readLEDouble();
        double xMax = this._leis.readLEDouble();
        double yMax = this._leis.readLEDouble();
        double zMin = this._leis.readLEDouble();
        double zMax = this._leis.readLEDouble();
        double mMin = this._leis.readLEDouble();
        double mMax = this._leis.readLEDouble();
        return shapeType;
    }
}

