/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBeanRepaintPolicy;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.StandardMapBeanRepaintPolicy;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.PaintListener;
import com.bbn.openmap.event.PaintListenerSupport;
import com.bbn.openmap.event.PanEvent;
import com.bbn.openmap.event.PanListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.event.ProjectionSupport;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.OverlayLayout;

public class MapBean
extends JComponent
implements ComponentListener,
ContainerListener,
ProjectionListener,
PanListener,
ZoomListener,
LayerListener,
CenterListener,
SoloMapComponent {
    public static final String LayersProperty = "MapBean.layers";
    public static final String CursorProperty = "MapBean.cursor";
    public static final String BackgroundProperty = "MapBean.background";
    public static final String ProjectionProperty = "MapBean.projection";
    public static final String title = "OpenMap(tm)";
    public static final String version = "4.6.2";
    public static boolean suppressCopyright = false;
    private static final boolean DEBUG_TIMESTAMP = false;
    private static final boolean DEBUG_THREAD = true;
    private static final String copyrightNotice = "OpenMap(tm) Version 4.6.2\r\n  Copyright (C) BBNT Solutions LLC.  All rights reserved.\r\n  See http://openmap.bbn.com/ for details.\r\n";
    public static final float DEFAULT_CENTER_LAT = 0.0f;
    public static final float DEFAULT_CENTER_LON = 0.0f;
    public static final float DEFAULT_SCALE = Float.MAX_VALUE;
    public static final int DEFAULT_WIDTH = 640;
    public static final int DEFAULT_HEIGHT = 480;
    protected int minHeight = 100;
    protected int minWidth = 100;
    protected Proj projection = new Mercator(new LatLonPoint(0.0f, 0.0f), Float.MAX_VALUE, 640, 480);
    protected ProjectionSupport projectionSupport;
    protected Vector removedLayers = new Vector(0);
    protected boolean layerRemovalDelayed = true;
    protected Vector addedLayers = new Vector(0);
    protected PaintListenerSupport painters = null;
    protected Paint background = null;
    protected MapBeanRepaintPolicy repaintPolicy = null;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(191, 239, 255);
    private static final transient Insets insets = new Insets(0, 0, 0, 0);
    protected transient Layer[] currentLayers = new Layer[0];
    protected transient boolean doContainerChange = true;

    public static String getCopyrightMessage() {
        return copyrightNotice;
    }

    public MapBean() {
        if (Debug.debugging("mapbean")) {
            this.debugmsg("MapBean()");
        }
        if (!suppressCopyright) {
            Debug.output(copyrightNotice);
        }
        this.background = DEFAULT_BACKGROUND_COLOR;
        suppressCopyright = true;
        super.setLayout(new OverlayLayout(this));
        this.projectionSupport = new ProjectionSupport(this);
        this.addComponentListener(this);
        this.addContainerListener(this);
        if (Beans.isDesignTime()) {
            this.add(new Layer(){

                public void projectionChanged(ProjectionEvent e) {
                }

                public Dimension getPreferredSize() {
                    return new Dimension(100, 100);
                }
            });
        }
        this.setPreferredSize(new Dimension(this.projection.getWidth(), this.projection.getHeight()));
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    protected final void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof Layer)) {
            throw new IllegalArgumentException("only Layers can be added to a MapBean");
        }
        super.addImpl(comp, constraints, index);
    }

    public final void setLayout(LayoutManager mgr) {
        throw new IllegalArgumentException("cannot change layout of Map");
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minWidth, this.minHeight);
    }

    public void setMinimumSize(Dimension dim) {
        this.minWidth = (int)dim.getWidth();
        this.minHeight = (int)dim.getHeight();
    }

    public final Insets getInsets() {
        return insets;
    }

    public void componentResized(ComponentEvent e) {
        if (Debug.debugging("mapbean")) {
            this.debugmsg("Size changed: " + this.getWidth() + " x " + this.getHeight());
        }
        this.projection.setWidth(this.getWidth());
        this.projection.setHeight(this.getHeight());
        this.fireProjectionChanged();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public synchronized void addProjectionListener(ProjectionListener l) {
        this.projectionSupport.addProjectionListener(l);
        l.projectionChanged(new ProjectionEvent(this, this.getProjection()));
    }

    public synchronized void removeProjectionListener(ProjectionListener l) {
        this.projectionSupport.removeProjectionListener(l);
    }

    protected void fireProjectionChanged() {
        this.firePropertyChange(ProjectionProperty, null, this.getProjection());
        this.projectionSupport.fireProjectionChanged(this.getProjection());
        this.purgeAndNotifyRemovedLayers();
    }

    public void purgeAndNotifyRemovedLayers() {
        if (this.removedLayers.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.removedLayers.size()) {
            Layer l = (Layer)this.removedLayers.elementAt(i);
            l.removed(this);
            ++i;
        }
        this.removedLayers.removeAllElements();
        if (Debug.debugging("helpgc")) {
            System.gc();
        }
    }

    public float getScale() {
        return this.projection.getScale();
    }

    public void setScale(float newScale) {
        this.projection.setScale(newScale);
        this.fireProjectionChanged();
    }

    public LatLonPoint getCenter() {
        return this.projection.getCenter();
    }

    public void setCenter(LatLonPoint newCenter) {
        this.projection.setCenter(newCenter);
        this.fireProjectionChanged();
    }

    public void setCenter(float lat, float lon) {
        this.projection.setCenter(lat, lon);
        this.fireProjectionChanged();
    }

    public int getProjectionType() {
        return this.projection.getProjectionType();
    }

    public void setProjectionType(int newType) {
        int oldType = this.projection.getProjectionType();
        if (oldType != newType) {
            LatLonPoint ctr = this.projection.getCenter();
            this.setProjection((Proj)ProjectionFactory.makeProjection(newType, ctr.getLatitude(), ctr.getLongitude(), this.projection.getScale(), this.projection.getWidth(), this.projection.getHeight()));
        }
    }

    public void setBackgroundColor(Color color) {
        this.setBackground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setBckgrnd(color);
    }

    public void setBckgrnd(Paint paint) {
        this.setBufferDirty(true);
        Paint oldBackground = this.background;
        this.background = paint;
        this.firePropertyChange(BackgroundProperty, oldBackground, this.background);
        this.repaint();
    }

    public Color getBackground() {
        Paint ret = this.getBckgrnd();
        if (ret instanceof Color) {
            return (Color)ret;
        }
        return super.getBackground();
    }

    public Paint getBckgrnd() {
        Paint ret = this.background;
        if (ret == null) {
            ret = super.getBackground();
        }
        return ret;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection aProjection) {
        if (aProjection != null) {
            this.setBufferDirty(true);
            this.projection = (Proj)aProjection;
            this.setPreferredSize(new Dimension(this.projection.getWidth(), this.projection.getHeight()));
            this.fireProjectionChanged();
        }
    }

    public void center(CenterEvent evt) {
        this.setCenter(evt.getLatitude(), evt.getLongitude());
    }

    public void pan(PanEvent evt) {
        if (Debug.debugging("mapbean")) {
            this.debugmsg("PanEvent: " + evt);
        }
        float az = evt.getAzimuth();
        float c = evt.getArcDistance();
        if (Float.isNaN(c)) {
            this.projection.pan(az);
        } else {
            this.projection.pan(az, c);
        }
        this.fireProjectionChanged();
    }

    public void zoom(ZoomEvent evt) {
        float newScale;
        if (evt.isAbsolute()) {
            newScale = evt.getAmount();
        } else if (evt.isRelative()) {
            newScale = this.getScale() * evt.getAmount();
        } else {
            return;
        }
        this.setScale(newScale);
    }

    public void setDoContainerChange(boolean value) {
        if (!this.doContainerChange && value) {
            this.doContainerChange = value;
            this.changeLayers(null);
        } else {
            this.doContainerChange = value;
        }
    }

    public boolean getDoContainerChange() {
        return this.doContainerChange;
    }

    public void componentAdded(ContainerEvent e) {
        this.addProjectionListener((Layer)e.getChild());
        if (!this.removedLayers.removeElement(e.getChild())) {
            this.addedLayers.addElement(e.getChild());
        }
        this.changeLayers(e);
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeProjectionListener((Layer)e.getChild());
        this.removedLayers.addElement(e.getChild());
        this.changeLayers(e);
    }

    protected void changeLayers(ContainerEvent e) {
        if (!this.doContainerChange) {
            return;
        }
        Component[] comps = this.getComponents();
        int ncomponents = comps.length;
        Layer[] newLayers = new Layer[ncomponents];
        System.arraycopy(comps, 0, newLayers, 0, ncomponents);
        if (Debug.debugging("mapbean")) {
            this.debugmsg("changeLayers() - firing change");
        }
        this.firePropertyChange(LayersProperty, this.currentLayers, newLayers);
        int i = 0;
        while (i < this.addedLayers.size()) {
            ((Layer)this.addedLayers.elementAt(i)).added(this);
            ++i;
        }
        this.addedLayers.removeAllElements();
        this.currentLayers = newLayers;
    }

    public void projectionChanged(ProjectionEvent e) {
        Projection newProj = e.getProjection();
        if (!this.projection.equals(newProj)) {
            this.setProjection(newProj);
        }
    }

    public void setCursor(Cursor newCursor) {
        this.firePropertyChange(CursorProperty, this.getCursor(), newCursor);
        super.setCursor(newCursor);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        super.addPropertyChangeListener(pcl);
        pcl.propertyChange(new PropertyChangeEvent(this, LayersProperty, this.currentLayers, this.currentLayers));
        pcl.propertyChange(new PropertyChangeEvent(this, CursorProperty, this.getCursor(), this.getCursor()));
        pcl.propertyChange(new PropertyChangeEvent(this, BackgroundProperty, this.getBckgrnd(), this.getBckgrnd()));
    }

    protected final void debugmsg(String msg) {
        Debug.output(this.toString() + "" + " [" + Thread.currentThread() + "]" + ": " + msg);
    }

    public void paint(Graphics g) {
        if (this.getComponentCount() == 0 && this.projection != null) {
            this.drawProjectionBackground(g);
            this.paintBorder(g);
        } else {
            super.paint(g);
        }
    }

    protected void drawProjectionBackground(Graphics g) {
        if (g instanceof Graphics2D) {
            this.projection.drawBackground((Graphics2D)g, this.getBckgrnd());
        } else {
            g.setColor(this.getBackground());
            this.projection.drawBackground(g);
        }
    }

    public void paintChildren(Graphics g) {
        this.paintChildren(g, null);
    }

    public void paintChildren(Graphics g, Rectangle clip) {
        g = this.getMapBeanRepaintPolicy().modifyGraphicsForPainting(g);
        if (clip != null) {
            g.setClip(clip);
        } else {
            g.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        this.drawProjectionBackground(g);
        super.paintChildren(g);
        if (this.painters != null) {
            this.painters.paint(g);
        }
        this.paintBorder(g);
    }

    public void paintChildrenWithBorder(Graphics g, boolean drawBorder) {
        this.drawProjectionBackground(g);
        if (drawBorder) {
            this.paintChildren(g);
        } else {
            super.paintChildren(g);
        }
    }

    public synchronized void addPaintListener(PaintListener l) {
        if (this.painters == null) {
            this.painters = new PaintListenerSupport(this);
        }
        this.painters.addPaintListener(l);
    }

    public synchronized void removePaintListener(PaintListener l) {
        if (this.painters == null) {
            return;
        }
        this.painters.removePaintListener(l);
        if (this.painters.size() == 0) {
            this.painters = null;
        }
    }

    public void setLayers(LayerEvent evt) {
        Layer[] layers = evt.getLayers();
        int type = evt.getType();
        if (type == 403) {
            return;
        }
        if (layers == null) {
            System.err.println("MapBean.setLayers(): layers is null!");
            return;
        }
        boolean oldChange = this.getDoContainerChange();
        this.setDoContainerChange(false);
        if (type == 402) {
            if (Debug.debugging("mapbean")) {
                this.debugmsg("Replacing all layers");
            }
            this.removeAll();
            int i = 0;
            while (i < layers.length) {
                if (layers[i] == null) {
                    System.err.println("MapBean.setLayers(): layer " + i + " is null");
                } else {
                    if (Debug.debugging("mapbean")) {
                        this.debugmsg("Adding layer[" + i + "]= " + layers[i].getName());
                    }
                    this.add(layers[i]);
                    layers[i].setVisible(true);
                }
                ++i;
            }
        } else if (type == 400) {
            if (Debug.debugging("mapbean")) {
                this.debugmsg("Adding new layers");
            }
            int i = 0;
            while (i < layers.length) {
                if (Debug.debugging("mapbean")) {
                    this.debugmsg("Adding layer[" + i + "]= " + layers[i].getName());
                }
                this.add(layers[i]);
                layers[i].setVisible(true);
                ++i;
            }
        } else if (type == 401) {
            if (Debug.debugging("mapbean")) {
                this.debugmsg("Removing layers");
            }
            int i = 0;
            while (i < layers.length) {
                if (Debug.debugging("mapbean")) {
                    this.debugmsg("Removing layer[" + i + "]= " + layers[i].getName());
                }
                this.remove(layers[i]);
                ++i;
            }
        }
        if (!this.layerRemovalDelayed) {
            this.purgeAndNotifyRemovedLayers();
        }
        this.setDoContainerChange(oldChange);
        this.repaint();
        this.revalidate();
    }

    public void repaint(Layer layer) {
        this.getMapBeanRepaintPolicy().repaint(layer);
    }

    public void setMapBeanRepaintPolicy(MapBeanRepaintPolicy mbrp) {
        this.repaintPolicy = mbrp;
    }

    public MapBeanRepaintPolicy getMapBeanRepaintPolicy() {
        if (this.repaintPolicy == null) {
            this.repaintPolicy = new StandardMapBeanRepaintPolicy(this);
        }
        return this.repaintPolicy;
    }

    public LatLonPoint getCoordinates(MouseEvent event) {
        return this.getCoordinates(event, null);
    }

    public LatLonPoint getCoordinates(MouseEvent event, LatLonPoint llp) {
        Projection proj = this.getProjection();
        if (proj == null || event == null) {
            return null;
        }
        if (llp == null) {
            return proj.inverse(event.getX(), event.getY());
        }
        return proj.inverse(event.getX(), event.getY(), llp);
    }

    public boolean isBuffered() {
        return false;
    }

    public void setBufferDirty(boolean value) {
    }

    public boolean isBufferDirty() {
        return true;
    }

    public void setLayerRemovalDelayed(boolean set) {
        this.layerRemovalDelayed = set;
    }

    public boolean isLayerRemovalDelayed() {
        return this.layerRemovalDelayed;
    }

    public void showLayerPalettes() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (((Layer)comps[i]).autoPalette) {
                ((Layer)comps[i]).showPalette();
            }
            ++i;
        }
    }

    public void hideLayerPalettes() {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            ((Layer)comps[i]).hidePalette();
            ++i;
        }
    }
}

