/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.NoSuchMatPropException;
import java.io.Serializable;

public class VelocityLayer
implements Cloneable,
Serializable {
    private int myLayerNumber;
    private double topDepth;
    private double botDepth;
    private double topPVelocity;
    private double botPVelocity;
    private double topSVelocity;
    private double botSVelocity;
    private double topDensity = 2.6;
    private double botDensity = 2.6;
    private double topQp = 1000.0;
    private double botQp = 1000.0;
    private double topQs = 2000.0;
    private double botQs = 2000.0;

    public VelocityLayer(int myLayerNumber, double topDepth, double botDepth, double topPVelocity, double botPVelocity, double topSVelocity, double botSVelocity) {
        this(myLayerNumber, topDepth, botDepth, topPVelocity, botPVelocity, topSVelocity, botSVelocity, 2.6, 2.6);
    }

    public VelocityLayer(int myLayerNumber, double topDepth, double botDepth, double topPVelocity, double botPVelocity, double topSVelocity, double botSVelocity, double topDensity, double bottomDensity) {
        this(myLayerNumber, topDepth, botDepth, topPVelocity, botPVelocity, topSVelocity, botSVelocity, topDensity, bottomDensity, 1000.0, 1000.0, 2000.0, 2000.0);
    }

    public VelocityLayer(int myLayerNumber, double topDepth, double botDepth, double topPVelocity, double botPVelocity, double topSVelocity, double botSVelocity, double topDensity, double botDensity, double topQp, double botQp, double topQs, double botQs) {
        if (topPVelocity <= 0.0) {
            throw new IllegalArgumentException("topPVelocity must be positive: " + topPVelocity);
        }
        if (botPVelocity <= 0.0) {
            throw new IllegalArgumentException("botPVelocity must be positive: " + botPVelocity);
        }
        if (topSVelocity < 0.0) {
            throw new IllegalArgumentException("topSVelocity must be nonnegative: " + topSVelocity);
        }
        if (botSVelocity < 0.0) {
            throw new IllegalArgumentException("botSVelocity must be nonnegative: " + botSVelocity);
        }
        this.myLayerNumber = myLayerNumber;
        this.topDepth = topDepth;
        this.botDepth = botDepth;
        this.topPVelocity = topPVelocity;
        this.botPVelocity = botPVelocity;
        this.topSVelocity = topSVelocity;
        this.botSVelocity = botSVelocity;
        this.topDensity = topDensity;
        this.botDensity = botDensity;
        this.topQp = topQp;
        this.botQp = botQp;
        this.topQs = topQs;
        this.botQs = botQs;
    }

    public Object clone() {
        try {
            VelocityLayer newObject = (VelocityLayer)super.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public double evaluateAtBottom(char materialProperty) throws NoSuchMatPropException {
        double answer;
        switch (materialProperty) {
            case 'P': 
            case 'p': {
                answer = this.getBotPVelocity();
                break;
            }
            case 'S': 
            case 's': {
                answer = this.getBotSVelocity();
                break;
            }
            case 'D': 
            case 'R': 
            case 'd': 
            case 'r': {
                answer = this.getBotDensity();
                break;
            }
            default: {
                throw new NoSuchMatPropException(materialProperty);
            }
        }
        return answer;
    }

    public double evaluateAtTop(char materialProperty) throws NoSuchMatPropException {
        double answer;
        switch (materialProperty) {
            case 'P': 
            case 'p': {
                answer = this.getTopPVelocity();
                break;
            }
            case 'S': 
            case 's': {
                answer = this.getTopSVelocity();
                break;
            }
            case 'D': 
            case 'R': 
            case 'd': 
            case 'r': {
                answer = this.getTopDensity();
                break;
            }
            default: {
                throw new NoSuchMatPropException(materialProperty);
            }
        }
        return answer;
    }

    public double evaluateAt(double depth, char materialProperty) throws NoSuchMatPropException {
        double answer;
        switch (materialProperty) {
            case 'P': 
            case 'p': {
                double slope = (this.getBotPVelocity() - this.getTopPVelocity()) / (this.getBotDepth() - this.getTopDepth());
                answer = slope * (depth - this.getTopDepth()) + this.getTopPVelocity();
                break;
            }
            case 'S': 
            case 's': {
                double slope = (this.getBotSVelocity() - this.getTopSVelocity()) / (this.getBotDepth() - this.getTopDepth());
                answer = slope * (depth - this.getTopDepth()) + this.getTopSVelocity();
                break;
            }
            case 'D': 
            case 'R': 
            case 'd': 
            case 'r': {
                double slope = (this.getBotDensity() - this.getTopDensity()) / (this.getBotDepth() - this.getTopDepth());
                answer = slope * (depth - this.getTopDepth()) + this.getTopDensity();
                break;
            }
            default: {
                System.out.println("I don't understand this material property: " + materialProperty + "\nUse one of P p S s R r D d");
                throw new NoSuchMatPropException(materialProperty);
            }
        }
        return answer;
    }

    public String toString() {
        String description = this.myLayerNumber + " " + this.getTopDepth() + " " + this.getBotDepth();
        description = description + " P " + this.getTopPVelocity() + " " + this.getBotPVelocity();
        description = description + " S " + this.getTopSVelocity() + " " + this.getBotSVelocity();
        description = description + " Density " + this.getTopDensity() + " " + this.getBotDensity();
        return description;
    }

    public int getLayerNum() {
        return this.myLayerNumber;
    }

    public void setTopDepth(double topDepth) {
        this.topDepth = topDepth;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public void setBotDepth(double botDepth) {
        this.botDepth = botDepth;
    }

    public double getBotDepth() {
        return this.botDepth;
    }

    public void setTopPVelocity(double topPVelocity) {
        this.topPVelocity = topPVelocity;
    }

    public double getTopPVelocity() {
        return this.topPVelocity;
    }

    public void setBotPVelocity(double botPVelocity) {
        this.botPVelocity = botPVelocity;
    }

    public double getBotPVelocity() {
        return this.botPVelocity;
    }

    public void setTopSVelocity(double topSVelocity) {
        this.topSVelocity = topSVelocity;
    }

    public double getTopSVelocity() {
        return this.topSVelocity;
    }

    public void setBotSVelocity(double botSVelocity) {
        this.botSVelocity = botSVelocity;
    }

    public double getBotSVelocity() {
        return this.botSVelocity;
    }

    public void setTopDensity(double topDensity) {
        this.topDensity = topDensity;
    }

    public double getTopDensity() {
        return this.topDensity;
    }

    public void setBotDensity(double botDensity) {
        this.botDensity = botDensity;
    }

    public double getBotDensity() {
        return this.botDensity;
    }

    public void setTopQp(double topQp) {
        this.topQp = topQp;
    }

    public double getTopQp() {
        return this.topQp;
    }

    public void setBotQp(double botQp) {
        this.botQp = botQp;
    }

    public double getBotQp() {
        return this.botQp;
    }

    public void setTopQs(double topQs) {
        this.topQs = topQs;
    }

    public double getTopQs() {
        return this.topQs;
    }

    public void setBotQs(double botQs) {
        this.botQs = botQs;
    }

    public double getBotQs() {
        return this.botQs;
    }

    public double getThickness() {
        return this.getBotDepth() - this.getTopDepth();
    }
}

