/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;

public class Theta {
    protected double radians;
    protected double[] thetaAtX;
    protected double[] rayParams;

    public Theta(SeismicPhase phase, double radians) {
        this.radians = radians;
        int minRayParamIndex = phase.getMinRayParamIndex();
        int maxRayParamIndex = phase.getMaxRayParamIndex();
        this.rayParams = phase.getRayParams();
        this.thetaAtX = phase.getTau();
        TauModel tMod = phase.getTauModel();
        for (int i = 0; i < this.thetaAtX.length; ++i) {
            int n = i;
            this.thetaAtX[n] = this.thetaAtX[n] + this.rayParams[i] * radians;
        }
    }

    public double getRadians() {
        return this.radians;
    }

    public double getMaxRayParam() {
        return this.rayParams[0];
    }

    public double getStepRayParam(double rayParam, double timeStep) {
        double thetaStart = this.getTheta(rayParam);
        boolean found = false;
        int i = this.getThetaIndex(rayParam);
        while (Math.abs(this.thetaAtX[i + 1] - thetaStart) <= timeStep) {
            ++i;
        }
        double newTheta = thetaStart < this.thetaAtX[i + 1] ? thetaStart + timeStep : thetaStart - timeStep;
        return Theta.linInterp(this.thetaAtX[i], this.thetaAtX[i + 1], this.rayParams[i], this.rayParams[i + 1], newTheta);
    }

    public double getTheta(double rayParam) {
        if (rayParam > this.rayParams[0] || rayParam < this.rayParams[this.rayParams.length - 1]) {
            throw new ArrayIndexOutOfBoundsException(rayParam + " not in range " + this.rayParams[0] + " to " + this.rayParams[this.rayParams.length - 1]);
        }
        int currentNum = this.getThetaIndex(rayParam);
        double thetaStart = Theta.linInterp(this.rayParams[currentNum], this.rayParams[currentNum + 1], this.thetaAtX[currentNum], this.thetaAtX[currentNum + 1], rayParam);
        return thetaStart;
    }

    protected int getThetaIndex(double rayParam) {
        int tooSmallNum = 0;
        int tooLargeNum = this.rayParams.length - 1;
        int currentNum = 0;
        boolean found = false;
        while (!found) {
            currentNum = (int)Math.floor((float)(tooSmallNum + tooLargeNum) / 2.0f);
            if (this.rayParams[currentNum] >= rayParam && this.rayParams[currentNum + 1] < rayParam) {
                found = true;
                continue;
            }
            if (this.rayParams[currentNum] > rayParam) {
                tooSmallNum = currentNum;
                continue;
            }
            if (!(this.rayParams[currentNum] <= rayParam)) continue;
            tooLargeNum = currentNum;
        }
        return currentNum;
    }

    public static double linInterp(double xa, double xb, double ya, double yb, double x) {
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }
}

