/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.DistPlot;
import edu.sc.seis.TauP.MainFrame;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SlownessPlot;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Create;
import edu.sc.seis.TauP.TauPlot;
import edu.sc.seis.TauP.TimeDistPlot;
import edu.sc.seis.TauP.TimePlot;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.VelocityPlot;
import java.applet.Applet;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

public class TauP_WCreate
extends Applet
implements ActionListener {
    VelocityPlot velocityPlot;
    SlownessPlot slownessPlot;
    TauPlot tauPPlot;
    DistPlot distPlot;
    TimePlot timePlot;
    TimeDistPlot timeDistPlot;
    String modelFilename = "iasp91.tvel";
    String directory = ".";
    TauP_Create tauPCreate = new TauP_Create();
    Panel cardPanel = new Panel();
    CardLayout cards = new CardLayout();
    Button nextButton;
    Button previousButton;
    Button quitButton;

    @Override
    public void init() {
        this.setBackground(Color.white);
        this.setLayout(new FlowLayout());
        this.cardPanel.setLayout(this.cards);
        this.add(this.cardPanel);
        this.previousButton = new Button("Previous");
        this.add(this.previousButton);
        this.previousButton.addActionListener(this);
        this.nextButton = new Button("Next");
        this.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.quitButton = new Button("Quit");
        this.add(this.quitButton);
        this.quitButton.addActionListener(this);
        this.velocityPlot = new VelocityPlot(this);
        this.velocityPlot.DEBUG = false;
        this.cardPanel.add("Velocity", this.velocityPlot);
        this.slownessPlot = new SlownessPlot(this);
        this.slownessPlot.DEBUG = false;
        this.cardPanel.add("Slowness", this.slownessPlot);
        this.tauPPlot = new TauPlot(this);
        this.tauPPlot.DEBUG = false;
        this.cardPanel.add("Tau", this.tauPPlot);
        this.distPlot = new DistPlot(this);
        this.distPlot.DEBUG = false;
        this.cardPanel.add("Dist", this.distPlot);
        this.timePlot = new TimePlot(this);
        this.timePlot.DEBUG = false;
        this.cardPanel.add("Time", this.timePlot);
        this.timeDistPlot = new TimeDistPlot(this);
        this.timeDistPlot.DEBUG = false;
        this.cardPanel.add("TimeDist", this.timeDistPlot);
        this.validate();
    }

    @Override
    public void start() {
        this.tauPCreate.modelFilename = this.modelFilename;
        this.tauPCreate.directory = this.directory;
        try {
            VelocityModel vMod = this.tauPCreate.loadVMod();
            TauModel tMod = this.tauPCreate.createTauModel(vMod);
            this.velocityPlot.plot(vMod, 'P', 'S');
            this.slownessPlot.plot(tMod.getSlownessModel(), true);
            this.tauPPlot.plot(tMod, true);
            this.timePlot.plot(tMod, true);
            this.distPlot.plot(tMod, true);
            this.timeDistPlot.plot(tMod, true);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Can't happen", e);
        }
        catch (VelocityModelException e) {
            throw new RuntimeException("Can't happen", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't happen", e);
        }
        catch (SlownessModelException e) {
            throw new RuntimeException("Can't happen", e);
        }
        catch (TauModelException e) {
            throw new RuntimeException("Can't happen", e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String arg = action.getActionCommand();
        if ("Previous".equals(arg)) {
            this.cards.previous(this.cardPanel);
        } else if ("Next".equals(arg)) {
            this.cards.next(this.cardPanel);
        } else if ("Quit".equals(arg)) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage java TauP_WCreate velocitymodel.tvel [wavetype]");
            System.exit(1);
        }
        MainFrame f = new MainFrame("TauP_WCreate");
        TauP_WCreate tauPWCreate = new TauP_WCreate();
        int j = args[0].lastIndexOf(System.getProperty("file.separator"));
        if (j == -1) {
            tauPWCreate.modelFilename = args[0];
            tauPWCreate.directory = ".";
        } else {
            tauPWCreate.modelFilename = args[0].substring(j + 1);
            tauPWCreate.directory = args[0].substring(0, j);
        }
        tauPWCreate.init();
        f.add("Center", tauPWCreate);
        f.pack();
        f.show();
        tauPWCreate.start();
    }
}

