/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TauP_Time {
    public static boolean DEBUG = false;
    public boolean verbose = false;
    public static boolean expert = false;
    protected String modelName = "iasp91";
    protected TauModel tMod;
    protected transient TauModel tModDepth;
    private List<SeismicPhase> phases = null;
    protected List<PhaseName> phaseNames = new ArrayList<PhaseName>();
    protected double depth = 0.0;
    protected double receiverDepth = 0.0;
    protected double degrees = Double.MAX_VALUE;
    protected double azimuth = Double.MAX_VALUE;
    protected double backAzimuth = Double.MAX_VALUE;
    protected double takeoffAngle = Double.MAX_VALUE;
    protected double stationLat = Double.MAX_VALUE;
    protected double stationLon = Double.MAX_VALUE;
    protected double eventLat = Double.MAX_VALUE;
    protected double eventLon = Double.MAX_VALUE;
    protected List<Arrival> arrivals = new ArrayList<Arrival>();
    protected boolean GUI = false;
    protected boolean onlyPrintRayP = false;
    protected boolean onlyPrintTime = false;
    protected String relativePhaseName = "";
    protected Arrival relativeArrival;
    protected String outFileBase = "";
    protected PrintWriter writer;
    protected Properties toolProps;
    protected Outputs outForms;

    protected TauP_Time() {
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
        Outputs.configure(this.toolProps);
    }

    public TauP_Time(TauModel tMod) throws TauModelException {
        this();
        this.tMod = tMod;
        this.tModDepth = tMod;
        this.modelName = tMod.getModelName();
    }

    public TauP_Time(String modelName) throws TauModelException {
        this();
        try {
            this.loadTauModel(modelName);
        }
        catch (FileNotFoundException e) {
            throw new TauModelException("FileNotFoundException:" + e.getMessage(), e);
        }
        catch (InvalidClassException e) {
            throw new TauModelException("InvalidClassException:" + e.getMessage(), e);
        }
        catch (StreamCorruptedException e) {
            throw new TauModelException("StreamCorruptedException:" + e.getMessage(), e);
        }
        catch (OptionalDataException e) {
            throw new TauModelException("OptionalDataException:" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TauModelException("IOException:" + e.getMessage(), e);
        }
    }

    public String[] getPhaseNames() {
        String[] phases = new String[this.phaseNames.size()];
        for (int i = 0; i < this.phaseNames.size(); ++i) {
            phases[i] = this.phaseNames.get(i).getName();
        }
        return phases;
    }

    public String getPhaseNameString() {
        if (this.getNumPhases() == 0) {
            return "";
        }
        String phases = this.phaseNames.get(0).getName();
        for (int i = 1; i < this.getNumPhases(); ++i) {
            phases = phases + "," + this.phaseNames.get(i).getName();
        }
        return phases;
    }

    public void setPhaseNames(String[] phaseNames) throws TauModelException {
        this.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.appendPhaseName(phaseNames[i]);
        }
    }

    public void setPhaseNames(PhaseName[] phaseNames) {
        this.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.phaseNames.add(phaseNames[i]);
        }
    }

    public static List<String> getPhaseNames(String phaseName) {
        ArrayList<String> names = new ArrayList<String>();
        if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttall")) {
            if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("p");
                names.add("P");
                names.add("Pn");
                names.add("Pdiff");
                names.add("PKP");
                names.add("PKiKP");
                names.add("PKIKP");
            }
            if (phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("s");
                names.add("S");
                names.add("Sn");
                names.add("Sdiff");
                names.add("SKS");
                names.add("SKIKS");
            }
            if (phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("PcP");
                names.add("pP");
                names.add("pPdiff");
                names.add("pPKP");
                names.add("pPKIKP");
                names.add("pPKiKP");
                names.add("sP");
                names.add("sPdiff");
                names.add("sPKP");
                names.add("sPKIKP");
                names.add("sPKiKP");
            }
            if (phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("sS");
                names.add("sSdiff");
                names.add("sSKS");
                names.add("sSKIKS");
                names.add("ScS");
                names.add("pS");
                names.add("pSdiff");
                names.add("pSKS");
                names.add("pSKIKS");
            }
            if (phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                names.add("ScP");
                names.add("SKP");
                names.add("SKIKP");
                names.add("PKKP");
                names.add("PKIKKIKP");
                names.add("SKKP");
                names.add("SKIKKIKP");
                names.add("PP");
                names.add("PKPPKP");
                names.add("PKIKPPKIKP");
            }
            if (phaseName.equalsIgnoreCase("ttall")) {
                names.add("SKiKP");
                names.add("PP");
                names.add("ScS");
                names.add("PcS");
                names.add("PKS");
                names.add("PKIKS");
                names.add("PKKS");
                names.add("PKIKKIKS");
                names.add("SKKS");
                names.add("SKIKKIKS");
                names.add("SKSSKS");
                names.add("SKIKSSKIKS");
                names.add("SS");
                names.add("SP");
                names.add("PS");
            }
        } else {
            names.add(phaseName);
        }
        return names;
    }

    public synchronized void appendPhaseName(String phaseName) throws TauModelException {
        Iterator<String> it = TauP_Time.getPhaseNames(phaseName).iterator();
        while (it.hasNext()) {
            this.appendPhaseName(new PhaseName(it.next()));
        }
    }

    public synchronized void appendPhaseName(PhaseName phaseName) {
        boolean unique = true;
        if (phaseName.name == null || phaseName.name.length() == 0) {
            return;
        }
        for (int i = 0; i < this.phaseNames.size(); ++i) {
            if (!this.phaseNames.get(i).equals(phaseName)) continue;
            unique = false;
            return;
        }
        if (unique) {
            this.phaseNames.add(phaseName);
        }
    }

    public int getNumPhases() {
        return this.phaseNames.size();
    }

    public void clearPhaseNames() {
        this.phases = null;
        this.phaseNames.clear();
    }

    public double getSourceDepth() {
        return Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
    }

    public void setSourceDepth(double depth) {
        this.depth = depth;
        this.toolProps.put("taup.source.depth", Double.toString(depth));
        this.phases = null;
    }

    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    public void setReceiverDepth(double receiverDepth) {
        if (this.receiverDepth != receiverDepth) {
            this.phases = null;
        }
        this.receiverDepth = receiverDepth;
    }

    public String getTauModelName() {
        return this.modelName;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void setTauModel(TauModel tMod) {
        this.phases = null;
        this.tMod = tMod;
        this.tModDepth = tMod;
        this.modelName = tMod.getModelName();
        this.toolProps.put("taup.model.name", this.modelName);
    }

    public void loadTauModel(String modelName) throws FileNotFoundException, InvalidClassException, IOException, StreamCorruptedException, OptionalDataException, TauModelException {
        this.modelName = modelName;
        this.readTauModel();
        this.modelName = this.tMod.getModelName();
    }

    public double[] getDisconDepths() {
        return this.tMod.getVelocityModel().getDisconDepths();
    }

    public void clearArrivals() {
        this.arrivals = new ArrayList<Arrival>();
    }

    public int getNumArrivals() {
        return this.arrivals.size();
    }

    public Arrival getArrival(int i) {
        return this.arrivals.get(i);
    }

    public List<Arrival> getArrivals() {
        return Collections.unmodifiableList(this.arrivals);
    }

    public List<SeismicPhase> getSeismicPhases() {
        if (this.phases == null) {
            this.recalcPhases();
        }
        return Collections.unmodifiableList(this.phases);
    }

    protected void readTauModel() throws TauModelException {
        TauModel tModLoad = TauModelLoader.load(this.modelName, this.toolProps.getProperty("taup.model.path"), this.verbose);
        if (tModLoad == null) {
            throw new TauModelException("Unable to load " + this.modelName);
        }
        this.setTauModel(tModLoad);
    }

    protected void readPhaseFile(String filename) throws IOException {
        FileReader fileIn = new FileReader(filename);
        StreamTokenizer tokenIn = new StreamTokenizer(fileIn);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.wordChars(94, 94);
        tokenIn.wordChars(48, 57);
        tokenIn.wordChars(46, 46);
        tokenIn.wordChars(91, 91);
        tokenIn.wordChars(93, 93);
        while (tokenIn.nextToken() != -1) {
            if (tokenIn.sval != null) {
                this.parsePhaseList(tokenIn.sval);
                continue;
            }
            if (!DEBUG) continue;
            Alert.info("Token.sval was null! nval=" + tokenIn.nval);
        }
    }

    public void parsePhaseList(String phaseList) {
        String phaseEntry = "";
        phaseList = phaseList.trim();
        phaseList = phaseList.replace(' ', ',');
        if ((phaseList = phaseList.replaceAll(",,+", ",")).startsWith(",")) {
            if (phaseList.length() > 1) {
                phaseList = phaseList.substring(1);
            } else {
                return;
            }
        }
        if (phaseList.charAt(phaseList.length() - 1) == ',') {
            phaseList = phaseList.substring(0, phaseList.length() - 1);
        }
        String[] namesInList = phaseList.split(",");
        for (int i = 0; i < namesInList.length; ++i) {
            String[] phaseAndHeader = namesInList[i].split("-");
            try {
                if (phaseAndHeader.length == 1) {
                    this.appendPhaseName(phaseAndHeader[0]);
                    continue;
                }
                if (phaseAndHeader[1].length() == 1 && Character.isDigit(phaseAndHeader[1].charAt(0))) {
                    this.appendPhaseName(new PhaseName(phaseAndHeader[0], Integer.valueOf(phaseAndHeader[1])));
                    continue;
                }
                if (phaseAndHeader[1].length() == 1 && phaseEntry.charAt(phaseEntry.length() - 1) == 'a') {
                    this.appendPhaseName(new PhaseName(phaseAndHeader[0], 10));
                    continue;
                }
                Alert.warning("Problem with phase=" + phaseEntry, "Skipping this phase.");
                continue;
            }
            catch (TauModelException e) {
                Alert.warning("Problem with phase=" + phaseEntry + " " + e.getMessage(), "Skipping this phase: ");
                if (!this.verbose && !DEBUG) continue;
                e.printStackTrace();
            }
        }
    }

    public static List<Double> parseDegreeList(String degList) {
        String[] split = degList.split(",");
        ArrayList<Double> degreesFound = new ArrayList<Double>(split.length);
        for (int i = 0; i < split.length; ++i) {
            degreesFound.add(Double.parseDouble(split[i]));
        }
        return degreesFound;
    }

    public static boolean dashEquals(String argName, String arg) {
        return arg.equalsIgnoreCase("-" + argName) || arg.equalsIgnoreCase("--" + argName);
    }

    protected String[] parseCmdLineArgs(String[] args) throws IOException {
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        boolean cmdLineArgPhase = false;
        boolean cmdLineArgPhaseFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_Time.dashEquals("help", args[i])) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (TauP_Time.dashEquals("version", args[i])) {
                Alert.info(BuildVersion.getDetailedVersion());
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            if (TauP_Time.dashEquals("verbose", args[i])) {
                this.verbose = true;
                continue;
            }
            if (TauP_Time.dashEquals("expert", args[i])) {
                expert = true;
                continue;
            }
            if (TauP_Time.dashEquals("debug", args[i])) {
                this.verbose = true;
                DEBUG = true;
                continue;
            }
            if (TauP_Time.dashEquals("gui", args[i])) {
                this.GUI = true;
                continue;
            }
            if (TauP_Time.dashEquals("rayp", args[i])) {
                this.onlyPrintRayP = true;
                this.onlyPrintTime = false;
                continue;
            }
            if (TauP_Time.dashEquals("time", args[i])) {
                this.onlyPrintTime = true;
                this.onlyPrintRayP = false;
                continue;
            }
            if (i < args.length - 1) {
                if (TauP_Time.dashEquals("mod", args[i]) || TauP_Time.dashEquals("model", args[i])) {
                    this.toolProps.put("taup.model.name", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    this.toolProps.put("taup.source.depth", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("--stadepth")) {
                    this.setReceiverDepth(Double.parseDouble(args[i + 1]));
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("deg", args[i])) {
                    this.degrees = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("km", args[i])) {
                    this.degrees = Double.valueOf(args[i + 1]) / 6371.0 * 180.0 / Math.PI;
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("az", args[i])) {
                    this.azimuth = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("baz", args[i])) {
                    this.backAzimuth = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("takeoff", args[i])) {
                    this.takeoffAngle = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-o")) {
                    this.outFileBase = args[i + 1];
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("rel", args[i])) {
                    this.relativePhaseName = args[i + 1];
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("ph", args[i])) {
                    if (cmdLineArgPhase) {
                        this.toolProps.put("taup.phase.list", this.toolProps.getProperty("taup.phase.list", "") + "," + args[i + 1]);
                    } else {
                        this.toolProps.put("taup.phase.list", args[i + 1]);
                    }
                    cmdLineArgPhase = true;
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("pf", args[i])) {
                    cmdLineArgPhaseFile = true;
                    this.toolProps.put("taup.phase.file", args[i + 1]);
                    ++i;
                    continue;
                }
                if (i < args.length - 2) {
                    if (args[i].equalsIgnoreCase("-sta") || args[i].equalsIgnoreCase("-station")) {
                        this.stationLat = Double.valueOf(args[i + 1]);
                        this.stationLon = Double.valueOf(args[i + 2]);
                        i += 2;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-evt") || args[i].equalsIgnoreCase("-event")) {
                        this.eventLat = Double.valueOf(args[i + 1]);
                        this.eventLon = Double.valueOf(args[i + 2]);
                        i += 2;
                        continue;
                    }
                    noComprendoArgs[numNoComprendoArgs++] = args[i];
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (cmdLineArgPhaseFile || cmdLineArgPhase) {
            if (cmdLineArgPhaseFile && !cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.list");
            }
            if (!cmdLineArgPhaseFile && cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.file");
            }
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public synchronized void sortArrivals() {
        Collections.sort(this.arrivals, new Comparator<Arrival>(){

            @Override
            public int compare(Arrival o1, Arrival o2) {
                return Double.compare(o1.getTime(), o2.getTime());
            }
        });
    }

    public void calculate(double degrees) throws TauModelException {
        this.calcTime(degrees);
        if (this.relativePhaseName != "") {
            ArrayList<SeismicPhase> relPhases = new ArrayList<SeismicPhase>();
            List<String> splitNames = TauP_Time.getPhaseNames(this.relativePhaseName);
            for (String sName : splitNames) {
                SeismicPhase relPhase = new SeismicPhase(sName, this.tModDepth);
                relPhases.add(relPhase);
            }
            this.relativeArrival = SeismicPhase.getEarliestArrival(relPhases, degrees);
        }
    }

    public void calcTime(double degrees) throws TauModelException {
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth());
        this.clearArrivals();
        this.degrees = degrees;
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            List<Arrival> phaseArrivals = phase.calcTime(degrees);
            for (Arrival arrival : phaseArrivals) {
                this.arrivals.add(arrival);
            }
        }
        this.sortArrivals();
    }

    public void calcTakeoff(double takeoffAngle) throws TauModelException {
        this.stationLat = Double.MAX_VALUE;
        this.stationLon = Double.MAX_VALUE;
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth());
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            if (phase.getDownGoing()[0] != takeoffAngle <= 90.0) continue;
            double rayParam = phase.calcRayParamForTakeoffAngle(takeoffAngle);
            try {
                Arrival phaseArrival = phase.shootRay(rayParam);
                this.arrivals.add(phaseArrival);
                continue;
            }
            catch (NoSuchLayerException e) {
                Alert.warning("NoSuchLayerException", e.getMessage());
                continue;
            }
            catch (SlownessModelException e) {
                Alert.warning("SlownessModelException", e.getMessage());
            }
        }
        this.sortArrivals();
    }

    @Deprecated
    public void depthCorrect(double depth) throws TauModelException {
        this.depthCorrect(depth, this.getReceiverDepth());
    }

    public void depthCorrect(double depth, double receiverDepth) throws TauModelException {
        if (this.tModDepth == null || this.tModDepth.getSourceDepth() != depth) {
            this.setReceiverDepth(receiverDepth);
            this.tModDepth = this.tMod.depthCorrect(depth);
            this.clearArrivals();
            this.phases = null;
        }
        if (receiverDepth != this.getReceiverDepth()) {
            this.tModDepth = this.tModDepth.splitBranch(receiverDepth);
            this.clearArrivals();
            this.phases = null;
        }
        this.setSourceDepth(depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void recalcPhases() {
        ArrayList<SeismicPhase> newPhases = new ArrayList<SeismicPhase>();
        for (int phaseNameNum = 0; phaseNameNum < this.phaseNames.size(); ++phaseNameNum) {
            String tempPhaseName = this.phaseNames.get(phaseNameNum).getName();
            boolean alreadyAdded = false;
            if (alreadyAdded) continue;
            try {
                SeismicPhase seismicPhase = new SeismicPhase(tempPhaseName, this.tModDepth, this.getReceiverDepth());
                newPhases.add(seismicPhase);
                if (!this.verbose) continue;
                Alert.info(seismicPhase.toString());
                continue;
            }
            catch (TauModelException e) {
                Alert.warning("Error with phase=" + tempPhaseName, e.getMessage() + "\nSkipping this phase");
                if (!this.verbose && !DEBUG) continue;
                e.printStackTrace();
                continue;
            }
            finally {
                if (this.verbose) {
                    Alert.info("-----------------");
                }
            }
        }
        this.phases = newPhases;
    }

    public void printResult(PrintWriter out) throws IOException {
        int maxNameLength = 5;
        int maxPuristNameLength = 5;
        for (int j = 0; j < this.arrivals.size(); ++j) {
            if (this.arrivals.get(j).getName().length() > maxNameLength) {
                maxNameLength = this.arrivals.get(j).getName().length();
            }
            if (this.arrivals.get(j).getPuristName().length() <= maxPuristNameLength) continue;
            maxPuristNameLength = this.arrivals.get(j).getPuristName().length();
        }
        Format phaseFormat = new Format("%-" + maxNameLength + "s");
        Format phasePuristFormat = new Format("%-" + maxPuristNameLength + "s");
        if (!this.onlyPrintRayP && !this.onlyPrintTime) {
            String modelLine = "\nModel: " + this.modelName;
            if (this.getReceiverDepth() != 0.0) {
                modelLine = modelLine + "  Receiver Depth: " + this.getReceiverDepth() + " km";
            }
            out.println(modelLine);
            String lineOne = "Distance   Depth   " + phaseFormat.form("Phase") + "   Travel    Ray Param  Takeoff  Incident  Purist    Purist";
            String lineTwo = "  (deg)     (km)   " + phaseFormat.form("Name ") + "   Time (s)  p (s/deg)   (deg)    (deg)   Distance   Name ";
            if (this.relativePhaseName != "") {
                lineOne = lineOne + " Relative to";
                for (int s = 0; s < (11 - this.relativePhaseName.length()) / 2; ++s) {
                    lineTwo = lineTwo + " ";
                }
                lineTwo = lineTwo + "  " + phaseFormat.form(this.relativePhaseName);
            }
            out.println(lineOne);
            out.println(lineTwo);
            for (int i = 0; i < lineOne.length(); ++i) {
                out.write("-");
            }
            out.write("\n");
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = this.arrivals.get(j);
                out.print(Outputs.formatDistance(currArrival.getModuloDistDeg()) + Outputs.formatDepth(this.depth) + "   ");
                out.print(phaseFormat.form(currArrival.getName()));
                out.print("  " + Outputs.formatTime(currArrival.getTime()) + "  " + Outputs.formatRayParam(Math.PI / 180 * currArrival.getRayParam()) + "  ");
                out.print(Outputs.formatDistance(currArrival.getTakeoffAngle()) + " ");
                out.print(Outputs.formatDistance(currArrival.getIncidentAngle()) + " ");
                out.print(Outputs.formatDistance(currArrival.getDistDeg()));
                if (currArrival.getName().equals(currArrival.getPuristName())) {
                    out.print("   = ");
                } else {
                    out.print("   * ");
                }
                out.print(phasePuristFormat.form(currArrival.getPuristName()));
                if (this.relativePhaseName != "") {
                    out.print(Outputs.formatTime(currArrival.getTime() - this.relativeArrival.getTime()));
                }
                out.println();
            }
        } else if (this.onlyPrintTime) {
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = this.arrivals.get(j);
                out.print(String.valueOf((float)currArrival.getTime()) + " ");
            }
            out.println();
        } else if (this.onlyPrintRayP) {
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = this.arrivals.get(j);
                out.write(String.valueOf((float)(Math.PI / 180 * currArrival.getRayParam())) + " ");
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public void init() throws IOException {
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning("Caught IOException while attempting to reading phase file " + this.toolProps.getProperty("taup.phase.file"), e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS"));
            }
        }
        this.depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null || this.tMod.getVelocityModel().getModelName() != this.toolProps.getProperty("taup.model.name", "iasp91")) {
            this.modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                if (ee.getCause() instanceof InvalidClassException) {
                    Alert.error("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create.");
                } else {
                    Alert.error("Caught TauModelException", ee.getMessage());
                }
                throw new RuntimeException(ee);
            }
        }
    }

    public String getOutFileBase() {
        return this.outFileBase;
    }

    public void setOutFileBase(String outFileBase) {
        this.outFileBase = outFileBase;
    }

    public String getOutFileExtension() {
        return "gmt";
    }

    public String getOutFile() {
        if (this.getOutFileBase() == null || this.getOutFileBase().length() == 0 || this.getOutFileBase().equals("stdout")) {
            return "stdout";
        }
        if (this.getOutFileExtension() == null || this.getOutFileExtension().length() == 0) {
            return this.getOutFileBase();
        }
        return this.getOutFileBase() + "." + this.getOutFileExtension();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = !this.getOutFile().equals("stdout") ? new PrintWriter(new BufferedWriter(new FileWriter(this.getOutFile()))) : new PrintWriter(new OutputStreamWriter(System.out));
            this.printScriptBeginning(this.writer);
        }
        return this.writer;
    }

    public void printScriptBeginning(PrintWriter out) throws IOException {
    }

    public void printHelp() {
        Alert.info("Enter:\nh for new depth\nr to recalculate\np to append phases, \nc to clear phases\nl to list phases\ns for new station lat lon\ne for new event lat lon\na for new azimuth\nb for new back azimuth\nt for takeoff angle\nm for new model or \nq to quit.\n");
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws IOException, TauModelException, TauPException {
        block76: {
            block75: {
                if (this.degrees == 1.7976931348623157E308 && this.takeoffAngle == 1.7976931348623157E308 && (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308 || this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308)) break block75;
                if (this.takeoffAngle != 1.7976931348623157E308) {
                    this.calcTakeoff(this.takeoffAngle);
                } else {
                    if (this.degrees == 1.7976931348623157E308) {
                        this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                        this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                        this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                    }
                    this.calculate(this.degrees);
                }
                this.printResult(this.getWriter());
                break block76;
            }
            prevTime = 0L;
            readMode = 100;
            tempDepth = this.depth;
            this.setSourceDepth(this.depth);
            tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            tokenIn.wordChars(44, 44);
            tokenIn.wordChars(95, 95);
            tokenIn.wordChars(94, 94);
            tokenIn.ordinaryChar(47);
            tokenIn.wordChars(47, 47);
            tokenIn.commentChar(35);
            this.printHelp();
            do {
                switch (readMode) {
                    case 104: {
                        System.out.print("Enter Depth: ");
                        tokenIn.nextToken();
                        tempDepth = tokenIn.nval;
                        if (tempDepth < 0.0 || tempDepth > this.tMod.getRadiusOfEarth()) {
                            Alert.warning("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().", "depth = " + tempDepth + " getRadiusOfEarth= " + this.tMod.getRadiusOfEarth());
                            break;
                        }
                        prevTime = System.currentTimeMillis();
                        this.setSourceDepth(tempDepth);
                        currTime = System.currentTimeMillis();
                        if (this.verbose) {
                            Alert.info("depthCorrect time=" + (currTime - prevTime));
                        }
                        readMode = 100;
                        break;
                    }
                    case 100: {
                        System.out.print("Enter Distance or Option [hrpclseabmqt]: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.degrees = tokenIn.nval;
                            if (TauP_Time.DEBUG) {
                                Alert.info("degrees=" + this.degrees);
                            }
                            this.calculate(this.degrees);
                            this.printResult(this.getWriter());
                            break;
                        }
                        if (tokenIn.ttype == -1 || tokenIn.ttype == -3 && (tokenIn.sval.equalsIgnoreCase("q") || tokenIn.sval.equalsIgnoreCase("quit") || tokenIn.sval.equalsIgnoreCase("exit") || tokenIn.sval.equalsIgnoreCase("bye"))) {
                            readMode = 113;
                            break;
                        }
                        if (tokenIn.ttype == -3) {
                            if (tokenIn.sval.equalsIgnoreCase("l")) {
                                readMode = 108;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("c")) {
                                readMode = 99;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("s")) {
                                readMode = 115;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("e")) {
                                readMode = 101;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("a")) {
                                readMode = 97;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("b")) {
                                readMode = 98;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("r")) {
                                readMode = 114;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("p")) {
                                readMode = 112;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("m")) {
                                readMode = 109;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("h")) {
                                readMode = 104;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("x")) {
                                readMode = 120;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("t")) {
                                readMode = 116;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("?")) {
                                this.printHelp();
                                break;
                            }
                            Alert.warning("I don't understand this option", tokenIn.sval);
                            this.printHelp();
                            break;
                        }
                        this.printHelp();
                        break;
                    }
                    case 114: {
                        if (this.degrees != 1.7976931348623157E308) {
                            this.calculate(this.degrees);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 112: {
                        System.out.print("Enter phases (ie P,p,PcP,S): ");
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.ordinaryChar(46);
                        tokenIn.ordinaryChar(45);
                        tokenIn.wordChars(48, 57);
                        tokenIn.wordChars(46, 46);
                        tokenIn.wordChars(45, 45);
                        tokenIn.ordinaryChar(32);
                        tokenIn.wordChars(32, 32);
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -3) {
                            this.parsePhaseList(tokenIn.sval);
                            this.recalcPhases();
                        } else {
                            Alert.warning("Input phases not recognized.", "Please retry.");
                        }
                        tokenIn.parseNumbers();
                        tokenIn.ordinaryChar(32);
                        tokenIn.whitespaceChars(32, 32);
                        readMode = 100;
                        break;
                    }
                    case 108: {
                        numPhases = this.phaseNames.size();
                        output = numPhases + " phases.";
                        Alert.info(output);
                        output = "";
                        for (i = 0; i < numPhases; ++i) {
                            output = output + this.phaseNames.get(i).getName();
                            if (i >= numPhases - 1) continue;
                            output = output + ",";
                        }
                        Alert.info(output);
                        readMode = 100;
                        break;
                    }
                    case 99: {
                        this.clearPhaseNames();
                        readMode = 112;
                        break;
                    }
                    case 97: {
                        System.out.print("Enter azimuth: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.azimuth = tokenIn.nval;
                            this.stationLat = 1.7976931348623157E308;
                            this.stationLon = 1.7976931348623157E308;
                            if (TauP_Time.DEBUG) {
                                Alert.info("azimuth=" + this.azimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead.");
                            this.printHelp();
                            break;
                        }
                        if (this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308) {
                            readMode = 101;
                        } else if (this.degrees == 1.7976931348623157E308) {
                            readMode = 100;
                        } else {
                            this.calculate(this.degrees);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 98: {
                        System.out.print("Enter back azimuth: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.backAzimuth = tokenIn.nval;
                            this.eventLat = 1.7976931348623157E308;
                            this.eventLon = 1.7976931348623157E308;
                            if (TauP_Time.DEBUG) {
                                Alert.info("backAzimuth=" + this.backAzimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead");
                            this.printHelp();
                            break;
                        }
                        if (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308) {
                            readMode = 115;
                        } else if (this.degrees == 1.7976931348623157E308) {
                            readMode = 100;
                        } else {
                            this.calculate(this.degrees);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 101: {
                        System.out.print("Enter event lat and lon: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.eventLat = tokenIn.nval;
                            if (TauP_Time.DEBUG) {
                                Alert.info("eventLat=" + this.eventLat);
                            }
                            tokenIn.nextToken();
                            if (tokenIn.ttype == -2) {
                                this.eventLon = tokenIn.nval;
                                if (TauP_Time.DEBUG) {
                                    Alert.info("eventLon=" + this.eventLon);
                                }
                            } else {
                                this.printHelp();
                            }
                        } else {
                            this.printHelp();
                        }
                        if (this.stationLat != 1.7976931348623157E308 && this.stationLon != 1.7976931348623157E308) {
                            this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.calculate(this.degrees);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 115: {
                        System.out.print("Enter station lat and lon: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype != -2) ** GOTO lbl238
                        this.stationLat = tokenIn.nval;
                        if (TauP_Time.DEBUG) {
                            Alert.info("stationLat=" + this.stationLat);
                        }
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.stationLon = tokenIn.nval;
                            if (TauP_Time.DEBUG) {
                                Alert.info("stationLon=" + this.stationLon);
                            }
                        } else {
                            this.printHelp();
                            break;
lbl238:
                            // 1 sources

                            this.printHelp();
                            break;
                        }
                        if (this.eventLat != 1.7976931348623157E308 && this.eventLon != 1.7976931348623157E308) {
                            this.degrees = SphericalCoords.distance(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
                            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
                            this.calculate(this.degrees);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 109: {
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.wordChars(48, 57);
                        tokenIn.ordinaryChars(46, 46);
                        tokenIn.wordChars(46, 46);
                        tokenIn.ordinaryChars(45, 45);
                        tokenIn.wordChars(45, 45);
                        oldModelName = this.modelName;
                        oldTMod = this.tMod;
                        oldTModDepth = this.tModDepth;
                        System.out.print("Enter model name: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -3) {
                            this.modelName = tokenIn.sval;
                        }
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.ordinaryChars(46, 46);
                        tokenIn.ordinaryChars(45, 45);
                        tokenIn.parseNumbers();
                        if (!this.modelName.equals(oldModelName)) {
                            try {
                                this.readTauModel();
                                this.setSourceDepth(this.depth);
                            }
                            catch (TauModelException e) {
                                if (e.getCause() instanceof InvalidClassException) {
                                    Alert.warning("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create. Still using model " + oldModelName + ".");
                                } else {
                                    Alert.warning("I can't load model file " + this.modelName, "Still using model " + oldModelName + ".");
                                }
                                this.modelName = oldModelName;
                                this.tMod = oldTMod;
                                this.tModDepth = oldTModDepth;
                            }
                        }
                        readMode = 100;
                        break;
                    }
                    case 116: {
                        System.out.print("Enter takeoff angle (deg): ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype != -2) {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead.");
                            this.printHelp();
                            break;
                        }
                        takeoffAngle = tokenIn.nval;
                        this.calcTakeoff(takeoffAngle);
                        this.printResult(this.getWriter());
                        readMode = 100;
                        break;
                    }
                    case 113: {
                        return;
                    }
                }
            } while (tokenIn.ttype == -2 || tokenIn.ttype != -3 || tokenIn.ttype == -3 && !tokenIn.sval.equalsIgnoreCase("q"));
        }
    }

    public void destroy() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void printStdUsageHead() {
        TauP_Time.printStdUsageHead(this.getClass());
    }

    public static void printStdUsageHead(Class toolClass) {
        String className = toolClass.getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        Alert.info("Usage: " + className.toLowerCase() + " [arguments]");
        Alert.info("  or, for purists, java " + toolClass.getName() + " [arguments]");
        Alert.info("\nArguments are:");
    }

    public void printStdUsage() {
        this.printStdUsageHead();
        Alert.info("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\n--stadepth depth   -- receiver depth in km\n\nDistance is given by:\n\n-deg degrees       -- distance in degrees,\n-km kilometers     -- distance in kilometers,\n                      assumes radius of earth is 6371km,\n\nor by giving the station and event latitude and lonitude,\n                      assumes a spherical earth,\n\n-sta[tion] lat lon -- sets the station latitude and longitude\n-evt       lat lon -- sets the event latitude and longitude\n\n");
    }

    public void printStdUsageTail() {
        Alert.info("\n-o [stdout|outfile]         -- output is redirected to stdout or to the \"outfile\" file\n--debug             -- enable debugging output\n--verbose           -- enable verbose output\n--version           -- print the version\n--help              -- print this out, but you already know that!\n");
    }

    public void printUsage() {
        this.printStdUsage();
        Alert.info("--rayp             -- only output the ray parameter\n--time             -- only output travel time\n--rel phasename    -- also output relative travel time");
        this.printStdUsageTail();
    }

    public static void printNoComprendoArgs(String[] noComprendoArgs) {
        if (noComprendoArgs.length > 0) {
            for (int i = 0; i < noComprendoArgs.length; ++i) {
                if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("--help") && !noComprendoArgs[i].equals("-version") && !noComprendoArgs[i].equals("--version")) continue;
                System.exit(0);
            }
            String outStringA = "I don't understand the following arguments, continuing:";
            String outStringB = "";
            for (int i = 0; i < noComprendoArgs.length; ++i) {
                outStringB = outStringB + noComprendoArgs[i] + " ";
            }
            Alert.warning(outStringA, outStringB);
            noComprendoArgs = null;
        }
    }

    public static final double linearInterp(double xa, double ya, double xb, double yb, double x) {
        if (x == xa) {
            return ya;
        }
        if (x == xb) {
            return yb;
        }
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            long prevTime = 0L;
            prevTime = System.currentTimeMillis();
            TauP_Time tauPTime = new TauP_Time();
            String[] noComprendoArgs = tauPTime.parseCmdLineArgs(args);
            TauP_Time.printNoComprendoArgs(noComprendoArgs);
            long currTime = System.currentTimeMillis();
            prevTime = System.currentTimeMillis();
            tauPTime.init();
            currTime = System.currentTimeMillis();
            if (DEBUG) {
                Alert.info("taup model read time=" + (currTime - prevTime));
            }
            tauPTime.start();
            tauPTime.destroy();
        }
        catch (TauModelException e) {
            Alert.error("Caught TauModelException", e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            Alert.error("Caught TauPException", e.getMessage());
            e.printStackTrace();
        }
    }
}

