/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.TauP_Time;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Completor;
import jline.ConsoleReader;
import jline.Terminal;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyJavaType;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.InteractiveConsole;

public class TauP_Console
extends InteractiveConsole {
    protected String prompt = "TauP " + BuildVersion.getVersion();
    protected String historyFilename = ".jline-taup.history";
    public static final String DEFAULT_PROPS = "edu/sc/seis/bag/bag.props";
    private ConsoleReader reader;

    public TauP_Console() throws IOException {
        Terminal.setupTerminal();
        this.reader = new ConsoleReader();
        this.reader.getHistory().setHistoryFile(new File(System.getProperty("user.home"), this.historyFilename));
        this.reader.addCompletor((Completor)new DirCompleter());
        this.systemState.ps1 = new PyString("taup> ");
        this.exec("import sys");
        this.exec("sys.path.append('" + TauP_Console.formatForJythonSysPath(TauP_Console.class, "edu/sc/seis/TauP/jython") + "')");
        this.exec("from taup import *");
        this.set("history", PyJavaType.wrapJavaObject((Object)this.reader.getHistory()));
        this.exec("def h(num):\n    his = history.getHistoryList().toArray()[-num:]\n    for line in his:\n        print line");
    }

    public void interact() {
        this.interact(this.prompt, null);
    }

    public String raw_input(PyObject prompt) {
        String line = null;
        try {
            line = this.reader.readLine(prompt.toString());
        }
        catch (IOException io) {
            throw new PyException(Py.IOError);
        }
        if (line == null) {
            throw new PyException(Py.EOFError);
        }
        return line.endsWith("\n") ? line.substring(0, line.length() - 1) : line;
    }

    public static String formatForJythonSysPath(Class c, String jarDir) {
        String out = c.getClassLoader().getResource(jarDir).toString().substring("jar:file:".length()).replaceAll("\\!", "");
        return out;
    }

    public void printUsage() {
        TauP_Time.printStdUsageHead(((Object)((Object)this)).getClass());
        Alert.info("\n scriptfile         -- jython script is read in from \"scriptfile\"\n-help              -- print this out, but you already know that!\n");
    }

    public static void main(String[] args) throws IOException {
        TauP_Console ic = new TauP_Console();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].equals("-h") && !args[i].equals("--help")) continue;
                ic.printUsage();
                return;
            }
            File f = new File(args[0]);
            if (!f.exists()) {
                System.err.println("Can't find file '" + args[0] + "'");
                System.exit(1);
            }
            if (!f.isFile()) {
                System.err.println("'" + args[0] + "' is not a file.");
                System.exit(1);
            }
            if (!f.canRead()) {
                System.err.println("Can't read file '" + args[0] + "'");
                System.exit(1);
            }
            ic.execfile(args[0]);
        } else {
            ic.interact();
        }
    }

    public class DirCompleter
    implements Completor {
        Pattern rightmostPeriod = Pattern.compile(".*(\\.)[^.]*");

        public int complete(String buffer, int cursor, List candidates) {
            try {
                PyArray res;
                Matcher m = this.rightmostPeriod.matcher(buffer);
                int knownEnd = 0;
                String partial = buffer;
                if (m.matches()) {
                    knownEnd = m.start(1);
                    partial = buffer.substring(knownEnd + 1);
                }
                if (buffer.trim().length() != 0) {
                    res = TauP_Console.this.eval("dir(" + buffer.substring(0, knownEnd) + ")");
                } else {
                    res = new PyArray(String.class, 1);
                    res.__setitem__(0, (PyObject)new PyString("  "));
                }
                for (int i = 0; i < res.__len__(); ++i) {
                    String possible = res.__getitem__(i).toString();
                    if (!possible.startsWith(partial)) continue;
                    candidates.add(possible);
                }
                return m.matches() ? knownEnd + 1 : 0;
            }
            catch (Throwable e) {
                return 0;
            }
        }
    }
}

