/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DummyData;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.navigation.Navigable;
import de.erichseifert.gral.navigation.NavigationDirection;
import de.erichseifert.gral.navigation.Navigator;
import de.erichseifert.gral.plots.AbstractPlot;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.PlotArea;
import de.erichseifert.gral.plots.PlotNavigator;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisListener;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LinearRenderer2D;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.SeriesLegend;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.Orientation;
import de.erichseifert.gral.util.PointND;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XYPlot
extends AbstractPlot
implements Navigable,
AxisListener {
    private static final long serialVersionUID = 4501074701747572783L;
    public static final String AXIS_X = "x";
    public static final String AXIS_X2 = "x2";
    public static final String AXIS_Y = "y";
    public static final String AXIS_Y2 = "y2";
    private final Map<DataSource, PointRenderer> a;
    private final Map<DataSource, LineRenderer> b;
    private final Map<DataSource, AreaRenderer> c;
    private transient XYPlotNavigator d;
    private transient boolean e;

    public XYPlot(DataSource ... object) {
        super(new DataSource[0]);
        this.a = new HashMap<DataSource, PointRenderer>(((DataSource[])object).length);
        this.b = new HashMap<DataSource, LineRenderer>(((DataSource[])object).length);
        this.c = new HashMap<DataSource, AreaRenderer>(((DataSource[])object).length);
        this.setPlotArea(new XYPlotArea2D(this));
        this.setLegend(new XYLegend(this));
        for (DataSource dataSource : object) {
            this.add(dataSource);
        }
        this.createDefaultAxes();
        this.autoscaleAxes();
        this.createDefaultAxisRenderers();
        for (String string : this.getAxesNames()) {
            this.getAxis(string).addAxisListener(this);
        }
    }

    protected void createDefaultAxes() {
        Axis axis = new Axis();
        Axis axis2 = new Axis();
        this.setAxis(AXIS_X, axis);
        this.setAxis(AXIS_Y, axis2);
    }

    protected void createDefaultAxisRenderers() {
        LinearRenderer2D linearRenderer2D = new LinearRenderer2D();
        LinearRenderer2D linearRenderer2D2 = new LinearRenderer2D();
        this.setAxisRenderer(AXIS_X, linearRenderer2D);
        this.setAxisRenderer(AXIS_Y, linearRenderer2D2);
    }

    protected void layoutAxes() {
        if (this.getPlotArea() == null) {
            return;
        }
        this.a(AXIS_X, Orientation.HORIZONTAL);
        this.a(AXIS_X2, Orientation.HORIZONTAL);
        this.a(AXIS_Y, Orientation.VERTICAL);
        this.a(AXIS_Y2, Orientation.VERTICAL);
        this.b(AXIS_X, Orientation.HORIZONTAL);
        this.b(AXIS_X2, Orientation.HORIZONTAL);
        this.b(AXIS_Y, Orientation.VERTICAL);
        this.b(AXIS_Y2, Orientation.VERTICAL);
    }

    private void a(String object, Orientation object2) {
        Rectangle2D rectangle2D = this.getPlotArea().getBounds();
        Object object3 = this.getAxisComponent((String)object);
        object = this.getAxisRenderer((String)object);
        if (object3 == null || object == null) {
            return;
        }
        object3 = object3.getPreferredSize();
        object2 = object2 == Orientation.HORIZONTAL ? new Line2D.Double(0.0, 0.0, rectangle2D.getWidth(), 0.0) : new Line2D.Double(((Dimension2D)object3).getWidth(), rectangle2D.getHeight(), ((Dimension2D)object3).getWidth(), 0.0);
        object.setSetting(AxisRenderer.SHAPE, object2);
    }

    private void b(String pointND, Orientation orientation) {
        Drawable drawable = this.getAxisComponent((String)((Object)pointND));
        pointND = this.getAxisRenderer((String)((Object)pointND));
        if (drawable == null || pointND == null) {
            return;
        }
        Object object = orientation == Orientation.HORIZONTAL ? AXIS_Y : AXIS_X;
        Object object2 = this.getAxis((String)object);
        object = this.getAxisRenderer((String)object);
        if (object2 == null || !((Axis)object2).isValid() || object == null) {
            return;
        }
        pointND = (Number)pointND.getSetting(AxisRenderer.INTERSECTION);
        if ((pointND = object.getPosition((Axis)object2, (Number)((Object)pointND), false, false)) == null) {
            pointND = new PointND((Number[])new Double[]{0.0, 0.0});
        }
        object = this.getPlotArea().getBounds();
        object2 = drawable.getPreferredSize();
        if (orientation == Orientation.HORIZONTAL) {
            drawable.setBounds(((RectangularShape)object).getMinX(), (Double)pointND.get(1) + ((RectangularShape)object).getMinY(), ((RectangularShape)object).getWidth(), ((Dimension2D)object2).getHeight());
            return;
        }
        drawable.setBounds(((RectangularShape)object).getMinX() - ((Dimension2D)object2).getWidth() + (Double)pointND.get(0), ((RectangularShape)object).getMinY(), ((Dimension2D)object2).getWidth(), ((RectangularShape)object).getHeight());
    }

    public PointRenderer getPointRenderer(DataSource dataSource) {
        return this.a.get(dataSource);
    }

    public void setPointRenderer(DataSource dataSource, PointRenderer pointRenderer) {
        this.a.put(dataSource, pointRenderer);
    }

    public LineRenderer getLineRenderer(DataSource dataSource) {
        return this.b.get(dataSource);
    }

    public void setLineRenderer(DataSource dataSource, LineRenderer lineRenderer) {
        this.b.put(dataSource, lineRenderer);
    }

    public AreaRenderer getAreaRenderer(DataSource dataSource) {
        return this.c.get(dataSource);
    }

    public void setAreaRenderer(DataSource dataSource, AreaRenderer areaRenderer) {
        this.c.put(dataSource, areaRenderer);
    }

    public void setAxisRenderer(String string, AxisRenderer axisRenderer) {
        if (axisRenderer != null) {
            if (AXIS_X2.equals(string) || AXIS_Y.equals(string)) {
                axisRenderer.setSetting(AxisRenderer.SHAPE_NORMAL_ORIENTATION_CLOCKWISE, true);
            }
            if (AXIS_Y.equals(string)) {
                axisRenderer.setSetting(AxisRenderer.LABEL_ROTATION, 90.0);
            }
        }
        super.setAxisRenderer(string, axisRenderer);
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        super.add(n, dataSource, bl);
        this.setMapping(dataSource, AXIS_X, AXIS_Y);
        this.autoscaleAxes();
        DefaultPointRenderer2D defaultPointRenderer2D = new DefaultPointRenderer2D();
        this.setPointRenderer(dataSource, defaultPointRenderer2D);
        this.setLineRenderer(dataSource, null);
        this.setAreaRenderer(dataSource, null);
    }

    public Navigator getNavigator() {
        if (this.d == null) {
            this.d = new XYPlotNavigator(this);
        }
        return this.d;
    }

    public void draw(DrawingContext drawingContext) {
        super.draw(drawingContext);
        if (!this.e) {
            this.getNavigator().setDefaultState();
            this.e = true;
        }
    }

    public void rangeChanged(Axis axis, Number number, Number number2) {
        this.layoutAxes();
    }

    private void readObject(ObjectInputStream object) throws ClassNotFoundException, IOException {
        ((ObjectInputStream)object).defaultReadObject();
        for (String string : this.getAxesNames()) {
            this.getAxis(string).addAxisListener(this);
        }
    }

    public static class XYLegend
    extends SeriesLegend {
        private static final long serialVersionUID = -4629928754001372002L;
        private static final DataSource a = new DummyData(2, Integer.MAX_VALUE, Double.valueOf(0.5));
        private final XYPlot b;

        public XYLegend(XYPlot xYPlot) {
            this.b = xYPlot;
        }

        public Drawable getSymbol(Row row) {
            return new AbstractLegend.AbstractSymbol(this, this, row){
                private static final long serialVersionUID = 5744026898590787285L;
                private /* synthetic */ Row a;
                private /* synthetic */ XYLegend b;
                {
                    this.b = xYLegend;
                    this.a = row;
                    super(settingsStorage);
                }

                public final void draw(DrawingContext drawingContext) {
                    Object object = this.a.getSource();
                    PointRenderer pointRenderer = this.b.b.getPointRenderer((DataSource)object);
                    Object object2 = this.b.b.getLineRenderer((DataSource)object);
                    object = this.b.b.getAreaRenderer((DataSource)object);
                    Object object3 = new Row(a, this.a.getIndex());
                    List<DataPoint> list = this.getBounds();
                    Object object4 = new Axis(0.0, 1.0);
                    Object object5 = new LinearRenderer2D();
                    object5.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)((Object)list)).getMinX(), ((RectangularShape)((Object)list)).getCenterY(), ((RectangularShape)((Object)list)).getMaxX(), ((RectangularShape)((Object)list)).getCenterY()));
                    Axis axis = new Axis(0.0, 1.0);
                    LinearRenderer2D linearRenderer2D = new LinearRenderer2D();
                    linearRenderer2D.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)((Object)list)).getCenterX(), ((RectangularShape)((Object)list)).getMaxY(), ((RectangularShape)((Object)list)).getCenterX(), ((RectangularShape)((Object)list)).getMinY()));
                    object3 = new PointData(Arrays.asList(object4, axis), Arrays.asList(object5, linearRenderer2D), (Row)object3, 0);
                    object4 = null;
                    if (pointRenderer != null) {
                        object4 = pointRenderer.getPointShape((PointData)object3);
                    }
                    object5 = new DataPoint((PointData)object3, new PointND((Number[])new Double[]{((RectangularShape)((Object)list)).getMinX(), ((RectangularShape)((Object)list)).getCenterY()}), null, null, null);
                    object4 = new DataPoint((PointData)object3, new PointND((Number[])new Double[]{((RectangularShape)((Object)list)).getCenterX(), ((RectangularShape)((Object)list)).getCenterY()}), null, (Shape)object4, null);
                    list = new DataPoint((PointData)object3, new PointND((Number[])new Double[]{((RectangularShape)((Object)list)).getMaxX(), ((RectangularShape)((Object)list)).getCenterY()}), null, null, null);
                    list = Arrays.asList(object5, object4, list);
                    if (object != null) {
                        object5 = object.getAreaShape(list);
                        object.getArea(list, (Shape)object5).draw(drawingContext);
                    }
                    if (object2 != null) {
                        object5 = object2.getLineShape(list);
                        object2.getLine(list, (Shape)object5).draw(drawingContext);
                    }
                    if (pointRenderer != null) {
                        object5 = drawingContext.getGraphics();
                        object = ((DataPoint)object4).position.getPoint2D();
                        object2 = ((Graphics2D)object5).getTransform();
                        ((Graphics2D)object5).translate(((Point2D)object).getX(), ((Point2D)object).getY());
                        pointRenderer.getPoint((PointData)object3, ((DataPoint)object4).shape).draw(drawingContext);
                        ((Graphics2D)object5).setTransform((AffineTransform)object2);
                    }
                }
            };
        }
    }

    public static class XYPlotArea2D
    extends PlotArea {
        private static final long serialVersionUID = -3673157774425536428L;
        public static final Key GRID_MAJOR_X = new Key("xyplot.grid.major.x");
        public static final Key GRID_MAJOR_Y = new Key("xyplot.grid.major.y");
        public static final Key GRID_MAJOR_COLOR = new Key("xyplot.grid.major.color");
        public static final Key GRID_MINOR_X = new Key("xyplot.grid.minor.x");
        public static final Key GRID_MINOR_Y = new Key("xyplot.grid.minor.y");
        public static final Key GRID_MINOR_COLOR = new Key("xyplot.grid.minor.color");
        private final XYPlot a;

        public XYPlotArea2D(XYPlot xYPlot) {
            this.a = xYPlot;
            this.setSettingDefault(GRID_MAJOR_X, true);
            this.setSettingDefault(GRID_MAJOR_Y, true);
            this.setSettingDefault(GRID_MAJOR_COLOR, new Color(0.0f, 0.0f, 0.0f, 0.1f));
            this.setSettingDefault(GRID_MINOR_X, false);
            this.setSettingDefault(GRID_MINOR_Y, false);
            this.setSettingDefault(GRID_MINOR_COLOR, new Color(0.0f, 0.0f, 0.0f, 0.05f));
        }

        public void draw(DrawingContext drawingContext) {
            this.drawBackground(drawingContext);
            this.drawGrid(drawingContext);
            this.drawBorder(drawingContext);
            this.drawPlot(drawingContext);
            this.a.drawAxes(drawingContext);
            this.a.drawLegend(drawingContext);
        }

        protected void drawGrid(DrawingContext object) {
            Object object2;
            Object object3;
            Iterator iterator;
            object = ((DrawingContext)object).getGraphics();
            boolean bl = (Boolean)this.getSetting(GRID_MAJOR_X);
            boolean bl2 = (Boolean)this.getSetting(GRID_MAJOR_Y);
            boolean bl3 = (Boolean)this.getSetting(GRID_MINOR_X);
            boolean bl4 = (Boolean)this.getSetting(GRID_MINOR_Y);
            AffineTransform affineTransform = ((Graphics2D)object).getTransform();
            ((Graphics2D)object).translate(this.getX(), this.getY());
            AffineTransform affineTransform2 = ((Graphics2D)object).getTransform();
            Rectangle2D rectangle2D = this.getBounds();
            if (bl || bl3) {
                iterator = this.a.getAxisRenderer(XYPlot.AXIS_X);
                object3 = this.a.getAxis(XYPlot.AXIS_X);
                if (iterator != null && object3 != null && ((Axis)object3).isValid()) {
                    object2 = ((Shape)iterator.getSetting(AxisRenderer.SHAPE)).getBounds2D();
                    iterator = iterator.getTicks((Axis)object3);
                    object3 = new Line2D.Double(-((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY(), -((RectangularShape)object2).getMinX(), rectangle2D.getHeight() - ((RectangularShape)object2).getMinY());
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Point2D point2D;
                        object2 = (Tick)iterator.next();
                        if (((Tick)object2).type == Tick.TickType.MAJOR && !bl || ((Tick)object2).type == Tick.TickType.MINOR && !bl3 || (point2D = ((Tick)object2).position.getPoint2D()) == null) continue;
                        Paint paint = (Paint)this.getSetting(GRID_MAJOR_COLOR);
                        if (((Tick)object2).type == Tick.TickType.MINOR) {
                            paint = (Paint)this.getSetting(GRID_MINOR_COLOR);
                        }
                        ((Graphics2D)object).translate(point2D.getX(), point2D.getY());
                        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object3, paint, null, null);
                        ((Graphics2D)object).setTransform(affineTransform2);
                    }
                }
            }
            if (bl2 || bl4) {
                iterator = this.a.getAxis(XYPlot.AXIS_Y);
                object3 = this.a.getAxisRenderer(XYPlot.AXIS_Y);
                if (iterator != null && ((Axis)((Object)iterator)).isValid() && object3 != null) {
                    object2 = ((Shape)object3.getSetting(AxisRenderer.SHAPE)).getBounds2D();
                    iterator = object3.getTicks((Axis)((Object)iterator));
                    object3 = new Line2D.Double(-((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY(), rectangle2D.getWidth() - ((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY());
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Point2D point2D;
                        boolean bl5;
                        object2 = (Tick)iterator.next();
                        boolean bl6 = ((Tick)object2).type == Tick.TickType.MAJOR;
                        boolean bl7 = bl5 = ((Tick)object2).type == Tick.TickType.MINOR;
                        if (bl6 && !bl2 || bl5 && !bl4 || (point2D = ((Tick)object2).position.getPoint2D()) == null) continue;
                        Paint paint = (Paint)this.getSetting(GRID_MAJOR_COLOR);
                        if (bl5) {
                            paint = (Paint)this.getSetting(GRID_MINOR_COLOR);
                        }
                        ((Graphics2D)object).translate(point2D.getX(), point2D.getY());
                        GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object3, paint, null, null);
                        ((Graphics2D)object).setTransform(affineTransform2);
                    }
                }
            }
            ((Graphics2D)object).setTransform(affineTransform);
        }

        protected void drawPlot(DrawingContext drawingContext) {
            Graphics2D graphics2D = drawingContext.getGraphics();
            Shape shape = graphics2D.getClip();
            Insets2D insets2D = (Insets2D)this.getSetting(CLIPPING);
            if (insets2D != null) {
                Object object = new Rectangle2D.Double(this.getX() + insets2D.getLeft() * 10.0, this.getY() + insets2D.getTop() * 10.0, this.getWidth() - insets2D.getHorizontal() * 10.0, this.getHeight() - insets2D.getVertical() * 10.0);
                if (shape != null) {
                    Area object2 = new Area(shape);
                    object2.intersect(new Area((Shape)object));
                    object = object2;
                }
                graphics2D.setClip((Shape)object);
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(this.getX(), this.getY());
            AffineTransform affineTransform2 = graphics2D.getTransform();
            for (DataSource dataSource : this.a.getVisibleData()) {
                Object object;
                if (dataSource.getColumnCount() == 0 || 0 >= dataSource.getColumnCount() || !dataSource.isColumnNumeric(0) || 1 >= dataSource.getColumnCount() || !dataSource.isColumnNumeric(1)) continue;
                PointRenderer pointRenderer = this.a.getPointRenderer(dataSource);
                LineRenderer lineRenderer = this.a.getLineRenderer(dataSource);
                AreaRenderer areaRenderer = this.a.getAreaRenderer(dataSource);
                Object object2 = this.a.getMapping(dataSource);
                Axis axis = this.a.getAxis(object2[0]);
                Axis axis2 = this.a.getAxis(object2[1]);
                if (!axis.isValid() || !axis2.isValid()) continue;
                AxisRenderer axisRenderer = this.a.getAxisRenderer(object2[0]);
                object2 = this.a.getAxisRenderer(object2[1]);
                LinkedList<DataPoint> linkedList = new LinkedList<DataPoint>();
                for (int shape3 = 0; shape3 < dataSource.getRowCount(); ++shape3) {
                    PointND pointND;
                    Row row = new Row(dataSource, shape3);
                    object = (Number)((Object)row.get(0));
                    Object object3 = (Number)((Object)row.get(1));
                    PointND pointND2 = axisRenderer != null ? axisRenderer.getPosition(axis, (Number)object, true, false) : new PointND((Number[])new Double[]{0.0, 0.0});
                    PointND pointND3 = pointND = object2 != null ? object2.getPosition(axis2, (Number)object3, true, false) : new PointND((Number[])new Double[]{0.0, 0.0});
                    if (pointND2 == null || pointND == null) continue;
                    PointND pointND4 = new PointND((Number[])new Double[]{(Double)pointND2.get(0), (Double)pointND.get(1)});
                    PointData pointData = new PointData(Arrays.asList(axis, axis2), Arrays.asList(axisRenderer, object2), row, 1);
                    object = null;
                    Drawable drawable = null;
                    object3 = null;
                    if (pointRenderer != null) {
                        object = pointRenderer.getPointShape(pointData);
                        drawable = pointRenderer.getPoint(pointData, (Shape)object);
                        object3 = pointRenderer.getValue(pointData, (Shape)object);
                    }
                    DataPoint dataPoint = new DataPoint(pointData, pointND4, drawable, (Shape)object, (Drawable)object3);
                    linkedList.add(dataPoint);
                }
                if (areaRenderer != null) {
                    Shape shape2 = areaRenderer.getAreaShape(linkedList);
                    areaRenderer.getArea(linkedList, shape2).draw(drawingContext);
                }
                if (lineRenderer != null) {
                    Shape shape3 = lineRenderer.getLineShape(linkedList);
                    lineRenderer.getLine(linkedList, shape3).draw(drawingContext);
                }
                if (pointRenderer == null) continue;
                for (DataPoint dataPoint : linkedList) {
                    object = dataPoint.position;
                    double d = ((PointND)object).get(0);
                    double d2 = (Double)((PointND)object).get(1);
                    graphics2D.translate(d, d2);
                    dataPoint.drawable.draw(drawingContext);
                    graphics2D.setTransform(affineTransform2);
                }
                for (DataPoint dataPoint : linkedList) {
                    object = dataPoint.position;
                    double d = ((PointND)object).get(0);
                    double d3 = (Double)((PointND)object).get(1);
                    graphics2D.translate(d, d3);
                    dataPoint.labelDrawable.draw(drawingContext);
                    graphics2D.setTransform(affineTransform2);
                }
            }
            graphics2D.setTransform(affineTransform);
            if (insets2D != null) {
                graphics2D.setClip(shape);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XYPlotNavigator
    extends PlotNavigator {
        public XYPlotNavigator(XYPlot xYPlot) {
            super((Plot)xYPlot, XYNavigationDirection.ARBITRARY.getAxesNames());
        }

        @Override
        public void setDirection(NavigationDirection navigationDirection) {
            if (navigationDirection == this.getDirection()) {
                return;
            }
            if (!(navigationDirection instanceof XYNavigationDirection)) {
                throw new IllegalArgumentException("Unknown direction.");
            }
            String[] stringArray = ((XYNavigationDirection)navigationDirection).getAxesNames();
            this.setAxes(stringArray);
            super.setDirection(navigationDirection);
        }

        @Override
        protected Number getDimensionValue(String string, PointND<? extends Number> pointND) {
            if (XYPlot.AXIS_Y.equals(string) || XYPlot.AXIS_Y2.equals(string)) {
                return -pointND.get(1).doubleValue();
            }
            return pointND.get(0);
        }

        @Override
        protected int getDimensions() {
            return 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XYNavigationDirection implements NavigationDirection
    {
        HORIZONTAL("x", "x2"),
        VERTICAL("y", "y2"),
        ARBITRARY("x", "y", "x2", "y2");

        private final String[] a;

        private XYNavigationDirection(String ... stringArray) {
            this.a = stringArray;
        }

        public final String[] getAxesNames() {
            return this.a;
        }
    }
}

