/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.statistics.Statistics;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ContinuousColorMapper;
import de.erichseifert.gral.plots.colors.Grayscale;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingsStorage;
import de.erichseifert.gral.util.Dimension2D;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class RasterPlot
extends XYPlot {
    private static final long serialVersionUID = 5844862286358250831L;
    public static final Key OFFSET = new Key("rasterplot.offset");
    public static final Key DISTANCE = new Key("rasterplot.distance");
    public static final Key COLORS = new Key("rasterplot.color");

    public RasterPlot(DataSource dataSource) {
        super(new DataSource[0]);
        this.setSettingDefault(OFFSET, new Point2D.Double());
        this.setSettingDefault(DISTANCE, new Dimension2D.Double(1.0, 1.0));
        this.setSettingDefault(COLORS, new Grayscale());
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_X, false);
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_Y, false);
        this.getAxisRenderer("x").setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.getAxisRenderer("y").setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.add(dataSource);
        this.autoscaleAxes();
    }

    public void autoscaleAxis(String string) {
        if ("x".equals(string) || "y".equals(string)) {
            Axis axis;
            Dimension2D dimension2D = (Dimension2D)this.getSetting(DISTANCE);
            if (dimension2D == null) {
                dimension2D = new Dimension2D.Double(1.0, 1.0);
            }
            if ((axis = this.getAxis(string)) == null || !axis.isAutoscaled()) {
                return;
            }
            double d = this.getAxisMin(string);
            double d2 = this.getAxisMax(string);
            if ("x".equals(string)) {
                axis.setRange(d, d2 + dimension2D.getWidth());
                return;
            }
            if ("y".equals(string)) {
                axis.setRange(d - dimension2D.getHeight(), d2);
            }
            return;
        }
        super.autoscaleAxis(string);
    }

    public static DataSource createRasterData(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("Cannot convert null data source.");
        }
        DataTable dataTable = new DataTable(Double.class, Double.class, Double.class);
        Statistics statistics = dataSource.getStatistics();
        double d = statistics.get("min");
        double d2 = statistics.get("max") - d;
        int n = 0;
        for (Comparable comparable : dataSource) {
            int n2 = n % dataSource.getColumnCount();
            int n3 = -n / dataSource.getColumnCount();
            double d3 = Double.NaN;
            if (comparable instanceof Number) {
                d3 = (((Number)((Object)comparable)).doubleValue() - d) / d2;
            }
            dataTable.add(Double.valueOf(n2), Double.valueOf(n3), Double.valueOf(d3));
            ++n;
        }
        return dataTable;
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        if (this.getData().size() > 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(n, dataSource, bl);
        this.setLineRenderer(dataSource, null);
        this.setPointRenderer(dataSource, new RasterRenderer(this));
    }

    protected static class RasterRenderer
    extends AbstractPointRenderer {
        private static final long serialVersionUID = 1266585364126459761L;
        public static final Key COLUMN_X = new Key("rasterplot.columnX");
        public static final Key COLUMN_Y = new Key("rasterplot.columnY");
        public static final Key COLUMN_VALUE = new Key("rasterplot.columnValue");
        private final SettingsStorage a;

        public RasterRenderer(SettingsStorage settingsStorage) {
            this.a = settingsStorage;
            this.setSettingDefault(COLUMN_X, 0);
            this.setSettingDefault(COLUMN_Y, 1);
            this.setSettingDefault(COLUMN_VALUE, 2);
        }

        public Drawable getPoint(PointData pointData, Shape shape) {
            return new AbstractDrawable(this, pointData, shape){
                private static final long serialVersionUID = -1136689797647794969L;
                private /* synthetic */ PointData a;
                private /* synthetic */ Shape b;
                private /* synthetic */ RasterRenderer c;
                {
                    this.c = rasterRenderer;
                    this.a = pointData;
                    this.b = shape;
                }

                public final void draw(DrawingContext object) {
                    RasterRenderer rasterRenderer = this.c;
                    Object object2 = this.a.axes.get(0);
                    Object object3 = this.a.axes.get(1);
                    AxisRenderer axisRenderer = this.a.axisRenderers.get(0);
                    AxisRenderer axisRenderer2 = this.a.axisRenderers.get(1);
                    Row row = this.a.row;
                    int n = (Integer)rasterRenderer.getSetting(COLUMN_X);
                    if (n < 0 || n >= row.size() || !row.isColumnNumeric(n)) {
                        return;
                    }
                    int n2 = (Integer)rasterRenderer.getSetting(COLUMN_Y);
                    if (n2 < 0 || n2 >= row.size() || !row.isColumnNumeric(n2)) {
                        return;
                    }
                    int n3 = (Integer)rasterRenderer.getSetting(COLUMN_VALUE);
                    if (n3 < 0 || n3 >= row.size() || !row.isColumnNumeric(n3)) {
                        return;
                    }
                    double d = ((Number)((Object)row.get(n))).doubleValue();
                    double d2 = ((Number)((Object)row.get(n2))).doubleValue();
                    Object object4 = (Number)((Object)row.get(n3));
                    double d3 = axisRenderer.getPosition((Axis)object2, d - 0.5, true, false).get(0);
                    double d4 = Math.abs(axisRenderer.getPosition((Axis)object2, d + 0.5, true, false).get(0) - d3) + 1.0;
                    double d5 = axisRenderer2.getPosition((Axis)object3, d2 - 0.5, true, false).get(1);
                    double d6 = Math.abs(axisRenderer2.getPosition((Axis)object3, d2 + 0.5, true, false).get(1) - d5) + 1.0;
                    object2 = this.b.getBounds2D();
                    object3 = new AffineTransform();
                    ((AffineTransform)object3).scale(d4 / ((RectangularShape)object2).getWidth(), d6 / ((RectangularShape)object2).getHeight());
                    ((AffineTransform)object3).translate(-((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY());
                    object2 = ((AffineTransform)object3).createTransformedShape(this.b);
                    object = ((DrawingContext)object).getGraphics();
                    object3 = (ColorMapper)this.c.a.getSetting(COLORS);
                    if (object3 instanceof ContinuousColorMapper) {
                        object4 = ((ContinuousColorMapper)object3).get(((Number)object4).doubleValue());
                    } else if (object3 != null) {
                        object4 = ((Number)object4).intValue();
                        object4 = object3.get((Number)object4);
                    } else {
                        object4 = Color.BLACK;
                    }
                    GraphicsUtils.fillPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object4, object2.getBounds2D());
                }
            };
        }

        public Shape getPointShape(PointData pointData) {
            return (Shape)this.getSetting(SHAPE);
        }

        public Drawable getValue(PointData pointData, Shape shape) {
            return new AbstractDrawable(){
                private static final long serialVersionUID = -8402945980942955359L;

                public final void draw(DrawingContext drawingContext) {
                }
            };
        }
    }
}

