/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.StylableDrawable;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingChangeEvent;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public abstract class PlotArea
extends StylableDrawable {
    private static final long serialVersionUID = 2745982325709470005L;
    public static final Key BACKGROUND = new Key("plotarea.background");
    public static final Key BORDER = new Key("plotarea.border");
    public static final Key COLOR = new Key("plotarea.color");
    public static final Key CLIPPING = new Key("plotarea.clipping");

    public PlotArea() {
        this.setSettingDefault(BACKGROUND, Color.WHITE);
        this.setSettingDefault(BORDER, new BasicStroke(1.0f));
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(CLIPPING, new Insets2D.Double(0.0));
    }

    protected void drawBackground(DrawingContext drawingContext) {
        Paint paint = (Paint)this.getSetting(BACKGROUND);
        if (paint != null) {
            GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null);
        }
    }

    protected void drawBorder(DrawingContext drawingContext) {
        Stroke stroke = (Stroke)this.getSetting(BORDER);
        if (stroke != null) {
            Paint paint = (Paint)this.getSetting(COLOR);
            GraphicsUtils.drawPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null, stroke);
        }
    }

    protected abstract void drawPlot(DrawingContext var1);

    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }
}

