/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataAccessor;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LinearRenderer2D;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ContinuousColorMapper;
import de.erichseifert.gral.plots.colors.SingleColor;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.ValueLegend;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;

public class BoxPlot
extends XYPlot {
    private static final long serialVersionUID = -3069831535208696337L;

    public BoxPlot(DataSource dataSource) {
        super(new DataSource[0]);
        this.setLegend(new BoxPlotLegend(this));
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_X, false);
        this.getAxisRenderer("x").setSetting(AxisRenderer.TICKS_SPACING, 1.0);
        this.getAxisRenderer("x").setSetting(AxisRenderer.TICKS_MINOR, false);
        this.getAxisRenderer("x").setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.getAxisRenderer("y").setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.add(dataSource);
        this.autoscaleAxes();
    }

    public static DataSource createBoxData(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("Cannot extract statistics from null data source.");
        }
        DataTable dataTable = new DataTable(Integer.class, Double.class, Double.class, Double.class, Double.class, Double.class);
        for (int i = 0; i < dataSource.getColumnCount(); ++i) {
            Column column = dataSource.getColumn(i);
            if (!column.isNumeric()) continue;
            dataTable.add(Integer.valueOf(i + 1), Double.valueOf(column.getStatistics("quantile50")), Double.valueOf(column.getStatistics("min")), Double.valueOf(column.getStatistics("quantile25")), Double.valueOf(column.getStatistics("quantile75")), Double.valueOf(column.getStatistics("max")));
        }
        return dataTable;
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        if (this.getData().size() > 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(n, dataSource, bl);
        this.setLineRenderer(dataSource, null);
        this.setPointRenderer(dataSource, new BoxWhiskerRenderer());
    }

    public void autoscaleAxis(String string) {
        if ("x".equals(string) || "y".equals(string)) {
            Axis axis = this.getAxis(string);
            if (axis == null || !axis.isAutoscaled()) {
                return;
            }
            if (this.getData().isEmpty()) {
                return;
            }
            DataSource dataSource = this.getData().get(0);
            if ("x".equals(string)) {
                Column column = dataSource.getColumn(0);
                axis.setRange(column.getStatistics("min") - 0.5, column.getStatistics("max") + 0.5);
                return;
            }
            if ("y".equals(string)) {
                double d = dataSource.getColumn(2).getStatistics("min");
                double d2 = dataSource.getColumn(5).getStatistics("max");
                double d3 = 0.05 * (d2 - d);
                axis.setRange(d - d3, d2 + d3);
            }
            return;
        }
        super.autoscaleAxis(string);
    }

    public static class BoxPlotLegend
    extends ValueLegend {
        private static final long serialVersionUID = 1517792984459627757L;
        private static final DataSource a = new AbstractDataSource(new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}){
            private static final long serialVersionUID = -8233716728143117368L;
            private final Double[] a = new Double[]{0.5, 0.0, 0.0, 1.0, 1.0};

            @Override
            public final int getRowCount() {
                return 1;
            }

            @Override
            public final Comparable<?> get(int n, int n2) {
                if (n == 0) {
                    return (double)(n2 + 1);
                }
                return this.a[n - 1];
            }
        };
        private final BoxPlot b;

        public BoxPlotLegend(BoxPlot boxPlot) {
            this.b = boxPlot;
        }

        public Drawable getSymbol(Row row) {
            return new AbstractLegend.AbstractSymbol(this, this, row){
                private static final long serialVersionUID = 1906894939358065143L;
                private /* synthetic */ Row a;
                private /* synthetic */ BoxPlotLegend b;
                {
                    this.b = boxPlotLegend;
                    this.a = row;
                    super(settingsStorage);
                }

                public final void draw(DrawingContext drawingContext) {
                    Object object = this.a.getSource();
                    object = this.b.b.getPointRenderer((DataSource)object);
                    if (object == null) {
                        return;
                    }
                    Object object2 = new Row(a, this.a.getIndex());
                    Cloneable cloneable = this.getBounds();
                    double d = DataUtils.getValueOrDefault((Number)object.getSetting(BoxWhiskerRenderer.BOX_WIDTH), 1.0);
                    double d2 = ((Number)((Object)this.a.get(0))).doubleValue();
                    Object object3 = new Axis(d2 - d / 2.0, d2 + d / 2.0);
                    Object object4 = new LinearRenderer2D();
                    object4.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMaxY(), ((RectangularShape)cloneable).getMaxX(), ((RectangularShape)cloneable).getMaxY()));
                    Axis axis = new Axis(1.0, 2.0);
                    LinearRenderer2D linearRenderer2D = new LinearRenderer2D();
                    linearRenderer2D.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMaxY(), ((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMinY()));
                    object2 = new PointData(Arrays.asList(object3, axis), Arrays.asList(object4, linearRenderer2D), (Row)object2, 0);
                    object3 = object.getPointShape((PointData)object2);
                    object4 = object.getPoint((PointData)object2, (Shape)object3);
                    object = object.getValue((PointData)object2, (Shape)object3);
                    object = new DataPoint((PointData)object2, new PointND((Number[])new Double[]{((RectangularShape)cloneable).getCenterX(), ((RectangularShape)cloneable).getCenterY()}), (Drawable)object4, (Shape)object3, (Drawable)object);
                    object2 = drawingContext.getGraphics();
                    ((Graphics2D)object2).draw((Shape)((Object)cloneable));
                    cloneable = ((DataPoint)object).position.getPoint2D();
                    object3 = ((Graphics2D)object2).getTransform();
                    ((Graphics2D)object2).translate(((Point2D)cloneable).getX(), ((Point2D)cloneable).getY());
                    ((DataPoint)object).drawable.draw(drawingContext);
                    ((Graphics2D)object2).setTransform((AffineTransform)object3);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoxWhiskerRenderer
    extends AbstractPointRenderer {
        private static final long serialVersionUID = 2944482729753981341L;
        public static final Key COLUMN_POSITION = new Key("boxplot.position.column");
        public static final Key COLUMN_BAR_CENTER = new Key("boxplot.bar.center.column");
        public static final Key COLUMN_BAR_BOTTOM = new Key("boxplot.bar.bottom.column");
        public static final Key COLUMN_BOX_BOTTOM = new Key("boxplot.box.bottom.column");
        public static final Key COLUMN_BOX_TOP = new Key("boxplot.box.top.column");
        public static final Key COLUMN_BAR_TOP = new Key("boxplot.bar.top.column");
        public static final Key BOX_WIDTH = new Key("boxplot.box.width");
        public static final Key BOX_BACKGROUND = new Key("boxplot.box.background");
        public static final Key BOX_COLOR = new Key("boxplot.box.color");
        public static final Key BOX_BORDER = new Key("boxplot.box.border");
        public static final Key WHISKER_COLOR = new Key("boxplot.whisker.color");
        public static final Key WHISKER_STROKE = new Key("boxplot.whisker.stroke");
        public static final Key BAR_WIDTH = new Key("boxplot.bar.width");
        public static final Key BAR_CENTER_COLOR = new Key("boxplot.bar.center.color");
        public static final Key BAR_CENTER_STROKE = new Key("boxplot.bar.center.stroke");

        public BoxWhiskerRenderer() {
            this.setSettingDefault(COLUMN_POSITION, 0);
            this.setSettingDefault(COLUMN_BAR_CENTER, 1);
            this.setSettingDefault(COLUMN_BAR_BOTTOM, 2);
            this.setSettingDefault(COLUMN_BOX_BOTTOM, 3);
            this.setSettingDefault(COLUMN_BOX_TOP, 4);
            this.setSettingDefault(COLUMN_BAR_TOP, 5);
            this.setSettingDefault(BOX_WIDTH, 0.75);
            this.setSettingDefault(BOX_BACKGROUND, Color.WHITE);
            this.setSettingDefault(BOX_COLOR, Color.BLACK);
            this.setSettingDefault(BOX_BORDER, new BasicStroke(1.0f));
            this.setSettingDefault(WHISKER_COLOR, Color.BLACK);
            this.setSettingDefault(WHISKER_STROKE, new BasicStroke(1.0f));
            this.setSettingDefault(BAR_WIDTH, 0.75);
            this.setSettingDefault(BAR_CENTER_COLOR, Color.BLACK);
            this.setSettingDefault(BAR_CENTER_STROKE, new BasicStroke(2.0f, 0, 0));
        }

        @Override
        public Drawable getPoint(PointData pointData, Shape shape) {
            return new AbstractDrawable(this, pointData, shape){
                private static final long serialVersionUID = 2765031432328349977L;
                private /* synthetic */ PointData a;
                private /* synthetic */ Shape b;
                private /* synthetic */ BoxWhiskerRenderer c;
                {
                    this.c = boxWhiskerRenderer;
                    this.a = pointData;
                    this.b = shape;
                }

                public final void draw(DrawingContext object) {
                    Object object2 = this.a.axes.get(0);
                    Object object3 = this.a.axes.get(1);
                    Object object4 = this.a.axisRenderers.get(0);
                    Object object5 = this.a.axisRenderers.get(1);
                    Object object6 = this.a.row;
                    BoxWhiskerRenderer boxWhiskerRenderer = this.c;
                    int n = (Integer)boxWhiskerRenderer.getSetting(COLUMN_POSITION);
                    int n2 = (Integer)boxWhiskerRenderer.getSetting(COLUMN_BAR_CENTER);
                    int n3 = (Integer)boxWhiskerRenderer.getSetting(COLUMN_BAR_BOTTOM);
                    int n4 = (Integer)boxWhiskerRenderer.getSetting(COLUMN_BOX_BOTTOM);
                    int n5 = (Integer)boxWhiskerRenderer.getSetting(COLUMN_BOX_TOP);
                    int n6 = (Integer)boxWhiskerRenderer.getSetting(COLUMN_BAR_TOP);
                    if (!(((Row)object6).isColumnNumeric(n) && ((Row)object6).isColumnNumeric(n2) && ((Row)object6).isColumnNumeric(n3) && ((Row)object6).isColumnNumeric(n4) && ((Row)object6).isColumnNumeric(n5) && ((Row)object6).isColumnNumeric(n6))) {
                        return;
                    }
                    double d = ((Number)((Object)((Row)object6).get(n))).doubleValue();
                    double d2 = ((Number)((Object)((Row)object6).get(n3))).doubleValue();
                    double d3 = ((Number)((Object)((Row)object6).get(n4))).doubleValue();
                    double d4 = ((Number)((Object)((Row)object6).get(n2))).doubleValue();
                    double d5 = ((Number)((Object)((Row)object6).get(n5))).doubleValue();
                    double d6 = ((Number)((Object)((Row)object6).get(n6))).doubleValue();
                    double d7 = DataUtils.getValueOrDefault((Number)this.c.getSetting(BOX_WIDTH), 1.0);
                    double d8 = object4.getPosition((Axis)object2, d - d7 * 0.5, true, false).get(0);
                    double d9 = object4.getPosition((Axis)object2, d, true, false).get(0);
                    double d10 = object4.getPosition((Axis)object2, d + d7 * 0.5, true, false).get(0);
                    double d11 = object5.getPosition((Axis)object3, d2, true, false).get(1);
                    double d12 = object5.getPosition((Axis)object3, d3, true, false).get(1);
                    double d13 = object5.getPosition((Axis)object3, d4, true, false).get(1);
                    double d14 = object5.getPosition((Axis)object3, d5, true, false).get(1);
                    double d15 = object5.getPosition((Axis)object3, d6, true, false).get(1);
                    double d16 = Math.abs(d10 - d8);
                    double d17 = DataUtils.getValueOrDefault((Number)this.c.getSetting(BAR_WIDTH), 1.0);
                    double d18 = d8 + (1.0 - d17) * d16 / 2.0;
                    double d19 = d10 - (1.0 - d17) * d16 / 2.0;
                    object2 = new Rectangle2D.Double(d8 - d9, d14 - d13, d16, Math.abs(d14 - d12));
                    object3 = this.b.getBounds2D();
                    object4 = new AffineTransform();
                    ((AffineTransform)object4).translate(((RectangularShape)object2).getX(), ((RectangularShape)object2).getY());
                    ((AffineTransform)object4).scale(((RectangularShape)object2).getWidth() / ((RectangularShape)object3).getWidth(), ((RectangularShape)object2).getHeight() / ((RectangularShape)object3).getHeight());
                    ((AffineTransform)object4).translate(-((RectangularShape)object3).getMinX(), -((RectangularShape)object3).getMinY());
                    object2 = ((AffineTransform)object4).createTransformedShape(this.b);
                    object3 = new Line2D.Double(0.0, d14 - d13, 0.0, d15 - d13);
                    object4 = new Line2D.Double(0.0, d12 - d13, 0.0, d11 - d13);
                    object5 = new Line2D.Double(d18 - d9, d15 - d13, d19 - d9, d15 - d13);
                    Line2D.Double double_ = new Line2D.Double(d18 - d9, d11 - d13, d19 - d9, d11 - d13);
                    Line2D.Double double_2 = new Line2D.Double(d8 - d9, 0.0, d10 - d9, 0.0);
                    object = ((DrawingContext)object).getGraphics();
                    Object object7 = (ColorMapper)this.c.getSetting(BOX_BACKGROUND);
                    if (object7 instanceof ContinuousColorMapper) {
                        object6 = ((ContinuousColorMapper)object7).get(d);
                    } else {
                        Integer n7 = ((DataAccessor)object6).getIndex();
                        object6 = object7.get(n7);
                    }
                    Paint paint = (Paint)this.c.getSetting(BOX_COLOR);
                    object7 = (Stroke)this.c.getSetting(BOX_BORDER);
                    Paint paint2 = (Paint)this.c.getSetting(WHISKER_COLOR);
                    Stroke stroke = (Stroke)this.c.getSetting(WHISKER_STROKE);
                    Paint paint3 = (Paint)this.c.getSetting(BAR_CENTER_COLOR);
                    Stroke stroke2 = (Stroke)this.c.getSetting(BAR_CENTER_STROKE);
                    GraphicsUtils.fillPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object6, object2.getBounds2D());
                    object6 = ((Graphics2D)object).getPaint();
                    Stroke stroke3 = ((Graphics2D)object).getStroke();
                    ((Graphics2D)object).setPaint(paint2);
                    ((Graphics2D)object).setStroke(stroke);
                    ((Graphics2D)object).draw((Shape)object3);
                    ((Graphics2D)object).draw((Shape)object4);
                    ((Graphics2D)object).setPaint(paint);
                    ((Graphics2D)object).setStroke((Stroke)object7);
                    ((Graphics2D)object).draw((Shape)object2);
                    ((Graphics2D)object).draw((Shape)object5);
                    ((Graphics2D)object).draw(double_);
                    ((Graphics2D)object).setPaint(paint3);
                    ((Graphics2D)object).setStroke(stroke2);
                    ((Graphics2D)object).draw(double_2);
                    ((Graphics2D)object).setStroke(stroke3);
                    ((Graphics2D)object).setPaint((Paint)object6);
                }
            };
        }

        @Override
        public Shape getPointShape(PointData pointData) {
            return (Shape)this.getSetting(SHAPE);
        }

        @Override
        public Drawable getValue(PointData pointData, Shape shape) {
            return new AbstractDrawable(){
                private static final long serialVersionUID = 6788431763837737592L;

                public final void draw(DrawingContext drawingContext) {
                }
            };
        }

        @Override
        protected <T> void setSetting(Key key, T t, boolean bl) {
            if (t instanceof Paint && BOX_BACKGROUND.equals(key)) {
                super.setSetting(key, new SingleColor((Paint)t), bl);
                return;
            }
            super.setSetting(key, t, bl);
        }
    }
}

