/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.DataAccessor;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DummyData;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LinearRenderer2D;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.ValueLegend;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.plots.settings.Key;
import de.erichseifert.gral.plots.settings.SettingsStorage;
import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Location;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;

public class BarPlot
extends XYPlot {
    private static final long serialVersionUID = 3177733647455649147L;
    public static final Key BAR_WIDTH = new Key("barplot.bar.width");
    public static final Key BAR_HEIGHT_MIN = new Key("barplot.bar.heightMin");
    public static final Key PAINT_ALL_BARS = new Key("barplot.bar.paintAll");

    public BarPlot(DataSource ... dataSourceArray) {
        super(dataSourceArray);
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_X, false);
        this.setSettingDefault(BAR_WIDTH, 1.0);
        this.setSettingDefault(BAR_HEIGHT_MIN, 0.0);
        this.setSettingDefault(PAINT_ALL_BARS, false);
        this.setLegend(new BarPlotLegend(this));
    }

    public void autoscaleAxis(String string) {
        if ("x".equals(string) || "y".equals(string)) {
            Iterable<DataSource> iterable = this.getData();
            if (iterable.isEmpty()) {
                return;
            }
            iterable = iterable.get(0);
            Axis axis = this.getAxis(string);
            if (axis == null || !axis.isAutoscaled()) {
                return;
            }
            double d = this.getAxisMin(string);
            double d2 = this.getAxisMax(string);
            if ("x".equals(string)) {
                double d3 = DataUtils.getValueOrDefault((Number)this.getSetting(BAR_WIDTH), 1.0) * (d2 - d) / (double)iterable.getRowCount();
                axis.setRange(d - d3 / 2.0, d2 + d3 / 2.0);
                return;
            }
            if ("y".equals(string)) {
                d = Math.min(d, 0.0);
                d2 = Math.max(d2, 0.0);
                axis.setRange(d, d2);
            }
            return;
        }
        super.autoscaleAxis(string);
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        super.add(n, dataSource, bl);
        BarRenderer barRenderer = new BarRenderer(this);
        this.setPointRenderer(dataSource, barRenderer);
        this.setLineRenderer(dataSource, null);
        this.setAreaRenderer(dataSource, null);
    }

    public static class BarPlotLegend
    extends ValueLegend {
        private static final long serialVersionUID = 4752278896167602641L;
        private static final DataSource a = new DummyData(2, 1, Double.valueOf(0.5));
        private final BarPlot b;

        public BarPlotLegend(BarPlot barPlot) {
            this.b = barPlot;
        }

        public Drawable getSymbol(Row row) {
            return new AbstractLegend.AbstractSymbol(this, this, row){
                private static final long serialVersionUID = 5744026898590787285L;
                private /* synthetic */ Row a;
                private /* synthetic */ BarPlotLegend b;
                {
                    this.b = barPlotLegend;
                    this.a = row;
                    super(settingsStorage);
                }

                public final void draw(DrawingContext drawingContext) {
                    Object object = this.a.getSource();
                    Object object2 = new Row(a, this.a.getIndex());
                    Cloneable cloneable = this.getBounds();
                    double d = DataUtils.getValueOrDefault((Number)this.b.b.getSetting(BAR_WIDTH), 1.0);
                    Object object3 = new Axis(0.5 - d / 2.0, 0.5 + d / 2.0);
                    Object object4 = new LinearRenderer2D();
                    object4.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMaxY(), ((RectangularShape)cloneable).getMaxX(), ((RectangularShape)cloneable).getMaxY()));
                    Axis axis = new Axis(0.0, 0.5);
                    LinearRenderer2D linearRenderer2D = new LinearRenderer2D();
                    linearRenderer2D.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMaxY(), ((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMinY()));
                    object2 = new PointData(Arrays.asList(object3, axis), Arrays.asList(object4, linearRenderer2D), (Row)object2, 0);
                    object = this.b.b.getPointRenderer((DataSource)object);
                    object3 = null;
                    object4 = null;
                    if (object != null) {
                        object3 = object.getPointShape((PointData)object2);
                        object.getPoint((PointData)object2, (Shape)object3);
                        object4 = object.getPoint((PointData)object2, (Shape)object3);
                    }
                    object = new DataPoint((PointData)object2, new PointND((Number[])new Double[]{((RectangularShape)cloneable).getCenterX(), ((RectangularShape)cloneable).getMinY()}), (Drawable)object4, (Shape)object3, null);
                    object2 = drawingContext.getGraphics();
                    cloneable = ((DataPoint)object).position.getPoint2D();
                    object3 = ((Graphics2D)object2).getTransform();
                    ((Graphics2D)object2).translate(((Point2D)cloneable).getX(), ((Point2D)cloneable).getY());
                    ((DataPoint)object).drawable.draw(drawingContext);
                    ((Graphics2D)object2).setTransform((AffineTransform)object3);
                }
            };
        }
    }

    public static class BarRenderer
    extends DefaultPointRenderer2D {
        private static final long serialVersionUID = 2183638342305398522L;
        public static final Key STROKE = new Key("barplot.bar.stroke");
        public static final Key STROKE_COLOR = new Key("barplot.bar.stroke.color");
        private final SettingsStorage a;

        public BarRenderer(SettingsStorage settingsStorage) {
            this.a = settingsStorage;
            this.setSettingDefault(VALUE_LOCATION, Location.NORTH);
            this.setSettingDefault(STROKE, null);
            this.setSettingDefault(STROKE_COLOR, Color.BLACK);
        }

        public Drawable getPoint(PointData pointData, Shape shape) {
            return new AbstractDrawable(this, pointData, shape){
                private static final long serialVersionUID = -3145112034673683520L;
                private /* synthetic */ PointData a;
                private /* synthetic */ Shape b;
                private /* synthetic */ BarRenderer c;
                {
                    this.c = barRenderer;
                    this.a = pointData;
                    this.b = shape;
                }

                public final void draw(DrawingContext object) {
                    Object object2;
                    BarRenderer barRenderer = this.c;
                    Object object3 = this.a.row;
                    Rectangle2D.Double double_ = null;
                    object = ((DrawingContext)object).getGraphics();
                    object3 = ((ColorMapper)barRenderer.getSetting(PointRenderer.COLOR)).get(((DataAccessor)object3).getIndex());
                    Object object4 = (Boolean)this.c.a.getSetting(PAINT_ALL_BARS);
                    if (object4 != null && ((Boolean)object4).booleanValue()) {
                        object4 = ((Graphics2D)object).getTransform();
                        object2 = this.b.getBounds2D();
                        double_ = new Rectangle2D.Double();
                        double_ = new Rectangle2D.Double(((RectangularShape)object2).getX(), ((RectangularShape)double_).getY() - ((AffineTransform)object4).getTranslateY(), ((RectangularShape)object2).getWidth(), ((RectangularShape)double_).getHeight());
                    }
                    GraphicsUtils.fillPaintedShape((Graphics2D)object, this.b, (Paint)object3, double_);
                    object4 = (Stroke)barRenderer.getSetting(STROKE);
                    object2 = (Paint)barRenderer.getSetting(STROKE_COLOR);
                    if (object4 != null && object2 != null) {
                        GraphicsUtils.drawPaintedShape((Graphics2D)object, this.b, (Paint)object2, null, (Stroke)object4);
                    }
                }
            };
        }

        public Shape getPointShape(PointData object) {
            Axis axis = ((PointData)object).axes.get(0);
            Axis axis2 = ((PointData)object).axes.get(1);
            AxisRenderer axisRenderer = ((PointData)object).axisRenderers.get(0);
            AxisRenderer axisRenderer2 = ((PointData)object).axisRenderers.get(1);
            object = ((PointData)object).row;
            if (!((Row)object).isColumnNumeric(0) || !((Row)object).isColumnNumeric(1)) {
                return null;
            }
            double d = ((Number)((Object)((Row)object).get(0))).doubleValue();
            double d2 = ((Number)((Object)((Row)object).get(1))).doubleValue();
            double d3 = Math.max(DataUtils.getValueOrDefault((Number)this.a.getSetting(BAR_WIDTH), 1.0), 0.0);
            double d4 = axisRenderer.getPosition(axis, d - d3 * 0.5, true, false).get(0);
            double d5 = axisRenderer.getPosition(axis, d + d3 * 0.5, true, false).get(0);
            double d6 = axisRenderer2.getPosition(axis2, d2, true, false).get(1);
            double d7 = axisRenderer2.getPosition(axis2, 0.0, true, false).get(1);
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            double d10 = Math.abs(d5 - d4);
            double d11 = Math.abs(d9 - d8);
            double d12 = axisRenderer.getPosition(axis, d, true, false).get(0);
            boolean bl = d9 == d7;
            double d13 = bl ? 0.0 : -d11;
            double d14 = DataUtils.getValueOrDefault((Number)this.a.getSetting(BAR_HEIGHT_MIN), Double.NaN);
            if (MathUtils.isCalculatable(d14) && d14 > 0.0 && d11 < d14) {
                if (bl) {
                    d13 = 0.0 + (-d14 + d11);
                }
                d11 = d14;
            }
            return this.getBarShape(d4 - d12, d13, d10, d11);
        }

        protected Shape getBarShape(double d, double d2, double d3, double d4) {
            Shape shape = (Shape)this.getSetting(SHAPE);
            Rectangle2D rectangle2D = shape.getBounds2D();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(d, d2);
            affineTransform.scale(d3 / rectangle2D.getWidth(), d4 / rectangle2D.getHeight());
            affineTransform.translate(-rectangle2D.getMinX(), -rectangle2D.getMinY());
            return affineTransform.createTransformedShape(shape);
        }

        public Drawable getValue(PointData pointData, Shape shape) {
            return new AbstractDrawable(this, pointData, shape){
                private static final long serialVersionUID = -1133369168849171793L;
                private /* synthetic */ PointData a;
                private /* synthetic */ Shape b;
                private /* synthetic */ BarRenderer c;
                {
                    this.c = barRenderer;
                    this.a = pointData;
                    this.b = shape;
                }

                public final void draw(DrawingContext drawingContext) {
                    BarRenderer barRenderer = this.c;
                    Row row = this.a.row;
                    if (((Boolean)barRenderer.getSetting(PointRenderer.VALUE_DISPLAYED)).booleanValue()) {
                        int n = (Integer)barRenderer.getSetting(PointRenderer.VALUE_COLUMN);
                        this.c.drawValueLabel(drawingContext, this.b, row, n);
                    }
                }
            };
        }
    }
}

