/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataReader;
import de.erichseifert.gral.util.Messages;
import de.erichseifert.gral.util.StatefulTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader
extends AbstractDataReader {
    public static final String SEPARATOR_CHAR = "separator";

    public CSVReader(String string) {
        super(string);
        if ("text/tab-separated-values".equals(string)) {
            this.setDefault(SEPARATOR_CHAR, Character.valueOf('\t'));
            return;
        }
        this.setDefault(SEPARATOR_CHAR, Character.valueOf(','));
    }

    @Override
    public DataSource read(InputStream list, Class<? extends Comparable<?>> ... classArray) throws IOException {
        Object object;
        int n;
        list = new Scanner((InputStream)((Object)list)).useDelimiter("\\Z").next();
        Object object2 = (Character)this.getSetting(SEPARATOR_CHAR);
        list = new b(((Character)object2).charValue()).tokenize((String)((Object)list));
        if (((StatefulTokenizer.Token)(object2 = list.get(list.size() - 1))).getType() != a.c) {
            object2 = new StatefulTokenizer.Token(((StatefulTokenizer.Token)object2).getEnd(), ((StatefulTokenizer.Token)object2).getEnd(), (Object)a.c, "");
            list.add((StatefulTokenizer.Token)object2);
        }
        object2 = new HashMap();
        Object object3 = classArray;
        int n2 = classArray.length;
        for (n = 0; n < n2; ++n) {
            Class<Comparable<?>> clazz = object3[n];
            if (object2.containsKey(clazz) || (object = CSVReader.a(clazz)) == null) continue;
            object2.put(clazz, object);
        }
        object3 = new DataTable(classArray);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        n = 0;
        int n3 = 0;
        object = "";
        for (StatefulTokenizer.Token token : list) {
            if (token.getType() == a.a) {
                object = token.getContent();
                continue;
            }
            if (token.getType() != a.d && token.getType() != a.c) continue;
            if (n3 >= classArray.length) {
                throw new IllegalArgumentException(MessageFormat.format("Too many columns in line {0,number,integer}: got {1,number,integer}, but expected {2,number,integer}.", n + 1, n3 + 1, classArray.length));
            }
            Class<Comparable<?>> clazz = classArray[n3];
            Object object4 = (Method)object2.get(clazz);
            try {
                object4 = (Comparable)((Method)object4).invoke(null, object);
                linkedList.add(object4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(MessageFormat.format("Could not invoke method for parsing data type {0} in column {1,number,integer}.", classArray[n3].getSimpleName(), n3));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(MessageFormat.format("Could not access method for parsing data type {0} in column {1,number,integer}.", classArray[n3].getSimpleName(), n3));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException(MessageFormat.format("Type mismatch in line {0,number,integer}, column {1,number,integer}: got \"{2}\", but expected {3} value.", n + 1, n3 + 1, object, clazz.getSimpleName()));
            }
            ++n3;
            if (token.getType() != a.c) continue;
            if (linkedList.size() < classArray.length) {
                throw new IllegalArgumentException(MessageFormat.format("Not enough columns in line {0,number,integer}: got {1,number,integer}, but expected {2,number,integer}.", n + 1, linkedList.size(), classArray.length));
            }
            ((DataTable)object3).add(linkedList);
            ++n;
            linkedList.clear();
            n3 = 0;
            object = "";
        }
        return object3;
    }

    private static Method a(Class<?> methodArray) {
        Method method = null;
        if (String.class.isAssignableFrom((Class<?>)methodArray)) {
            try {
                method = String.class.getMethod("valueOf", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = null;
            }
        } else {
            for (Method method2 : methodArray.getMethods()) {
                Class<?>[] classArray;
                if (!(method2.toString().indexOf("static") >= 0) || !((classArray = method2.getParameterTypes()).length == 1 && String.class.equals(classArray[0])) || !method2.getName().startsWith("parse")) continue;
                method = method2;
            }
        }
        return method;
    }

    static {
        CSVReader.addCapabilities(new IOCapabilities("CSV", Messages.getString("DataIO.csvDescription"), "text/csv", new String[]{"csv", "txt"}));
        CSVReader.addCapabilities(new IOCapabilities("TSV", Messages.getString("DataIO.tsvDescription"), "text/tab-separated-values", new String[]{"tsv", "tab", "txt"}));
    }

    private static final class b
    extends StatefulTokenizer {
        public b(char c2) {
            this.addJoinedType((Object)a.a);
            this.addIgnoredType((Object)a.b);
            this.putRules(new StatefulTokenizer.Rule("\n|\r\n|\r", (Object)a.c), new StatefulTokenizer.Rule("\\s*(" + Pattern.quote(String.valueOf(c2)) + ")\\s*", (Object)a.d), new StatefulTokenizer.Rule("\"", (Object)a.b, "quoted"), new StatefulTokenizer.Rule(".", (Object)a.a));
            this.putRules("quoted", new StatefulTokenizer.Rule("(\")\"", (Object)a.a), new StatefulTokenizer.Rule("\"", (Object)a.b, "#pop"), new StatefulTokenizer.Rule(".", (Object)a.a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum a {
        a,
        b,
        c,
        d;

    }
}

